/*
 * Decompiled with CFR 0.152.
 */
package sbgc.encoder;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import org.apache.log4j.Logger;
import sbgc.service.SerialCommand;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;

public class ICMU {
    protected static final Log logger = new Log(Logger.getLogger((String)ICMU.class.getName()));
    public static final int RAW_DATA_PERIOD_MASK = 16383;
    public static final float RAW_DATA_PERIOD = 16384.0f;
    private static MU_3SL_interface lib;
    private ILogListener logListener;
    private MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments masterAdjustments;
    private MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments noniusAdjustments;
    MU_3SL_interface.MU_Calibration_NoniusTrackOffsetTable offsetTable;

    public void init() throws Throwable {
        if (lib == null) {
            lib = (MU_3SL_interface)Native.loadLibrary((String)(Platform.RESOURCE_PREFIX + "/MU_3SL_interface"), MU_3SL_interface.class);
            logger.info("IC-MU liblrary version: " + lib.MU_GetVersionString() + ", " + lib.MU_GetVersionSuffixString(), this.logListener);
        }
    }

    public void setLogListerner(ILogListener logListener) {
        this.logListener = logListener;
    }

    private static void checkInit() throws Exception {
        if (lib == null) {
            throw new Exception("Library is not initialized, call init() first");
        }
    }

    public void calculate(short[] masterData, short[] noniusData) throws Exception {
        ICMU.checkInit();
        Pointer calibration = lib.MU_createCalibration((byte)7);
        if (!calibration.equals((Object)Pointer.NULL)) {
            if (this.masterAdjustments == null || this.noniusAdjustments == null) {
                throw new Exception("The current calibration parameters are missed, required for a new calibration");
            }
            lib.MU_Calibration_setCurrentAnalogTrackAdjustments(calibration, this.masterAdjustments, this.noniusAdjustments);
            logger.info("Initial iC-MU signal conditioning parameters:\n" + this.getAnalogAdjustmentsInfo());
            Memory master = new Memory((long)(masterData.length * 2));
            Memory nonius = new Memory((long)(noniusData.length * 2));
            for (int i = 0; i < masterData.length; ++i) {
                master.setShort((long)(i * 2), masterData[i]);
                nonius.setShort((long)(i * 2), noniusData[i]);
            }
            Pointer analyzeResult = lib.MU_Calibration_analyzeRawData(calibration, (Pointer)master, (Pointer)nonius, new MU_3SL_interface.size_t(masterData.length));
            if (!analyzeResult.equals((Object)Pointer.NULL)) {
                this.printAnalyzeResultInfo(analyzeResult);
                lib.MU_Calibration_adjustAnalogByAnalyzeResult(calibration, analyzeResult);
                lib.MU_Calibration_getAnalogMasterTrackAdjustments(calibration, this.masterAdjustments);
                lib.MU_Calibration_getAnalogNoniusTrackAdjustments(calibration, this.noniusAdjustments);
                logger.info("iC-MU signal conditioning parameters after calibration:\n" + this.getAnalogAdjustmentsInfo(), this.logListener);
                this.offsetTable = new MU_3SL_interface.MU_Calibration_NoniusTrackOffsetTable();
                lib.MU_Calibration_getOptimizedNoniusTrackOffsetTable(analyzeResult, this.offsetTable);
                lib.MU_Calibration_setCurrentNoniusTrackOffsetTable(calibration, this.offsetTable);
                logger.info("Optimized nonius track offset table:\n" + this.getNoniusOffsetTableInfo(), this.logListener);
                lib.MU_CalibrationAnalyzeResult_delete(analyzeResult);
            }
            lib.MU_Calibration_delete(calibration);
        }
    }

    public boolean isCalibDataSet() {
        return this.masterAdjustments != null && this.noniusAdjustments != null && this.offsetTable != null;
    }

    public byte[] getCalibData() {
        if (this.isCalibDataSet()) {
            try {
                SerialCommand cmd = new SerialCommand(0);
                for (MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments a : new MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments[]{this.masterAdjustments, this.noniusAdjustments}) {
                    cmd.writeByteSigned(a.cosineGain);
                    cmd.writeByteSigned(a.sineOffset);
                    cmd.writeByteSigned(a.cosineOffset);
                    cmd.writeByteSigned(a.phase);
                    cmd.writeByteSigned(a.phaseRange);
                }
                cmd.writeByteSigned(this.offsetTable.spoBase);
                cmd.write(this.offsetTable.spoN);
                return cmd.getPayload();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCalibData(byte[] data) throws Exception {
        this.masterAdjustments = new MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments();
        this.noniusAdjustments = new MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments();
        this.offsetTable = new MU_3SL_interface.MU_Calibration_NoniusTrackOffsetTable();
        try {
            SerialCommand cmd = new SerialCommand(0, data);
            for (MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments a : new MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments[]{this.masterAdjustments, this.noniusAdjustments}) {
                a.cosineGain = cmd.readByteSigned();
                a.sineOffset = cmd.readByteSigned();
                a.cosineOffset = cmd.readByteSigned();
                a.phase = cmd.readByteSigned();
                a.phaseRange = cmd.readByteSigned();
            }
            this.offsetTable.spoBase = cmd.readByteSigned();
            cmd.read(this.offsetTable.spoN);
        }
        catch (Exception ignore) {
            throw new Exception("Incorrect data format");
        }
        logger.info("iC-MU current calibration data:\n" + this.getAnalogAdjustmentsInfo(), this.logListener);
        logger.info(this.getNoniusOffsetTableInfo(), this.logListener);
    }

    private void printAnalyzeResultInfo(Pointer analyzeResult) {
        int logSize = lib.MU_Calibration_getAnalyzeResultLog(analyzeResult, Pointer.NULL, new MU_3SL_interface.size_t(0L), 7);
        Memory buf = new Memory((long)(logSize + 1));
        lib.MU_Calibration_getAnalyzeResultLog(analyzeResult, (Pointer)buf, new MU_3SL_interface.size_t(buf.size()), 7);
        logger.info(buf.getString(0L), this.logListener);
    }

    public String getAnalogAdjustmentsInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Master track:\n");
        buf.append(ICMU.getAnalogTrackAdjustmentsInfo(this.masterAdjustments));
        buf.append("Nonius track:\n");
        buf.append(ICMU.getAnalogTrackAdjustmentsInfo(this.noniusAdjustments));
        return buf.toString();
    }

    public static String getAnalogTrackAdjustmentsInfo(MU_3SL_interface.MU_Calibration_AnalogTrackAdjustments adjustments) {
        return String.format("\tCosine gain (GX_x):     %4d (0x%02X)\n\tSine offset (VOSS_x):   %4d (0x%02X)\n\tCosine offset (VOSC_x): %4d (0x%02X)\n\tPhase (PH_x):           %4d (0x%02X)\n\tPhase range (PHR_x):    %4d (0x%02X)\n", adjustments.cosineGain & 0xFF, adjustments.cosineGain & 0xFF, adjustments.sineOffset & 0xFF, adjustments.sineOffset & 0xFF, adjustments.cosineOffset & 0xFF, adjustments.cosineOffset & 0xFF, adjustments.phase & 0xFF, adjustments.phase & 0xFF, adjustments.phaseRange & 0xFF, adjustments.phaseRange & 0xFF);
    }

    public String getNoniusOffsetTableInfo() {
        StringBuffer buf = new StringBuffer(String.format("SPO_BASE: %2d\n", this.offsetTable.spoBase));
        for (int i = 0; i < 16; ++i) {
            buf.append(String.format("\tSPO_%d:   %2d\n", i, this.offsetTable.spoN[i]));
        }
        return buf.toString();
    }

    public static float rawToDegrees(short angle) {
        return (float)(angle & 0x3FFF) * 0.021972656f;
    }

    public class ICMU_data {
        public int master = 0;
        public int nonius = 0;
    }

    public static interface MU_3SL_interface
    extends Library {
        public static final byte MU_REV_MU_Y2 = 7;
        public static final int MU_CALIBRATION_ANALYZE_RESULT_LOG_ALL = 7;

        public String MU_GetVersionString();

        public String MU_GetVersionSuffixString();

        public Pointer MU_createCalibration(byte var1);

        public void MU_Calibration_delete(Pointer var1);

        public Pointer MU_Calibration_analyzeRawData(Pointer var1, Pointer var2, Pointer var3, size_t var4);

        public void MU_CalibrationAnalyzeResult_delete(Pointer var1);

        public int MU_Calibration_getAnalyzeResultLog(Pointer var1, Pointer var2, size_t var3, int var4);

        public void MU_Calibration_adjustAnalogByAnalyzeResult(Pointer var1, Pointer var2);

        public void MU_Calibration_getAnalogMasterTrackAdjustments(Pointer var1, MU_Calibration_AnalogTrackAdjustments var2);

        public void MU_Calibration_getAnalogNoniusTrackAdjustments(Pointer var1, MU_Calibration_AnalogTrackAdjustments var2);

        public void MU_Calibration_setCurrentAnalogTrackAdjustments(Pointer var1, MU_Calibration_AnalogTrackAdjustments var2, MU_Calibration_AnalogTrackAdjustments var3);

        public void MU_Calibration_getOptimizedNoniusTrackOffsetTable(Pointer var1, MU_Calibration_NoniusTrackOffsetTable var2);

        public void MU_Calibration_setCurrentNoniusTrackOffsetTable(Pointer var1, MU_Calibration_NoniusTrackOffsetTable var2);

        public static class size_t
        extends IntegerType {
            public size_t() {
                this(0L);
            }

            public size_t(long value) {
                super(Native.SIZE_T_SIZE, value);
            }
        }

        @Structure.FieldOrder(value={"spoBase", "spoN"})
        public static class MU_Calibration_NoniusTrackOffsetTable
        extends Structure {
            public byte spoBase;
            public byte[] spoN = new byte[16];
        }

        @Structure.FieldOrder(value={"cosineGain", "sineOffset", "cosineOffset", "phase", "phaseRange"})
        public static class MU_Calibration_AnalogTrackAdjustments
        extends Structure {
            public byte cosineGain;
            public byte sineOffset;
            public byte cosineOffset;
            public byte phase;
            public byte phaseRange;
        }
    }
}

