/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sbgc.imu_calib.AdvancedCalibBase;
import sbgc.imu_calib.CalibPeriod;
import sbgc.imu_calib.ExtRefDataSample;
import sbgc.imu_calib.IExtRefSensorCalib;
import sbgc.imu_calib.SensorCalib;
import sbgc.imu_calib.SensorCalibOptimized;
import sbgc.object.BoardParams;
import sbgc.object.IMUCalib;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.SimplexOptimizerImpl;
import sbgc.utils.ArrayIterator;
import sbgc.utils.MathUtils;

public class AccGyroAdvancedCalib
extends AdvancedCalibBase {
    public static final int SBGC32_ADVANCED_CALIB_SAMPLERATE = 125;
    public static final int DATA_SAMPLES_ACC_TO_GYRO_ALIGN_MAX = 22500;
    public static final int VARIANCE_NUM_SAMPLES = 125;
    public static final int INITIAL_VARIANCE_NUM_SAMPLES = 250;
    public static final int STATIC_DETECTOR_STEP_SIZE = 4;
    public static final float GYRO_VARIANCE_STATIC_MIN = 5.0f;
    public static final float GYRO_VARIANCE_STATIC_MAX = 10.0f;
    public static final float VARIANCE_MULT_STATIC_TO_MOTION = 4.0f;
    public static final float VARIANCE_MULT_MOTION_TO_STATIC = 2.0f;
    public static final int STATIC_MIN_TIME_MS = 1500;
    public static final int STATIC_POSITION_MIN_NUM = 12;
    public static final float SBGC32_ACC_1G = 512.0f;
    public static final float SBGC32_GYRO_FULL_RANGE = 2000.0f;
    public static final float SBGC32_GYRO_RAD_US_SCALE = 1.065297E-9f;
    public static final float ACC_OPTIMIZE_MAX_ALLOWED_RESIDUAL = 5.0f;
    public static final float GYRO_OPTIMIZE_MAX_ALLOWED_RESIDUAL = 20.0f;
    public static final float ACC_TO_GYRO_ALIGN_CORR_RAD_MAX = 0.05235988f;
    public static final float GYRO_MOTION_MIN_RAD = (float)Math.PI * 4;
    float initVariance;
    float variance;
    int staticTime_us;
    float[] gyroMotion = new float[3];
    boolean isStatic = true;
    int phaseStartIdx = 0;
    CalibPeriod curPeriod = null;
    CalibPeriod prevPeriod = null;
    final ArrayList<CalibPeriod> periodList = new ArrayList();
    int staticCnt = 0;
    int staticIgnoreCnt = 0;

    public AccGyroAdvancedCalib(IExtRefSensorCalib extRefSensorCalibListener, IMUCalib imuCalib, int calibMode) {
        super(extRefSensorCalibListener, imuCalib, calibMode, 22500);
        this.progressDialog.showState(true);
        this.progressDialog.showFinishButton(true);
        this.progressDialog.enableFinishButton(false);
    }

    @Override
    List<String> getDataFields() {
        return Arrays.asList("gyro_x", "gyro_y", "gyro_z", "acc_x", "acc_y", "acc_z", "dt_us");
    }

    float calcSquareVariance(int atIdx, int length) {
        ArrayIterator<ExtRefDataSample> range = new ArrayIterator<ExtRefDataSample>(this.samples, atIdx - length / 2, atIdx + length / 2);
        float[] mean = new float[3];
        for (ExtRefDataSample s : range) {
            MathUtils.vector_inc(mean, s.ext_data);
        }
        MathUtils.vector_mult_var(mean, 1.0f / (float)range.size());
        float variance = 0.0f;
        for (ExtRefDataSample s : range) {
            for (int j = 0; j < 3; ++j) {
                float d = s.ext_data[j] - mean[j];
                variance += d * d;
            }
        }
        return variance / (float)range.size();
    }

    public void acc_sens_raw_map_to_sbgc32(float[] accRaw) {
        accRaw[0] = -accRaw[0];
        accRaw[1] = -accRaw[1];
    }

    public void gyro_sens_raw_map_to_sbgc32(float[] gyroRaw) {
        gyroRaw[2] = -gyroRaw[2];
    }

    public void mag_sens_raw_map_to_sbgc32(float[] magRaw) {
        magRaw[2] = -magRaw[2];
    }

    private void updateStatusInfo() {
        boolean passed = this.staticCnt >= 12;
        int[] percent = new int[3];
        for (int axis = 0; axis < 3; ++axis) {
            percent[axis] = MathUtils.constrain(Math.round(this.gyroMotion[axis] * 100.0f / ((float)Math.PI * 4)), 0, 100);
            if (percent[axis] >= 100) continue;
            passed = false;
        }
        this.progressDialog.setStatusInfo(String.format("Rotations X: %d%%, Y: %d%%, Z: %d%%, static positions: %d of %d, ignored: %d", percent[0], percent[1], percent[2], this.staticCnt, 12, this.staticIgnoreCnt));
        this.progressDialog.enableFinishButton(passed);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onSampleAdded(int sampleIdx) throws Exception {
        ExtRefDataSample sample = this.samples[sampleIdx];
        if (sampleIdx < 250) {
            if (sampleIdx == 0) {
                this.progressDialog.setState(false, "initializing, do not move..");
                this.staticTime_us = 0;
            }
            this.staticTime_us += sample.dt_us;
        } else if (sampleIdx == 250) {
            this.initVariance = this.calcSquareVariance(125, 250);
            logger.debug(String.format("Initial variance: %.4f", Float.valueOf(this.initVariance)));
            this.variance = this.initVariance = Math.max(this.initVariance, 5.0f);
            if (this.initVariance > 10.0f) {
                throw new Exception("Initialization phase was not static! Please, restart calibration in absolutely static conditions!");
            }
        } else {
            int idx = sampleIdx - 62;
            if (sampleIdx % 4 == 0) {
                this.variance = this.calcSquareVariance(idx, 125);
            }
            if (sampleIdx % 10 == 0) {
                logger.trace(String.format("variance: %.4f", Float.valueOf(this.variance)));
            }
            if (this.isStatic) {
                if (this.variance > this.initVariance * 4.0f) {
                    CalibPeriod p = new CalibPeriod();
                    int nextPhaseIdx = idx - 4;
                    int numSamples = nextPhaseIdx - this.phaseStartIdx;
                    for (int i = this.phaseStartIdx; i < this.phaseStartIdx + numSamples; ++i) {
                        MathUtils.vector_inc(p.accAvg, this.samples[i].ext_data);
                        MathUtils.vector_inc(p.gyroBias, this.samples[i].int_data);
                        p.static_time_ms += this.samples[i].dt_us;
                    }
                    p.static_time_ms /= 1000;
                    if (p.static_time_ms > 1500) {
                        MathUtils.vector_mult_var(p.accAvg, 1.0f / (float)numSamples);
                        MathUtils.vector_mult_var(p.gyroBias, 1.0f / (float)numSamples);
                        boolean exists = false;
                        for (CalibPeriod calibPeriod : this.periodList) {
                            if (!(MathUtils.vector_dist(calibPeriod.accAvg, p.accAvg) < 175.11432f)) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            ++this.staticCnt;
                            this.updateStatusInfo();
                        }
                        this.periodList.add(p);
                        if (this.curPeriod != null) {
                            void var9_15;
                            this.curPeriod.accAvgNext = p.accAvg;
                            float[] gyroSum = new float[3];
                            for (ExtRefDataSample s : this.curPeriod.gyroSamples) {
                                MathUtils.vector_inc_mult_var(gyroSum, s.int_data, (float)s.dt_us * 1.065297E-9f);
                            }
                            boolean bl = false;
                            while (var9_15 < 3) {
                                void v0 = var9_15;
                                this.gyroMotion[v0] = this.gyroMotion[v0] + Math.abs(gyroSum[var9_15]);
                                ++var9_15;
                            }
                        }
                    } else {
                        ++this.staticIgnoreCnt;
                        logger.warn(String.format("Period is too short: %d ms", p.static_time_ms));
                    }
                    this.phaseStartIdx = nextPhaseIdx;
                    this.isStatic = false;
                    this.curPeriod = p;
                    this.staticTime_us = 0;
                    this.progressDialog.setState(true, "moving to new position..");
                } else {
                    this.staticTime_us += sample.dt_us;
                    if (this.staticTime_us > 1650000 && !this.progressDialog.getState()) {
                        this.progressDialog.setState(true, "move to new position");
                        this.updateStatusInfo();
                    }
                }
            } else if (this.variance < this.initVariance * 2.0f) {
                int nextPhaseIdx = idx + 4;
                if (this.curPeriod != null) {
                    this.curPeriod.gyroSamples = new ArrayIterator<ExtRefDataSample>(this.samples, this.phaseStartIdx, nextPhaseIdx);
                    for (ExtRefDataSample s : this.curPeriod.gyroSamples) {
                        this.curPeriod.motion_time_ms += s.dt_us;
                    }
                    this.curPeriod.motion_time_ms /= 1000;
                }
                logger.debug(String.format("Period %d: static time=%d ms, motion time=%d ms", this.periodList.size(), this.curPeriod.static_time_ms, this.curPeriod.motion_time_ms));
                this.phaseStartIdx = nextPhaseIdx;
                this.isStatic = true;
                this.progressDialog.setState(false, "calibrating, do not move..");
            }
        }
    }

    @Override
    void process() throws Exception {
        StringBuilder err = new StringBuilder();
        if (this.staticCnt < 12) {
            err.append(String.format("Not enoguh static positions: %d of %d\n", this.staticCnt, 12));
        }
        for (int axis = 0; axis < 3; ++axis) {
            if (!(this.gyroMotion[axis] < (float)Math.PI * 4)) continue;
            err.append("Not enoguh rotations by " + BoardParams.AXIS_NAME[axis] + " axis\n");
        }
        if (err.length() > 0 && !this.confirmWarningAndContinue(err.toString())) {
            throw new Exception("Cancelled by user.");
        }
        logger.debug("Calibrating accelerometer..");
        SensorCalibOptimized accCalib = new SensorCalibOptimized(SensorCalib.SensorType.ACC, 0.1f, 100.0f, 0.08726646f, 0.0f);
        SimplexOptimizerImpl accOptimizer = new SimplexOptimizerImpl(new IOptimizable(){
            float[] acc_calibrated = new float[3];

            @Override
            public float cost_function(IOptimizedParams p, float progress) throws Exception {
                SensorCalib c = (SensorCalib)((Object)p);
                float err = 0.0f;
                for (CalibPeriod period : AccGyroAdvancedCalib.this.periodList) {
                    c.apply(period.accAvg, this.acc_calibrated);
                    float diff = MathUtils.vector_mod(this.acc_calibrated) - 512.0f;
                    err += diff * diff;
                }
                return err / (float)AccGyroAdvancedCalib.this.periodList.size();
            }

            @Override
            public void iteration_step(IOptimizedParams p, float progress) {
            }
        }, this, false, 2000, 0);
        float cost = accOptimizer.optimize(accCalib);
        if (cost > 5.0f && !this.confirmWarningAndContinue(String.format("Accelerometer calibration did not find a good solution.\nError is %.4f", Float.valueOf(cost)))) {
            throw new Exception("Cancelled by user.");
        }
        for (CalibPeriod period : this.periodList) {
            accCalib.apply(period.accAvg, period.accAvg);
            this.acc_sens_raw_map_to_sbgc32(period.accAvg);
        }
        logger.debug("Calibrating gyroscope..");
        SensorCalibOptimized gyroCalib = new SensorCalibOptimized(SensorCalib.SensorType.GYRO, 0.05f, 0.0f, 0.08726646f, 0.05235988f);
        SimplexOptimizerImpl gyroOptimizer = new SimplexOptimizerImpl(new IOptimizable(){
            float[] tmp_f = new float[3];
            float[] acc_f = new float[3];

            @Override
            public float cost_function(IOptimizedParams p, float progress) throws Exception {
                SensorCalib gyroCalib = (SensorCalib)((Object)p);
                float err = 0.0f;
                float errCnt = 0.0f;
                for (CalibPeriod period : AccGyroAdvancedCalib.this.periodList) {
                    if (period.gyroSamples == null || period.accAvgNext == null) continue;
                    MathUtils.vector_copy(gyroCalib.bias, period.gyroBias);
                    MathUtils.vector_copy(this.acc_f, period.accAvg);
                    for (ExtRefDataSample s : period.gyroSamples) {
                        gyroCalib.apply(s.int_data, this.tmp_f);
                        AccGyroAdvancedCalib.this.gyro_sens_raw_map_to_sbgc32(this.tmp_f);
                        MathUtils.vector_mult_var(this.tmp_f, (float)s.dt_us * 1.065297E-9f);
                        MathUtils.vector_rotate(this.acc_f, this.tmp_f);
                    }
                    MathUtils.vector_dec(this.acc_f, period.accAvgNext);
                    err += MathUtils.vector_pow2(this.acc_f);
                    errCnt += 1.0f;
                }
                return err / errCnt;
            }

            @Override
            public void iteration_step(IOptimizedParams p, float progress) {
            }
        }, this, false, 2000, 0);
        cost = gyroOptimizer.optimize(gyroCalib);
        if (cost > 20.0f && !this.confirmWarningAndContinue(String.format("Gyroscope calibration did not find a good solution.\nError is %.4f", Float.valueOf(cost)))) {
            throw new Exception("Cancelled by the user.");
        }
        if (this.imuCalib != null) {
            for (int i = 0; i < 3; ++i) {
                accCalib.align_corr[i] = -gyroCalib.align_corr[i];
                gyroCalib.align_corr[i] = 0.0f;
            }
            MathUtils.vector_set_zero(gyroCalib.bias);
            for (CalibPeriod period : this.periodList) {
                MathUtils.vector_inc(gyroCalib.bias, period.gyroBias);
            }
            MathUtils.vector_mult_var(gyroCalib.bias, 1.0f / (float)this.periodList.size());
            accCalib.saveIMUCalib(this.imuCalib);
            gyroCalib.saveIMUCalib(this.imuCalib);
        }
        this.onCalibrationFinished(null);
    }
}

