/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.ArrayList;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.Log;

public class AdjVarInfo {
    public int id;
    public String name;
    public int range_min;
    public int range_max;
    public long value;

    public static AdjVarInfo[] getFromBoard(IProgressListener progressListener) throws Exception {
        Log logger = Log.getLogger(SerialCommandProcessor.class.getName());
        logger.info("Requesting CMD_ADJ_VARS_INFO...");
        boolean rtState = RealtimeDataThread.pause(true);
        try {
            int lastId = 0;
            int totalNum = 0;
            ArrayList<AdjVarInfo> list = new ArrayList<AdjVarInfo>();
            do {
                SerialCommand cmd = new SerialCommand(132);
                cmd.writeByte(lastId);
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                if (resp == null || resp.id != cmd.id) {
                    throw new Exception("No response on CMD_ADJ_VARS_INFO");
                }
                if (resp.getBytesAvailable() <= 1 || (totalNum = resp.readByte()) == 0) break;
                while (resp.getBytesAvailable() >= 10) {
                    AdjVarInfo var = new AdjVarInfo();
                    var.id = resp.readByte();
                    var.name = resp.readString();
                    var.range_min = resp.readWord();
                    var.range_max = resp.readWord();
                    var.value = resp.readDWord();
                    var.name = var.name.replaceAll("\\.r$", ".ROLL").replaceAll("\\.p$", ".PITCH").replaceAll("\\.y$", ".YAW");
                    list.add(var);
                    lastId = var.id + 1;
                }
                resp.checkFinished();
                if (progressListener == null) continue;
                progressListener.onProgressChange(list.size() * 100 / totalNum);
            } while (list.size() < totalNum);
            logger.info("Received " + list.size() + " adjustable variables.");
            AdjVarInfo[] adjVarInfoArray = list.toArray(new AdjVarInfo[0]);
            return adjVarInfoArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            RealtimeDataThread.pause(rtState);
        }
    }
}

