/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

@XStreamAlias(value="saved-configuration")
public class BoardParamsSavedData {
    static final Log logger = Log.getLogger(BoardParamsSavedData.class.getName());
    @XStreamAlias(value="board-params")
    public BoardParams params = null;
    @XStreamAlias(value="profile")
    public BoardProfile profile = null;
    @XStreamAlias(value="all-profiles")
    public BoardProfile[] profiles = null;
    public int firmwareVer = 0;
    public int buildNumber = 0;
    public int appVer = 0;
    public int boardVer = 0;
    public long boardFeatures = 0L;

    public BoardParamsSavedData(BoardParams params, int profile_idx, BoardInfo info) {
        this.params = params;
        if (profile_idx >= 0) {
            this.profile = params.profiles[profile_idx];
        } else {
            this.profiles = params.profiles;
        }
        if (info != null) {
            this.firmwareVer = info.getFrwVer();
            this.buildNumber = info.getBuildNumber();
            this.boardVer = info.boardVer;
            this.boardFeatures = info.boardFeatures;
        }
        this.appVer = SimpleBGC_GUIApp.version.getFullVer();
    }

    public BoardParams join(BoardParams current, int currentProfile) throws Exception {
        BoardInfo info = BoardInfo.getBoardInfo();
        if (this.params == null) {
            this.params = current;
        }
        this.params.curProfile = currentProfile;
        if (current.profiles.length < currentProfile + 1) {
            throw new Exception("Current board params implementation does not support more than " + this.params.profiles.length + " profiles!");
        }
        if (this.profiles != null) {
            this.params.profiles = this.profiles;
        } else if (this.profile != null) {
            for (int i = 0; i < current.profiles.length; ++i) {
                this.params.profiles[i] = i == currentProfile ? this.profile : current.profiles[i];
            }
        } else {
            throw new Exception("File contains no profile data!");
        }
        this.params = (BoardParams)BoardParamsSavedData.validate(this.params, current, "params");
        try {
            Integer curAppVer = SimpleBGC_GUIApp.version.getFullVer();
            if (this.appVer == 0 || this.appVer != curAppVer) {
                this.params.onAppVersionChange(this.appVer);
                if (this.profiles != null) {
                    for (BoardProfile p : this.profiles) {
                        p.onAppVersionChange(this.params, this.appVer);
                    }
                } else if (this.profile != null) {
                    this.profile.onAppVersionChange(this.params, this.appVer);
                }
            }
            if (info != null && (this.firmwareVer == 0 || info.getFrwVer() > 0 && info.getFrwVer() != this.firmwareVer)) {
                this.params.onFirmwareVersionChange(this.firmwareVer, info.getFrwVer());
                if (this.profiles != null) {
                    for (BoardProfile p : this.profiles) {
                        p.onFirmwareVersionChange(this.params, this.firmwareVer, info.getFrwVer());
                    }
                } else if (this.profile != null) {
                    this.profile.onFirmwareVersionChange(this.params, this.firmwareVer, info.getFrwVer());
                }
            }
            this.params.onProfileFileLoaded(this.firmwareVer, this.appVer);
            if (this.profiles != null) {
                for (BoardProfile p : this.profiles) {
                    p.onProfileFileLoaded(this.firmwareVer, this.appVer);
                }
            } else if (this.profile != null) {
                this.profile.onProfileFileLoaded(this.firmwareVer, this.appVer);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to handle change in versions: " + e.toString());
            logger.stackTrace(e);
        }
        return this.params;
    }

    static Object validate(Object new_obj, Object ref_obj, String name) throws Exception {
        Object new_obj_copy = new_obj;
        if (ref_obj != null) {
            if (new_obj != null && new_obj.getClass().equals(ref_obj.getClass())) {
                if (ref_obj.getClass().isArray()) {
                    new_obj = ref_obj;
                    for (int i = 0; i < Math.min(Array.getLength(ref_obj), Array.getLength(new_obj_copy)); ++i) {
                        Array.set(new_obj, i, BoardParamsSavedData.validate(Array.get(new_obj_copy, i), Array.get(ref_obj, i), name));
                    }
                } else if (!ref_obj.getClass().isAssignableFrom(Number.class) && !ref_obj.getClass().isAssignableFrom(String.class)) {
                    for (Field f : ref_obj.getClass().getFields()) {
                        if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                        f.set(new_obj, BoardParamsSavedData.validate(f.get(new_obj), f.get(ref_obj), f.getName()));
                    }
                }
            } else {
                if (new_obj == null) {
                    logger.warn("Missed field " + name);
                } else {
                    logger.warn("Class mismatch: " + new_obj.getClass().getCanonicalName() + " over " + ref_obj.getClass().getCanonicalName());
                }
                new_obj = ref_obj;
            }
        }
        return new_obj;
    }
}

