/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.Arrays;
import sbgc.service.SerialCommand;
import sbgc.utils.FileUtil;

public class CanDrvHardParams
implements Cloneable {
    public int board_ver;
    public int format_ver;
    public int out_type;
    public int op_amp_type;
    public int op_amp_gain;
    public int R_shunt;
    public int R_offset;
    public int dead_time;
    public int ADC_rise_delay;
    public int ADC_sampling_time;
    public int bat_voltage_ADC_ratio;
    public int max_PWM_duty;
    public int peak_current;
    public byte[] reserved = new byte[42];

    public void formatSerialCommand(SerialCommand cmd) throws Exception {
        int start_len = cmd.len;
        cmd.writeByte(this.board_ver);
        cmd.writeByte(this.format_ver);
        cmd.writeByte(this.out_type);
        cmd.writeByte(this.op_amp_type);
        cmd.writeWord(this.op_amp_gain);
        cmd.writeWord(this.R_shunt);
        cmd.writeWord(this.R_offset);
        cmd.writeWord(this.dead_time);
        cmd.writeWord(this.ADC_rise_delay);
        cmd.writeByte(this.ADC_sampling_time);
        cmd.writeWord(this.bat_voltage_ADC_ratio);
        cmd.writeByte(this.max_PWM_duty);
        cmd.writeWord(this.peak_current);
        cmd.write(this.reserved);
        cmd.writeWord(FileUtil.crc16_sbgc32(cmd.data, start_len, cmd.len - start_len));
    }

    public void parseSerialCommand(SerialCommand cmd) throws Exception {
        int start_pos = cmd.pos;
        this.board_ver = cmd.readByte();
        this.format_ver = cmd.readByte();
        this.out_type = cmd.readByte();
        this.op_amp_type = cmd.readByte();
        this.op_amp_gain = cmd.readWordUnsigned();
        this.R_shunt = cmd.readWordUnsigned();
        this.R_offset = cmd.readWordUnsigned();
        this.dead_time = cmd.readWordUnsigned();
        this.ADC_rise_delay = cmd.readWordUnsigned();
        this.ADC_sampling_time = cmd.readByte();
        this.bat_voltage_ADC_ratio = cmd.readWordUnsigned();
        this.max_PWM_duty = cmd.readByte();
        this.peak_current = cmd.readWordUnsigned();
        cmd.read(this.reserved);
        int crc16 = FileUtil.crc16_sbgc32(cmd.data, start_pos, cmd.pos - start_pos);
        int crc16_file = cmd.readWordUnsigned();
        if (crc16 != crc16_file) {
            throw new Exception("Bad CRC (calculated " + crc16 + " != stored " + crc16_file + ")");
        }
    }

    public CanDrvHardParams clone() throws CloneNotSupportedException {
        CanDrvHardParams copy = (CanDrvHardParams)super.clone();
        copy.reserved = Arrays.copyOf(this.reserved, this.reserved.length);
        return copy;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CanDrvHardParams) {
            CanDrvHardParams p = (CanDrvHardParams)o;
            boolean res = this.format_ver == p.format_ver;
            res &= this.out_type == p.out_type;
            res &= this.op_amp_type == p.op_amp_type;
            res &= this.op_amp_gain == p.op_amp_gain;
            res &= this.R_shunt == p.R_shunt;
            res &= this.R_offset == p.R_offset;
            res &= this.dead_time == p.dead_time;
            res &= this.ADC_rise_delay == p.ADC_rise_delay;
            res &= this.ADC_sampling_time == p.ADC_sampling_time;
            res &= this.bat_voltage_ADC_ratio == p.bat_voltage_ADC_ratio;
            res &= this.max_PWM_duty == p.max_PWM_duty;
            res &= this.peak_current == p.peak_current;
            return res &= Arrays.equals(this.reserved, p.reserved);
        }
        return false;
    }
}

