/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sbgc.service.DataOutputStreamLE;
import sbgc.service.SerialCommand;

public class CustomTune {
    public static final String[] NOTE_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static final double SEMITONE_FACTOR = 1.05946;
    public static final double NOTE_BASE_FREQ = 440.0;
    public static final int NOTE_BASE_IDX = 57;
    public static final double NOTE_MIN_FREQ = 554.36;
    public static final double NOTE_MAX_FREQ = 7902.0;
    public static final int NOTE_PAUSE = 21000;

    public static String bytesToString(byte[] data) throws Exception {
        StringBuilder s = new StringBuilder();
        SerialCommand cmd = new SerialCommand(0, data);
        s.append(cmd.readByte());
        s.append(", ");
        s.append(cmd.readByte());
        s.append(", ");
        cmd.skipBytes(8);
        while (cmd.getBytesAvailable() > 0) {
            int note_freq = cmd.readWordUnsigned();
            if (note_freq == 21000) {
                s.append(";");
            } else if (note_freq > 21000) {
                s.append("P");
                s.append(note_freq - 21000);
            } else {
                s.append(CustomTune.getNoteName(note_freq));
            }
            s.append(" ");
        }
        return s.substring(0, s.length() - 1);
    }

    public static byte[] stringToBytes(String melody) throws Exception {
        if (melody.isEmpty()) {
            return null;
        }
        ArrayList<Integer> note_freq = new ArrayList<Integer>();
        try {
            Matcher matcher = Pattern.compile("^(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(.+)$").matcher(melody);
            if (matcher.matches()) {
                int length = Math.max(0, Math.min(255, Integer.parseInt(matcher.group(1))));
                int decay = Math.max(0, Math.min(15, Integer.parseInt(matcher.group(2))));
                String notesStr = matcher.group(3);
                for (String note : Pattern.compile("\\s+").split(notesStr)) {
                    if (note.equalsIgnoreCase(";")) {
                        note_freq.add(21000);
                        continue;
                    }
                    if (note.substring(0, 1).equalsIgnoreCase("P")) {
                        int pause_length = note.length() > 1 ? Math.max(0, Integer.parseInt(note.substring(1, note.length()))) : 0;
                        note_freq.add(21000 + pause_length);
                        continue;
                    }
                    double freq = CustomTune.getNoteFreq(note);
                    if (freq < 553.86) {
                        throw new Exception("Note '" + note + "' is too low!");
                    }
                    if (freq > 7902.5) {
                        throw new Exception("Note '" + note + "' is too high!");
                    }
                    note_freq.add((int)Math.round(freq));
                }
                if (note_freq.size() > 0) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStreamLE out = new DataOutputStreamLE(bos);
                    out.writeByte(length);
                    out.writeByte(decay);
                    for (int i = 0; i < 8; ++i) {
                        out.writeByte(0);
                    }
                    for (Integer freq : note_freq) {
                        out.writeShort(freq);
                    }
                    return bos.toByteArray();
                }
                throw new Exception("Melody is empty");
            }
            throw new Exception("Wrong melody format");
        }
        catch (Exception e) {
            throw new Exception("Failed to parse melody string: " + e.getMessage(), e);
        }
    }

    public static String getNoteName(double note_freq) {
        double note = 440.0;
        int note_idx = 57;
        while (true) {
            double next_note;
            if ((next_note = note * 1.05946) > note_freq || next_note > 7902.0) {
                if (!(next_note - note_freq < Math.abs(note_freq - note))) break;
                ++note_idx;
                break;
            }
            note = next_note;
            ++note_idx;
        }
        return NOTE_NAMES[note_idx % 12] + Integer.toString(note_idx / 12);
    }

    public static double getNoteFreq(String name) throws Exception {
        int idx;
        String octave;
        String note;
        if (name.length() == 2) {
            note = name.substring(0, 1);
            octave = name.substring(1, 2);
        } else {
            note = name.substring(0, 2);
            octave = name.substring(2, 3);
        }
        for (idx = 0; idx < 12 && !NOTE_NAMES[idx].equalsIgnoreCase(note); ++idx) {
        }
        if (idx == 12) {
            throw new Exception("Unknow note '" + note + "'!");
        }
        int octaveInt = Integer.parseInt(octave);
        idx += octaveInt * 12;
        double freq = 440.0;
        for (int i = 57; i < idx; ++i) {
            freq *= 1.05946;
        }
        return freq;
    }
}

