/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import sbgc.object.BoardInfo;
import sbgc.object.DebugVar;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DebugVars {
    private static DebugVar[] vars;
    private static HashMap<String, Integer> byName;
    private static long[] requestedMask;
    static int info_start_idx;

    public static void requestDebugVarsInfo(int start_idx) {
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null) {
            info_start_idx = start_idx;
            if (start_idx == 0) {
                vars = null;
            }
            SimpleBGC_GUIApp.getLogger().info("Requesting debug variables info starting from " + start_idx + "..");
            try {
                SerialCommand cmd = new SerialCommand(253);
                if (start_idx > 0) {
                    cmd.writeByte(start_idx);
                }
                SerialCommandProcessor.sendCommand(cmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void parseInfo(SerialCommand cmd) throws IOException {
        int size = cmd.readByte();
        if (vars == null || vars.length != size) {
            vars = new DebugVar[size];
            byName = new HashMap(size);
        }
        int last_idx = -1;
        for (int i = info_start_idx; i < size && cmd.getBytesAvailable() > 0; ++i) {
            DebugVar var = new DebugVar();
            var.name = cmd.readString();
            int type = cmd.readByte();
            var.type = type & 0xF;
            var.flags = type & 0xC0;
            var.axis = ((type & 0x30) >> 4) - 1;
            cmd.skipBytes(2);
            var.idx = i;
            last_idx = i;
            DebugVars.vars[i] = var;
            byName.put(var.name, new Integer(var.idx));
        }
        cmd.checkFinished();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (DebugVar v : vars) {
                        if (v == null) continue;
                        SimpleBGC_GUIApp.mainView.panelMonitoring.addDebugVar(v);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (last_idx > 0 && last_idx < size - 1 && BoardInfo.hasAdvancedDebugVars()) {
            DebugVars.requestDebugVarsInfo(last_idx + 1);
        }
    }

    public static void parse(SerialCommand cmd) {
        try {
            if (BoardInfo.hasAdvancedDebugVars() && requestedMask != null) {
                for (int i = 0; i < requestedMask.length; ++i) {
                    if (requestedMask[i] == cmd.readDWordUnsigned()) continue;
                    throw new Exception("Incorrect bit mask in response");
                }
            }
            DebugVars.parseVars(cmd, vars, requestedMask);
        }
        catch (Exception e) {
            SimpleBGC_GUIApp.getLogger().warn("CMD_DEBUG_VARS_3 parse error: " + e.toString());
        }
    }

    public static void parseVars(SerialCommand cmd, DebugVar[] vars, long[] _requestedMask) throws Exception {
        if (vars == null) {
            throw new Exception("Wrong state: vars is null");
        }
        for (DebugVar v : vars) {
            if (v == null) continue;
            if (cmd.getBytesAvailable() > 0 && DebugVars.isVarRequested(v.idx, _requestedMask)) {
                switch (v.type) {
                    case 1: {
                        v.value = cmd.readByte();
                        break;
                    }
                    case 2: {
                        v.value = cmd.readByteSigned();
                        break;
                    }
                    case 3: {
                        v.value = cmd.readWordUnsigned();
                        break;
                    }
                    case 4: {
                        v.value = cmd.readWord();
                        break;
                    }
                    case 5: {
                        v.value = (int)cmd.readDWordUnsigned();
                        break;
                    }
                    case 6: {
                        v.value = (int)cmd.readDWord();
                        break;
                    }
                    case 7: {
                        v.value = (int)cmd.readFloat();
                        break;
                    }
                    default: {
                        throw new Exception("Unsupported var type: " + v.type);
                    }
                }
                SimpleBGC_GUIApp.mainView.panelMonitoring.setChartData(v.id, v.value, cmd.timestamp);
                continue;
            }
            SimpleBGC_GUIApp.mainView.panelMonitoring.setChartDataUnknown(v.id);
        }
    }

    public static boolean hasInfo() {
        return vars != null;
    }

    public static DebugVar[] getVars() {
        return vars;
    }

    public static void setVars(DebugVar[] _vars) {
        vars = _vars;
    }

    public static DebugVar get(String name) {
        Integer idx;
        if (vars != null && (idx = byName.get(name)) != null && idx < vars.length) {
            return vars[idx];
        }
        return null;
    }

    public static boolean fillRequestCommand(SerialCommand cmd) {
        boolean hasVars = false;
        cmd.reset();
        if (BoardInfo.hasAdvancedDebugVars() && vars != null) {
            try {
                int idx;
                requestedMask = new long[(vars.length - 1) / 32 + 1];
                for (idx = 0; idx < vars.length; ++idx) {
                    DebugVar var = vars[idx];
                    if (var == null || var.trace == null || !var.trace.isEnabled()) continue;
                    int n = idx / 32;
                    requestedMask[n] = requestedMask[n] | (long)(1 << idx % 32);
                    hasVars = true;
                }
                for (int i = 0; i <= (idx - 1) / 32; ++i) {
                    cmd.writeDWord(requestedMask[i]);
                }
            }
            catch (Exception ignore) {
                requestedMask = null;
            }
        } else {
            hasVars = true;
            requestedMask = null;
        }
        return hasVars;
    }

    public static boolean isVarRequested(int idx, long[] requestedMask) {
        return requestedMask == null || (requestedMask[idx / 32] & (long)(1 << idx % 32)) != 0L;
    }
}

