/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.Arrays;
import java.util.zip.CRC32;
import sbgc.service.SerialCommand;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.HexUtil;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ExtDeviceInfo {
    public static final int TYPE_GPS_IMU = 1;
    public static final int GPS_IMU_FIRMWARE_ADDRESS = 0x8010000;
    public static final int GPS_IMU_RUN_ADDRESS = 0x8000000;
    public static final int GPS_IMU_INFO_SECTION_OFFSET = 512;
    public static final int GPS_IMU_INFO_SECTION_LENGTH = 512;
    public static final int GPS_IMU_CRC_OFFSET = 528;
    public static final int GPS_IMU_KEY = 1171385218;
    public static final long GPS_IMU_DEV_FEAT_DEBUG_MODE = 0x80000000L;
    public int type = 0;
    long hw_ver_bin = 0L;
    long hw_ver_compat = 0L;
    public int hw_ver_major = 0;
    public int hw_ver_minor = 0;
    public VersionImpl sw_ver;
    public VersionImpl sat_ver = null;
    public int sat_hw_ver_major = 0;
    public int sat_hw_ver_minor = 0;
    public String mcu_sn = null;
    public String device_id = null;
    public long key = 0L;
    public long crc32 = 0L;
    public long size = 0L;
    public long device_features;
    public String versionStr = null;

    public static ExtDeviceInfo parse_GPS_IMU_CMD_DEVICE_INFO(SerialCommand resp) throws Exception {
        ExtDeviceInfo info = new ExtDeviceInfo();
        info._parse_GPS_IMU_CMD_DEVICE_INFO(resp);
        return info;
    }

    private void _parse_GPS_IMU_CMD_DEVICE_INFO(SerialCommand resp) throws Exception {
        this.type = 1;
        this.set_hw_ver(resp.readDWordUnsigned());
        this.hw_ver_compat = resp.readDWordUnsigned();
        this.set_sw_ver(resp.readWordUnsigned(), (int)resp.readDWordUnsigned());
        this.mcu_sn = HexUtil.toHex(resp.readBytes(12));
        if (resp.getBytesAvailable() >= 9) {
            this.device_id = HexUtil.toHex(resp.readBytes(9));
            if (resp.getBytesAvailable() >= 6) {
                int sat_hw_ver = resp.readWordUnsigned();
                this.sat_hw_ver_major = sat_hw_ver / 100;
                this.sat_hw_ver_minor = sat_hw_ver % 100;
                this.sat_ver = VersionImpl.getVerBase100(resp.readWordUnsigned(), resp.readWordUnsigned());
                if (resp.getBytesAvailable() >= 4) {
                    this.device_features = resp.readDWordUnsigned();
                }
            }
        }
        this.versionStr = this.toString();
    }

    public static ExtDeviceInfo readFromFirmware(byte[] data, int type) throws Exception {
        ExtDeviceInfo info = new ExtDeviceInfo();
        info.type = type;
        SerialCommand cmd = new SerialCommand(0, Arrays.copyOfRange(data, 512, 1024));
        info.key = cmd.readDWordUnsigned();
        info.hw_ver_compat = cmd.readDWordUnsigned();
        info.set_sw_ver((int)cmd.readDWordUnsigned(), (int)cmd.readDWordUnsigned());
        info.crc32 = cmd.readDWordUnsigned();
        info.size = cmd.readDWordUnsigned();
        return info;
    }

    public void set_hw_ver(long hw_ver_bin) {
        this.hw_ver_bin = hw_ver_bin;
        this.hw_ver_major = HexUtil.firstBitPos(hw_ver_bin >> 8) + 1;
        this.hw_ver_minor = (int)(hw_ver_bin & 0xFFL);
    }

    public void set_sw_ver(int sw_ver_int, int build_num) {
        this.sw_ver = VersionImpl.getVerBase100(sw_ver_int, build_num);
    }

    public String toString() {
        String str = String.format("hardware: %d.%d, firmware: %d.%02d, build: %d", this.hw_ver_major, this.hw_ver_minor, this.sw_ver.getMajorVer(), this.sw_ver.getMinorVer(), this.sw_ver.getBuildNum(), this.mcu_sn);
        if (this.mcu_sn != null) {
            str = str + ", MCU s/n: " + this.mcu_sn;
        }
        if (this.sat_ver != null && this.sat_ver.getFullVer() != 0) {
            str = "Sensor module " + str + String.format("; Satellite module hardware: %d.%02d, firmware: %d.%02d, build: %d", this.sat_hw_ver_major, this.sat_hw_ver_minor, this.sat_ver.getMajorVer(), this.sat_ver.getMinorVer(), this.sat_ver.getBuildNum());
        }
        return str;
    }

    private Exception getUnsupportedTypeException() {
        return new Exception("Unsupported type: " + this.type);
    }

    public int getFirmwareAddress() throws Exception {
        if (this.type == 1) {
            return 0x8010000;
        }
        throw this.getUnsupportedTypeException();
    }

    public int getRunAddress() throws Exception {
        if (this.type == 1) {
            return 0x8000000;
        }
        throw this.getUnsupportedTypeException();
    }

    public int[] getFirmwarePages() throws Exception {
        if (this.type == 1) {
            return new int[]{2, 3, 4, 5, 6, 7};
        }
        throw this.getUnsupportedTypeException();
    }

    public void checkFirmware(ExtDeviceInfo frwInfo) throws Exception {
        if (this.type == 1) {
            if (frwInfo.key != 1171385218L || (frwInfo.hw_ver_compat & this.hw_ver_bin & 0xFFFF00L) == 0L) {
                throw new Exception("Attempt to load inappropriate firmware for this device!");
            }
        } else {
            throw this.getUnsupportedTypeException();
        }
    }

    public void checkCRC(byte[] data) throws Exception {
        if (this.type == 1) {
            CRC32 crc = new CRC32();
            crc.update(data, 0, 528);
            crc.update(new byte[4]);
            crc.update(data, 532, data.length - 532);
            SimpleBGC_GUIApp.getLogger().debug(String.format("CRC calculated: %h, stored: %h", crc.getValue(), this.crc32));
            if (crc.getValue() != this.crc32) {
                throw new Exception("CRC32 check failed!");
            }
        } else {
            throw this.getUnsupportedTypeException();
        }
    }

    public boolean has_feature(long flags) {
        return (this.device_features & flags) != 0L;
    }

    public boolean isDebugMode() {
        return this.type == 1 && this.has_feature(0x80000000L);
    }
}

