/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Arrays;
import sbgc.service.SerialCommand;

public class ExtIMU
implements Cloneable {
    public static final int EXT_IMU_FLAG_not_used = 1;
    public static final int EXT_IMU_FLAG_ACC_COMP_ONLY = 2;
    public static final int EXT_IMU_FLAG_REPLACE = 4;
    public static final int EXT_IMU_FLAG_Z1 = 8;
    public static final int EXT_IMU_FLAG_H1 = 16;
    public static final int EXT_IMU_FLAG_FRAME_UPSIDE_DOWN_UPDATE = 32;
    public static final int EXT_IMU_FLAG_AS_FRAME_IMU = 64;
    public static final int EXT_IMU_FLAG_GYRO_CORR = 128;
    public static final int EXT_IMU_FLAG_GYRO_CALIB_STARTUP = 256;
    public static final int TYPE_MAVLINK1 = 1;
    public static final int TYPE_MAVLINK2 = 2;
    public static final int TYPE_VN200 = 3;
    public static final int TYPE_INERTIALSENSE_UAHRS = 4;
    public int type;
    public int port;
    public int position;
    public int orientation;
    public int flags;
    public int[] align_corr = new int[3];
    public int startup_delay;
    public int gyro_corr_rate;
    public int[] reserved = new int[4];

    public void readConfig(SerialCommand cmd) throws IOException {
        this.type = cmd.readByte();
        this.port = cmd.readByte();
        this.position = cmd.readByte();
        this.orientation = cmd.readByte();
        this.flags = cmd.readWordUnsigned();
        this.align_corr = cmd.readWord3();
        this.startup_delay = cmd.readByte();
        this.gyro_corr_rate = cmd.readByte();
        cmd.readByteArr(this.reserved);
    }

    public void writeConfig(SerialCommand cmd) throws IOException {
        cmd.writeByte(this.type);
        cmd.writeByte(this.port);
        cmd.writeByte(this.position);
        cmd.writeByte(this.orientation);
        cmd.writeWord(this.flags);
        cmd.writeWordArr(this.align_corr);
        cmd.writeByte(this.startup_delay);
        cmd.writeByte(this.gyro_corr_rate);
        cmd.writeByteArr(this.reserved);
    }

    public void onFirmwareVersionChange(int old_ver, int cur_ver) {
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null || !(other instanceof ExtIMU)) {
            return false;
        }
        ExtIMU m = (ExtIMU)other;
        return this.type == m.type && this.port == m.port && this.position == m.position && this.orientation == m.orientation && this.flags == m.flags && Arrays.equals(this.align_corr, m.align_corr) && Arrays.equals(this.reserved, m.reserved) && this.startup_delay == m.startup_delay && this.gyro_corr_rate == m.gyro_corr_rate;
    }

    public ExtIMU clone() {
        ExtIMU copy = null;
        try {
            copy = (ExtIMU)super.clone();
            copy.align_corr = Arrays.copyOf(this.align_corr, 3);
            copy.reserved = Arrays.copyOf(this.reserved, this.reserved.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return copy;
    }
}

