/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Arrays;
import sbgc.service.SerialCommand;
import sbgc.utils.FileUtil;
import simplebgc_gui.SimpleBGC_GUIApp;

public class GeometryCfg
implements Cloneable {
    public static final int EEPROM_CFG_ADDR = 4544;
    public static final int EEPROM_CFG_SIZE = 64;
    public static final int FLAG_MAG_ENABLE = 1;
    public static final int SPLIT_REC_MAG_ORIGIN_SENSOR = 1;
    public static final int FORMAT_VER_MAJOR = 1;
    public static final int FORMAT_VER_MINOR = 0;
    @XStreamOmitField
    public int format_ver;
    public int flags;
    public int[][] motor_offset = new int[3][3];
    public int split_receiver_origin;
    public int[] split_receiver_offset = new int[3];
    public int split_receiver_mag_origin;
    public int split_receiver_mag_axis_top;
    public int split_receiver_mag_axis_right;
    public int reserved1;
    public byte[] reserved = new byte[30];

    public GeometryCfg() {
    }

    public GeometryCfg(byte[] data) throws Exception {
        this.parse(data);
    }

    public byte[] pack() throws Exception {
        SerialCommand cmd = new SerialCommand(0, 64);
        cmd.writeByte(16);
        cmd.writeByte(this.reserved1);
        cmd.writeWord(this.flags);
        for (int mot = 0; mot < 3; ++mot) {
            for (int axis = 0; axis < 3; ++axis) {
                cmd.writeWord(this.motor_offset[mot][axis]);
            }
        }
        cmd.writeByte(this.split_receiver_origin);
        for (int axis = 0; axis < 3; ++axis) {
            cmd.writeWord(this.split_receiver_offset[axis]);
        }
        cmd.writeByte(this.split_receiver_mag_origin);
        cmd.writeByteSigned(this.split_receiver_mag_axis_top);
        cmd.writeByteSigned(this.split_receiver_mag_axis_right);
        cmd.write(this.reserved);
        cmd.writeWord(FileUtil.crc16_sbgc32(cmd.data, 0, cmd.len));
        cmd.checkFull();
        return cmd.data;
    }

    public void parse(byte[] data) throws Exception {
        SerialCommand cmd = new SerialCommand(0, data);
        this.format_ver = cmd.readByte();
        this.reserved1 = cmd.readByte();
        this.flags = cmd.readWordUnsigned();
        for (int mot = 0; mot < 3; ++mot) {
            for (int axis = 0; axis < 3; ++axis) {
                this.motor_offset[mot][axis] = cmd.readWord();
            }
        }
        this.split_receiver_origin = cmd.readByte();
        for (int axis = 0; axis < 3; ++axis) {
            this.split_receiver_offset[axis] = cmd.readWord();
        }
        this.split_receiver_mag_origin = cmd.readByte();
        this.split_receiver_mag_axis_top = cmd.readByteSigned();
        this.split_receiver_mag_axis_right = cmd.readByteSigned();
        cmd.read(this.reserved);
        int crc16 = FileUtil.crc16_sbgc32(cmd.data, 0, cmd.pos);
        int crc16_file = cmd.readWordUnsigned();
        if (crc16 != crc16_file) {
            throw new Exception("Bad CRC (calculated " + crc16 + " != stored " + crc16_file + ")");
        }
        cmd.checkFinished();
    }

    public GeometryCfg clone() {
        GeometryCfg copy = null;
        try {
            copy = (GeometryCfg)super.clone();
            copy.motor_offset = (int[][])Arrays.stream(this.motor_offset).map(rec$ -> (int[])((int[])rec$).clone()).toArray(x$0 -> new int[x$0][]);
            copy.split_receiver_offset = Arrays.copyOf(this.split_receiver_offset, this.split_receiver_offset.length);
            copy.reserved = Arrays.copyOf(this.reserved, this.reserved.length);
        }
        catch (Exception e) {
            SimpleBGC_GUIApp.getLogger().stackTrace(e);
        }
        return copy;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null || !(other instanceof GeometryCfg)) {
            return false;
        }
        GeometryCfg m = (GeometryCfg)other;
        return this.flags == m.flags && this.split_receiver_origin == m.split_receiver_origin && this.split_receiver_mag_origin == m.split_receiver_mag_origin && this.split_receiver_mag_axis_top == m.split_receiver_mag_axis_top && this.split_receiver_mag_axis_right == m.split_receiver_mag_axis_right && Arrays.deepEquals((Object[])this.motor_offset, (Object[])m.motor_offset) && Arrays.equals(this.split_receiver_offset, m.split_receiver_offset) && Arrays.equals(this.reserved, m.reserved);
    }

    public static boolean isSplitRecOrientationNeeded(int mag_origin) {
        return mag_origin != 1;
    }

    public void validate() throws Exception {
        if ((this.flags & 1) != 0 && GeometryCfg.isSplitRecOrientationNeeded(this.split_receiver_mag_origin) && this.split_receiver_mag_axis_top == this.split_receiver_mag_axis_right) {
            throw new Exception("GPS_IMU Split - Magnetometer orientation is invalid: 'Axis TOP' is equal to 'Axis RIGHT'");
        }
    }
}

