/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;

public class IMUCalib {
    public static final int FILE_CALIB_TYPE_IMU_SIMPLE = 1;
    public static final int FILE_CALIB_TYPE_IMU_GYRO_TEMP = 2;
    public static final int FILE_CALIB_TYPE_IMU_ACC_TEMP = 3;
    public static final int SIMPLE_CALIB_SIZE = 128;
    public static final float ORTH_CORR_INT16_FLOAT_SCALE_DEG = 0.001f;
    public static final float GYRO_SCALE_INT_TO_FLOAT = 3.051851E-6f;
    public static final float GYRO_BIAS_FRACT = 16.0f;
    public int version;
    public int[] acc_zero;
    public int[] acc_scale;
    public int[] gyro_zero;
    public int[] gyro_zero_ext;
    public int[] mag_limits;
    public int[] mag_orth_corr;
    public int[] acc_orth_corr;
    public int[] acc_gyro_align_corr;
    public int[] gyro_orth_corr;
    public int[] gyro_scale;
    public byte[] reserved;

    public static int getCalibFileId(int type, boolean isFrameIMU) {
        return 768 + (type | (isFrameIMU ? 128 : 0));
    }

    public void parse(byte[] data) throws Exception {
        SerialCommand cmd = new SerialCommand(0, data);
        this.version = cmd.readByte();
        this.acc_zero = cmd.readWord3();
        this.acc_scale = cmd.readWord3();
        this.gyro_zero = cmd.readWord3();
        this.mag_limits = cmd.readWordArr(6);
        this.mag_orth_corr = cmd.readWord3();
        this.acc_orth_corr = cmd.readWord3();
        this.acc_gyro_align_corr = cmd.readWord3();
        this.gyro_orth_corr = cmd.readWord3();
        this.gyro_scale = cmd.readWord3();
        this.gyro_zero_ext = cmd.readWord3();
        this.reserved = cmd.readBytes(59);
        int crc16 = cmd.readWordUnsigned();
        if (FileUtil.crc16_sbgc32(cmd.data, 0, 126) != crc16) {
            throw new Exception("CRC16 is not valid, data may be corrupted!");
        }
        if (cmd.getBytesAvailable() != 0) {
            throw new Exception("Wrong format in 'parse()' function!");
        }
        for (int i = 0; i < 3; ++i) {
            if (this.acc_scale[i] != 0) continue;
            this.acc_scale[i] = 1000;
        }
    }

    public byte[] pack() throws Exception {
        SerialCommand cmd = new SerialCommand(0, 128);
        cmd.writeByte(this.version);
        cmd.writeWordArr(this.acc_zero);
        cmd.writeWordArr(this.acc_scale);
        cmd.writeWordArr(this.gyro_zero);
        cmd.writeWordArr(this.mag_limits);
        cmd.writeWordArr(this.mag_orth_corr);
        cmd.writeWordArr(this.acc_orth_corr);
        cmd.writeWordArr(this.acc_gyro_align_corr);
        cmd.writeWordArr(this.gyro_orth_corr);
        cmd.writeWordArr(this.gyro_scale);
        cmd.writeWordArr(this.gyro_zero_ext);
        cmd.write(this.reserved);
        cmd.writeWord(FileUtil.crc16_sbgc32(cmd.data, 0, 126));
        if (cmd.getBytesFree() != 0) {
            throw new Exception("Wrong format in 'pack()' function!");
        }
        return cmd.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMUCalib read(IProgressListener progressListener) throws Exception {
        progressListener.onProgressStart("Reading IMU calibrations", false);
        try {
            int fileId = IMUCalib.getCalibFileId(1, false);
            byte[] data = SerialCommandProcessor.readFile(fileId, progressListener);
            IMUCalib c = new IMUCalib();
            c.parse(data);
            IMUCalib iMUCalib = c;
            return iMUCalib;
        }
        finally {
            progressListener.onProgressFinish(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IProgressListener progressListener) throws Exception {
        progressListener.onProgressStart("Writing IMU calibrations", false);
        try {
            int fileId = IMUCalib.getCalibFileId(1, false);
            byte[] data = this.pack();
            SerialCommandProcessor.writeFile(fileId, data, progressListener);
            SerialCommandProcessor.sendCmdExecuteMenu(7);
        }
        finally {
            progressListener.onProgressFinish(true);
        }
    }

    public float getAccScale(int i) {
        return (float)this.acc_scale[i] / 1000.0f;
    }

    public void setAccScale(int i, float val) {
        this.acc_scale[i] = Math.round(val * 1000.0f);
    }

    public float getAccBias(int i) {
        return this.acc_zero[i];
    }

    public void setAccBias(int i, float val) {
        this.acc_zero[i] = Math.round(val);
    }

    public float getAccOrthCorrDeg(int i) {
        return (float)this.acc_orth_corr[i] * 0.001f;
    }

    public void setAccOrthCorrDeg(int i, float val) {
        this.acc_orth_corr[i] = Math.round(val / 0.001f);
    }

    public float getAccGyroAlignCorrDeg(int i) {
        return (float)this.acc_gyro_align_corr[i] / 1000.0f;
    }

    public void setAccGyroAlignCorrDeg(int i, float val) {
        this.acc_gyro_align_corr[i] = Math.round(val * 1000.0f);
    }

    public float getGyroScale(int i) {
        return 1.0f + (float)this.gyro_scale[i] * 3.051851E-6f;
    }

    public void setGyroScale(int i, float val) {
        this.gyro_scale[i] = Math.round((val - 1.0f) / 3.051851E-6f);
    }

    public float getGyroBias(int i) {
        return (float)this.gyro_zero[i] * 0.0625f + (float)this.gyro_zero_ext[i] * 9.537034E-7f;
    }

    public void setGyroBias(int i, float val) {
        this.gyro_zero[i] = Math.round(val * 16.0f);
        this.gyro_zero_ext[i] = Math.round((val - (float)this.gyro_zero[i] * 0.0625f) * 1048544.0f);
    }

    public float getGyroOrthCorrDeg(int i) {
        return (float)this.gyro_orth_corr[i] * 0.001f;
    }

    public void setGyroOrthCorrDeg(int i, float val) {
        this.gyro_orth_corr[i] = Math.round(val / 0.001f);
    }
}

