/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Arrays;
import sbgc.service.SerialCommand;

public class Motor4 {
    public static final int OUTPUT_TYPE_MASK = 224;
    public static final int OUTPUT_TYPE_SERVO = 32;
    public static final int OUTPUT_TYPE_CAN_DRV = 64;
    public static final int OUTPUT_ID_MASK = 7;
    public static final int START_FIRMWARE_VER = 2680;
    public int pid_P;
    public int pid_I;
    public int pid_D;
    public int speed_scale;
    public int servo_neutral;
    public int servo_range;
    public int axis;
    public int pid_D_LPF;
    public int motor_out;
    public int limits_width;
    public int limits_weight;
    public int servo_P;
    public int[] reserved = new int[4];

    public void readConfig(SerialCommand cmd) throws IOException {
        this.pid_P = cmd.readWordUnsigned();
        this.pid_I = cmd.readWordUnsigned();
        this.pid_D = cmd.readWordUnsigned();
        this.servo_neutral = cmd.readWordUnsigned();
        this.speed_scale = cmd.readWordUnsigned();
        this.servo_range = cmd.readByte();
        this.axis = cmd.readByteSigned();
        this.pid_D_LPF = cmd.readByte();
        this.motor_out = cmd.readByte();
        this.limits_width = cmd.readByte();
        this.limits_weight = cmd.readByte();
        this.servo_P = cmd.readByte();
        cmd.readByteArr(this.reserved);
    }

    public void writeConfig(SerialCommand cmd) throws IOException {
        cmd.writeWord(this.pid_P);
        cmd.writeWord(this.pid_I);
        cmd.writeWord(this.pid_D);
        cmd.writeWord(this.servo_neutral);
        cmd.writeWord(this.speed_scale);
        cmd.writeByte(this.servo_range);
        cmd.writeByte(this.axis);
        cmd.writeByte(this.pid_D_LPF);
        cmd.writeByte(this.motor_out);
        cmd.writeByte(this.limits_width);
        cmd.writeByte(this.limits_weight);
        cmd.writeByte(this.servo_P);
        cmd.writeByteArr(this.reserved);
    }

    public void onFirmwareVersionChange(int old_ver, int cur_ver) {
        if (old_ver < 2680) {
            this.pid_D = 1000;
            this.pid_P = 1000;
            this.pid_I = 1000;
            this.speed_scale = 100;
            this.servo_neutral = 1500;
            this.servo_range = 120;
            this.pid_D_LPF = 10;
            this.limits_width = 15;
            this.limits_weight = 100;
            this.servo_P = 0;
        }
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null || !(other instanceof Motor4)) {
            return false;
        }
        Motor4 m = (Motor4)other;
        return this.pid_P == m.pid_P && this.pid_I == m.pid_I && this.pid_D == m.pid_D && this.speed_scale == m.speed_scale && this.servo_neutral == m.servo_neutral && this.servo_range == m.servo_range && this.axis == m.axis && this.pid_D_LPF == m.pid_D_LPF && this.motor_out == m.motor_out && this.limits_width == m.limits_width && this.limits_weight == m.limits_weight && this.servo_P == m.servo_P && Arrays.equals(this.reserved, m.reserved);
    }
}

