/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.Arrays;
import sbgc.object.BoardParams;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;

public class PasswordProtection {
    public static final long FLAG_ENCRYPT_PARAMS = 2L;
    public static final long FLAG_IS_SILENT = 4L;
    public static final long FLAG_CH_ENABLED = 16L;
    public static final long ENABLED_MASK = 1008L;
    public static final long FLAG_CH_SERVICE_ALLOW = 1024L;
    public static final long FLAG_PASSWORD_IS_SET = 0x80000000L;
    public long flags;
    public int[] reserved = new int[4];

    public PasswordProtection() {
    }

    public PasswordProtection(PasswordProtection ref) {
        this.flags = ref.flags;
        this.reserved = Arrays.copyOf(ref.reserved, ref.reserved.length);
    }

    public boolean isEnabled() {
        return (this.flags & 0x3F0L) != 0L;
    }

    public boolean isSilent() {
        return (this.flags & 4L) != 0L;
    }

    public void setSilent(boolean val) {
        this.flags = BoardParams.updateBitL(this.flags, 4L, val);
    }

    public boolean isEncryptParams() {
        return (this.flags & 2L) != 0L;
    }

    public void setEncryptParams(boolean val) {
        this.flags = BoardParams.updateBitL(this.flags, 2L, val);
    }

    public boolean isChProtected(int ch_idx) {
        return (this.flags & 16L << ch_idx) != 0L;
    }

    public void setChProtected(int ch_idx, boolean val) {
        this.flags = BoardParams.updateBitL(this.flags, 16L << ch_idx, val);
    }

    public boolean isChAllow(int ch_idx) {
        return (this.flags & 1024L << ch_idx) != 0L;
    }

    public void setChAllow(int ch_idx, boolean val) {
        this.flags = BoardParams.updateBitL(this.flags, 1024L << ch_idx, val);
    }

    public boolean isPasswordSet() {
        return (this.flags & 0x80000000L) != 0L;
    }

    public boolean isNewPortEnabled(PasswordProtection old) {
        return (this.flags & (old.flags ^ 0xFFFFFFFFFFFFFFFFL) & 0x3F0L) != 0L;
    }

    public void read() throws Exception {
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(new SerialCommand(136), 3000L);
        if (resp == null || resp.getId() != 136) {
            throw new Exception("Timeout waiting answer.");
        }
        this.flags = resp.readDWordUnsigned();
        resp.readByteArr(this.reserved);
    }

    public void write(String newPassword) throws Exception {
        SerialCommand resp;
        SerialCommand cmd = new SerialCommand(137);
        cmd.writeDWord(this.flags);
        cmd.writeByteArr(this.reserved);
        if (newPassword != null && newPassword.length() > 0) {
            cmd.writeString(newPassword);
        }
        if ((resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L)) == null || resp.getId() != 67) {
            throw new Exception("Timeout waiting answer.");
        }
    }
}

