/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import sbgc.object.BoardParams;
import sbgc.object.CanDrvSoftParams;
import sbgc.object.IExtMotorParams;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

@XStreamAlias(value="reaction-params")
public class ReactionParams
implements Cloneable,
IExtMotorParams {
    public static final int FORMAT_VER_CUR = 0;
    public static final int FLAG_INVERTED = 1;
    public int axis;
    public int drvId = 0;
    public int flags = 0;
    public int hpf = 0;
    public int brake = 10;

    public ReactionParams(int axis) {
        this.axis = axis;
    }

    public static ReactionParams readFromParams(int axis, int drv_id, BoardParams params) {
        ReactionParams p = new ReactionParams(axis);
        if (drv_id > 0 && drv_id <= 7) {
            try {
                p.read(params.CAN_Drv_soft_params[drv_id - 1]);
                p.drvId = drv_id;
            }
            catch (Exception e) {
                SimpleBGC_GUIApp.getLogger().warn(e.toString());
            }
        }
        return p;
    }

    @Override
    public int getDrvId() {
        return this.drvId;
    }

    @Override
    public String getFunctionName() {
        return "Reaction Wheel " + this.axis;
    }

    @Override
    public void write(CanDrvSoftParams sp, boolean overwrite) throws Exception {
        if (sp == null) {
            throw new Exception("Can't write configuration: CanDrvSoftParams is null");
        }
        SerialCommand cmd = new SerialCommand(0, 5);
        cmd.writeByte(0);
        cmd.writeWord(this.flags);
        cmd.writeByte(this.hpf);
        cmd.writeByte(this.brake);
        cmd.checkFull();
        sp.setExtraCfgBytes(1, cmd.data, overwrite);
    }

    private void read(CanDrvSoftParams sp) throws Exception {
        if (sp == null) {
            throw new Exception("Can't read configuration: CanDrvSoftParams is null");
        }
        SerialCommand cmd = new SerialCommand(0, sp.getExtraCfgBytes(1, 5));
        int format_ver = cmd.readByte();
        this.flags = cmd.readWordUnsigned();
        this.hpf = cmd.readByte();
        this.brake = cmd.readByte();
        cmd.checkFinished();
    }

    public ReactionParams clone() throws CloneNotSupportedException {
        ReactionParams copy = (ReactionParams)super.clone();
        return copy;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ReactionParams) {
            ReactionParams p = (ReactionParams)o;
            boolean res = true;
            res &= this.flags == p.flags;
            res &= this.hpf == p.hpf;
            return res &= this.brake == p.brake;
        }
        return false;
    }
}

