/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.util.Date;
import javax.swing.SwingUtilities;
import sbgc.object.BoardInfo;
import sbgc.object.ErrorInfo;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class RealtimeData {
    private static RealtimeData tmp1 = new RealtimeData();
    private static RealtimeData tmp2 = new RealtimeData();
    private static RealtimeData curRealtimeData = tmp1;
    public static final int RC_CHANNEL_ROLL = 0;
    public static final int RC_CHANNEL_PITCH = 1;
    public static final int RC_CHANNEL_YAW = 2;
    public static final int RC_CHANNEL_CMD = 3;
    public static final int RC_CHANNEL_FC_ROLL = 4;
    public static final int RC_CHANNEL_FC_PITCH = 5;
    public static final String[] RC_DATA_NAMES = new String[]{"RC_ROLL", "RC_PITCH", "RC_YAW", "RC_CMD", "EXT_FC_ROLL", "EXT_FC_PITCH"};
    public static final int RC_DATA_UNDEF = -8500;
    public static final int RC_UNDEF16 = Short.MIN_VALUE;
    public static final int RC_MIN_VAL = -500;
    public static final int RC_MAX_VAL = 500;
    public static final int RC_RANGE = 1000;
    public static final int RC_MIN_VAL16 = -16384;
    public static final int RC_MAX_VAL16 = 16384;
    public static final int RC_RANGE16 = 32768;
    public static final float ANGLE14_DEGREE_SCALE = 0.021972656f;
    public static final float DEGREE_ANGLE14_SCALE = 45.511112f;
    public static final float ANGLE14_RAD_SCALE = 3.834952E-4f;
    public static final float GYRO_DEG_S_SCALE = 0.06103702f;
    public static final float GYRO_RAD_S_SCALE = 0.0010652969f;
    public static final int BALANCE_ERROR_MAX = 512;
    public static final int CALIB_MODE_BODE_TEST = 9;
    public static final long STATE_FLAG_SHAKE_GENERATOR_ENABLED = 256L;
    public Date regDate = null;
    public int[] acc = new int[3];
    public int[] gyro = new int[3];
    public int[] debug = new int[4];
    public int[] rcData = new int[]{-8500, -8500, -8500, -8500, -8500, -8500};
    public float[] angle = new float[3];
    public float[] frameIMUAngle = new float[3];
    public float[] rc_angle = new float[3];
    public int cycleTime;
    public int i2cErrorCount;
    public int errorCode;
    public int subError;
    public int comErrCnt;
    public int bat_val;
    public boolean isPowered;
    public boolean isDebugPort;
    public int curProfile;
    public int curIMU = 1;
    public int[] power = new int[3];
    public int current;
    public int[] magData = new int[3];
    public int[] balanceError = new int[3];
    public float[] frameCamAngle = new float[3];
    public int IMU_G_err;
    public int IMU_H_err;
    public int IMU_temp_cels;
    public int frame_IMU_temp_cels;
    public int[] motor_effective_out = new int[3];
    public int progress;
    public int calibMode;
    public int ext_sens_err;
    public long system_state_flags;

    public static RealtimeData getRealtimeData() {
        return curRealtimeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(SerialCommand cmd) throws IOException {
        RealtimeData tmp;
        RealtimeData realtimeData = tmp = tmp1 == curRealtimeData ? tmp2 : tmp1;
        synchronized (realtimeData) {
            int i;
            int i2;
            tmp.regDate = new Date(cmd.timestamp);
            int id = cmd.id == 68 ? 0 : cmd.id;
            for (i2 = 0; i2 < 3; ++i2) {
                tmp.acc[i2] = cmd.readWord();
                tmp.gyro[i2] = cmd.readWord();
            }
            tmp.comErrCnt = cmd.readWordUnsigned();
            tmp.errorCode = cmd.readWordUnsigned();
            tmp.subError = cmd.readByte();
            cmd.skipBytes(3);
            cmd.readWordArr(tmp.rcData);
            for (i2 = 0; i2 < 3; ++i2) {
                tmp.angle[i2] = (float)cmd.readWord() * 0.021972656f;
            }
            if (id >= 23) {
                for (i2 = 0; i2 < 3; ++i2) {
                    tmp.frameIMUAngle[i2] = (float)cmd.readWord() * 0.021972656f;
                }
            }
            for (i2 = 0; i2 < 3; ++i2) {
                tmp.rc_angle[i2] = (float)cmd.readWord() * 0.021972656f;
            }
            tmp.cycleTime = cmd.readWord();
            tmp.i2cErrorCount = cmd.readWordUnsigned();
            cmd.skipBytes(1);
            tmp.bat_val = cmd.readWord();
            int flags = cmd.readByte();
            tmp.isPowered = (flags & 1) != 0;
            boolean bl = tmp.isDebugPort = (flags & 2) != 0;
            if (id >= 23) {
                tmp.curIMU = cmd.readByte();
            }
            tmp.curProfile = cmd.readByte();
            for (i = 0; i < 3; ++i) {
                tmp.power[i] = cmd.readByte();
            }
            if (id >= 25) {
                for (i = 0; i < 3; ++i) {
                    tmp.frameCamAngle[i] = (float)cmd.readWord() * 0.021972656f;
                }
                tmp.progress = cmd.readByte();
                cmd.readWordArr(tmp.balanceError);
                tmp.current = cmd.readWordUnsigned();
                cmd.readWordArr(tmp.magData);
                tmp.IMU_temp_cels = cmd.readByte();
                tmp.frame_IMU_temp_cels = cmd.readByte();
                tmp.IMU_G_err = cmd.readByte();
                tmp.IMU_H_err = cmd.readByte();
                for (int axis = 0; axis < 3; ++axis) {
                    tmp.motor_effective_out[axis] = cmd.readWord();
                }
                tmp.calibMode = cmd.readByte();
                tmp.ext_sens_err = cmd.readByte();
                if (BoardInfo.checkMinBaseFirmwareVer(2720)) {
                    for (i = 0; i < 3; ++i) {
                        tmp.angle[i] = (float)cmd.readWord() * 0.021972656f;
                    }
                } else {
                    cmd.skipBytes(6);
                }
                tmp.system_state_flags = cmd.readDWordUnsigned();
                if (BoardInfo.isDebugMode()) {
                    cmd.skipBytes(10);
                    cmd.readWordArr(tmp.debug);
                } else {
                    cmd.skipBytes(18);
                }
            }
        }
        cmd.checkFinished();
        ErrorInfo.setBoardError(tmp.errorCode, tmp.subError);
        ErrorInfo.setExtSensError(tmp.ext_sens_err);
        curRealtimeData = tmp;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateRealtimeData();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseCmdAdjVarsState(SerialCommand cmd) throws IOException {
        if (cmd.getBytesAvailable() >= 15) {
            final int triggerSignal = cmd.readWord();
            final int triggerAction = cmd.readByte();
            final int analogSignal = cmd.readWord();
            final float analogVal = cmd.readFloat();
            final int LUTsignalVal = cmd.readWord();
            final float LUTvarVal = cmd.readFloat();
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SimpleBGC_GUIApp.mainView.panelAdjVars.updateRealtimeState(triggerSignal, triggerAction, analogSignal, analogVal, LUTsignalVal, LUTvarVal);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void parseCmdMavlinkDebug(SerialCommand cmd) throws IOException {
        int ch = cmd.readByte();
        int flags = cmd.readByte();
        cmd.skipBytes(4);
        boolean isV2 = (flags & 2) != 0;
        cmd.skipBytes(1);
        if (isV2) {
            cmd.skipBytes(2);
        }
        int seq_cnt = cmd.readByte();
        int sys_id = cmd.readByte();
        int comp_id = cmd.readByte();
        int msg_id = cmd.readByte();
        if (isV2) {
            msg_id |= (cmd.readByte() | cmd.readByte() << 8) << 8;
        }
        byte[] body = cmd.readBytes(cmd.getBytesAvailable());
        final String debug_msg = ch + 1 + ".MAV.v" + (isV2 ? 2 : 1) + ((flags & 1) > 0 ? ".out" : ".in") + "." + seq_cnt + " #" + msg_id + " (" + sys_id + "," + comp_id + ") [" + SerialCommand.dumpBytes(body, body.length) + "]";
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.debugMessage(debug_msg);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void parseCmdMavlinkInfo(SerialCommand cmd) throws IOException {
        int data_state = cmd.readByte();
        int ahrs_period = cmd.readByte();
        int pos_period = cmd.readByte();
        cmd.skipBytes(4);
        final String common_info = "AHRS: " + ((data_state & 1) > 0 ? "OK" : ((data_state & 2) > 0 ? "low rate" : "no")) + " (" + (ahrs_period == 255 ? ">255" : Integer.valueOf(ahrs_period)) + " ms), GPS: " + ((data_state & 4) > 0 ? "OK" : ((data_state & 8) > 0 ? "low rate" : "no")) + " (" + (pos_period == 255 ? ">255" : Integer.valueOf(pos_period)) + " ms), RC: " + ((data_state & 0x10) > 0 ? "OK" : ((data_state & 0x20) > 0 ? "low rate" : "no")) + ", Control: " + ((data_state & 0x40) > 0 ? "OK" : ((data_state & 0x80) > 0 ? "low rate" : "no"));
        final String[] info = new String[2];
        for (int i = 0; i < 2; ++i) {
            long packets_received_cnt = cmd.readDWordUnsigned();
            int packets_dropped_cnt = cmd.readWordUnsigned();
            int parse_errors = cmd.readWordUnsigned();
            int rx_overflow = cmd.readWordUnsigned();
            int tx_overflow = cmd.readWordUnsigned();
            info[i] = String.format("Packets received: %d, lost: %d, parse errors: %d, buf.overflow: %d RX, %d TX", packets_received_cnt, packets_dropped_cnt, parse_errors, rx_overflow, tx_overflow);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.panelMavlink.MavlinkShowState(common_info, info);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Integer rcData16_to_API_range(int data, int neutral_point) {
        return data != Short.MIN_VALUE ? new Integer(neutral_point + data * 500 / 16384) : null;
    }
}

