/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import sbgc.object.BoardParams;
import sbgc.object.ListOption;
import sbgc.object.SerialLinkCfgSlot;
import sbgc.service.SerialCommand;
import sbgc.utils.FileUtil;

public class SerialLinkCfg
implements Cloneable {
    static final Logger logger = Logger.getLogger((String)SerialLinkCfg.class.getName());
    public static final int FUNCTION_SBGC32_SERIAL_API = 1;
    public static final int FUNCTION_GPS_IMU_SERIAL_API = 2;
    public static final int FUNCTION_TRANSPARENT_UART = 3;
    public static final int FUNCTION_GNSS_START = 4;
    public static final int FUNCTION_GNSS_END = 7;
    public static final int FUNCTION_TRANSPARENT_TO_API = 8;
    public static final int FUNCTION_VIRT_PORT_START = 9;
    public static final int FUNCTION_VIRT_PORT_END = 11;
    public static final String[] FUNCTION_NAMES = new String[]{"?", "SBGC32 Serial API", "GPS_IMU Serial API", "Transparent serial", "GPS_IMU GNSS receiver (primary)", "GPS_IMU GNSS receiver (secondary)", "GPS_IMU GNSS receiver (RTK rover)", "GPS_IMU GNSS receiver (RTK moving base)", "Transparent serial via Serial API"};
    public static final int DEVICE_SBGC32 = 1;
    public static final int DEVICE_GPS_IMU = 2;
    public static final int DEVICE_CAN_IMU_MAIN = 3;
    public static final int DEVICE_CAN_IMU_FRAME = 4;
    public static final int DEVICE_GNSS_RECEIVER = 5;
    public static final int DEVICE_SERIAL_HUB1 = 6;
    public static final int DEVICE_SERIAL_HUB2 = 7;
    public static final int DEVICE_CAN_DRV1 = 8;
    public static final int DEVICE_CAN_DRV4 = 11;
    public static final ListOption[] DEVICE_NAMES = new ListOption[]{new ListOption("?"), new ListOption("SBGC32"), new ListOption("GPS_IMU"), new ListOption("CAN_IMU(main)"), new ListOption("CAN_IMU(frame)"), new ListOption("GPS_Split_Rcvr", 2730), new ListOption("CAN_Serial_hub1", 2730), new ListOption("CAN_Serial_hub2", 2730), new ListOption("CAN_Drv#1", 2720), new ListOption("CAN_Drv#2", 2720), new ListOption("CAN_Drv#3", 2720), new ListOption("CAN_Drv#4", 2720)};
    public static final String[][] PORT_NAMES = new String[][]{null, {"UART1", "RC_SERIAL", "UART2", "USB_VCP / UART3"}, {"UART1", "UART2"}, {"UART1", "UART2"}, {"UART1", "UART2"}, {"UART1", "UART2", "UART3", "EMBED_GNSS"}, {"Serial1", "Serial2 (TTL)", "Serial2 (RS422)", "Serial3"}, {"Serial1", "Serial2 (TTL)", "Serial2 (RS422)", "Serial3"}, {"UART2"}, {"UART2"}, {"UART2"}, {"UART2"}};
    public static final int SLOT_NUM = 10;
    public static final int SLOT_SIZE = 6;
    public static final int STORAGE_FORMAT_VERSION_MIN = 1;
    public static final int STORAGE_FORMAT_VERSION_CUR = 1;
    public int version = 1;
    public int reserved;
    public SerialLinkCfgSlot[] slots;

    public SerialLinkCfg() {
        this.makeEmptySlots();
    }

    public void makeEmptySlots() {
        this.slots = new SerialLinkCfgSlot[10];
        for (int i = 0; i < this.slots.length; ++i) {
            SerialLinkCfgSlot slot;
            this.slots[i] = slot = new SerialLinkCfgSlot();
        }
    }

    public void parse(byte[] data) throws Exception {
        if (data.length != 64) {
            throw new Exception("Incorrect data size (" + data.length + ")");
        }
        SerialCommand tmp = new SerialCommand(0, data);
        int ver = tmp.readByte();
        if (ver >= 1) {
            int crc16_file;
            this.version = ver;
            this.reserved = tmp.readByte();
            boolean notEmpty = false;
            this.slots = new SerialLinkCfgSlot[10];
            for (int i = 0; i < this.slots.length; ++i) {
                SerialLinkCfgSlot slot = new SerialLinkCfgSlot();
                int t = tmp.readWordUnsigned();
                slot.function = t & 0xF;
                slot.port = t >> 4 & 0x3F;
                slot.target_port = t >> 10 & 0x3F;
                t = tmp.readByte();
                slot.baud_idx = t & 0xF;
                slot.parity = t >> 4 & 3;
                slot.timeout_ms = tmp.readByte();
                slot.reserved = tmp.readWordUnsigned();
                this.slots[i] = slot;
                if (!slot.isEnabled()) continue;
                notEmpty = true;
            }
            int crc16 = FileUtil.crc16_sbgc32(tmp.data, 0, tmp.pos);
            if (crc16 != (crc16_file = tmp.readWordUnsigned())) {
                if (notEmpty) {
                    throw new Exception("Bad CRC (calculated " + crc16 + " != stored " + crc16_file + ")");
                }
                logger.debug((Object)"SerialLinkCfg.parse() CRC failed, skip for empty configuration");
                this.makeEmptySlots();
            } else if ((this.version & 0xF0) > 0) {
                throw new Exception("Incompatible storage format version! Please use GUI version compatible with this firmware");
            }
        } else {
            logger.debug((Object)"SerialLink configuration is empty");
        }
    }

    public static SerialLinkCfg parseFromByteArray(byte[] data) throws Exception {
        SerialLinkCfg cfg = new SerialLinkCfg();
        cfg.parse(data);
        return cfg;
    }

    public byte[] pack() throws Exception {
        if (this.slots == null) {
            throw new Exception("Configuration is empty!");
        }
        if (this.slots.length != 10) {
            throw new Exception("Wrong number of slots (" + this.slots.length + ")");
        }
        SerialCommand tmp = new SerialCommand(0);
        tmp.writeByte(1);
        tmp.writeByte(this.reserved);
        for (SerialLinkCfgSlot slot : this.slots) {
            tmp.writeWord(slot.function & 0xF | (slot.port & 0x3F) << 4 | (slot.target_port & 0x3F) << 10);
            tmp.writeByte(slot.baud_idx & 0xF | (slot.parity & 3) << 4);
            tmp.writeByte(slot.timeout_ms);
            tmp.writeWord(slot.reserved);
        }
        tmp.writeWord(FileUtil.crc16_sbgc32(tmp.data, 0, tmp.len));
        return Arrays.copyOfRange(tmp.data, 0, tmp.len);
    }

    public ArrayList<String> checkErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.slots != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                SerialLinkCfgSlot s = this.slots[i];
                String slotName = "Slot " + (i + 1) + ": ";
                if (s.port == 0) continue;
                int device = SerialLinkCfg.getDevice(s.port);
                if (s.function != 0) {
                    String err;
                    if ((s.function == 1 || s.function == 8) && device == 1 || s.function == 2 && device == 2) {
                        errors.add(slotName + "Serial API is a local function for this device");
                    }
                    if (s.function == 3 || s.function == 8) {
                        if (s.target_port != 0) {
                            int targetDevice = SerialLinkCfg.getDevice(s.target_port);
                            if (targetDevice > 0 && targetDevice != device) {
                                if (s.function == 8) {
                                    if (targetDevice == 1) {
                                        String err2 = SerialLinkCfg.check_port_is_serial_API(s.target_port);
                                        if (err2 != null) {
                                            errors.add(slotName + err2);
                                        }
                                    } else if (this.findConfiguredDevice(s.target_port, -1, 1) < 0) {
                                        errors.add(slotName + "device at 'target port' (" + SerialLinkCfg.getDevicePortName(s.target_port) + ") should be configured to 'SBGC32 Serial API' function");
                                    }
                                } else if (this.findConfiguredDevice(s.target_port, s.port, 3) < 0) {
                                    errors.add(slotName + "the other end of the transparent UART is not configured");
                                }
                            } else {
                                errors.add(slotName + "target port should be on a different device");
                            }
                        } else {
                            errors.add(slotName + "target port for transparent UART is not specified");
                        }
                    }
                    for (int j = 0; j < i; ++j) {
                        if (this.slots[j].port != s.port) continue;
                        errors.add(slotName + " port " + SerialLinkCfg.getDevicePortName(s.port) + " is already used in slot#" + (j + 1));
                    }
                    if (device != 1 || (err = SerialLinkCfg.check_port_is_serial_API(s.port)) == null) continue;
                    errors.add(slotName + err);
                    continue;
                }
                errors.add(slotName + "function is not specified");
            }
        }
        return errors;
    }

    public static String get_SBGC32_port_function(int port) {
        BoardParams params = BoardParams.getCurParams();
        if (params != null) {
            return params.getPortFunction(SerialLinkCfg.portNumToSbgc32Port(SerialLinkCfg.getPortNum(port)));
        }
        return null;
    }

    public static String check_port_is_serial_API(int port) {
        String func = SerialLinkCfg.get_SBGC32_port_function(port);
        if (func != "Serial API") {
            return " port " + SerialLinkCfg.getDevicePortName(port) + (func == null ? "function can't be detected" : (func == "disabled" ? " is not enabled for Serial API" : " is occupied by other function '" + func + "'"));
        }
        return null;
    }

    public int findConfiguredDevice(int port, int target_port, int function) {
        for (int j = 0; j < this.slots.length; ++j) {
            if (this.slots[j].function != function || port >= 0 && this.slots[j].port != port || target_port >= 0 && this.slots[j].target_port != target_port) continue;
            return j;
        }
        return -1;
    }

    public static int sbgc32PortToPortNum(int sbgc32Port) {
        return sbgc32Port - 1;
    }

    public static int portNumToSbgc32Port(int portNum) {
        return portNum + 1;
    }

    public ArrayList<String> getRouteInfo(int forDevice, int forPortNum) {
        ArrayList<String> info = new ArrayList<String>();
        if (this.slots != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                SerialLinkCfgSlot s = this.slots[i];
                int device = SerialLinkCfg.getDevice(s.port);
                int portNum = SerialLinkCfg.getPortNum(s.port);
                StringBuilder b = new StringBuilder();
                if (s.port == 0 || s.function == 0 || forDevice >= 1 && forDevice != device || forPortNum >= 0 && forPortNum != portNum) continue;
                b.append((forDevice > 0 ? SerialLinkCfg.getPortName(device, portNum) : SerialLinkCfg.getDevicePortName(s.port)) + " - " + SerialLinkCfg.getFunctionName(s.function));
                if (s.function == 3 || s.function == 8) {
                    int idx;
                    b.append(" - " + SerialLinkCfg.getDevicePortName(s.target_port));
                    if (forPortNum < 0 && (idx = this.findConfiguredDevice(s.target_port, s.port, 3)) >= 0 && idx < i) continue;
                }
                if (device == 1 && portNum == 0 || SerialLinkCfg.getDevice(s.target_port) == 1 && SerialLinkCfg.getPortNum(s.target_port) == 0 && s.function == 3) {
                    b.append(" (WARNING: UART1 is required for the GUI connection!)");
                }
                info.add(b.toString());
            }
        }
        return info;
    }

    public static final String getDevicePortName(int port) {
        StringBuilder b = new StringBuilder();
        if (port > 0) {
            int device = SerialLinkCfg.getDevice(port);
            if (device > 0 && device < DEVICE_NAMES.length) {
                b.append(SerialLinkCfg.DEVICE_NAMES[device].name);
            } else {
                b.append("unknown_device<" + device + ">");
            }
            b.append(".");
            b.append(SerialLinkCfg.getPortName(device, SerialLinkCfg.getPortNum(port)));
        } else {
            b.append("not specified");
        }
        return b.toString();
    }

    public static final String getPortName(int device, int portNum) {
        String[] portNames;
        String[] stringArray = portNames = device > 0 && device < PORT_NAMES.length ? PORT_NAMES[device] : null;
        if (portNum >= 0 && portNames != null && portNum < portNames.length) {
            return portNames[portNum];
        }
        return "unknown_port<" + portNum + ">";
    }

    public static int getDevice(int port) {
        return port >> 2 & 0xF;
    }

    public static int getPortNum(int port) {
        return port & 3;
    }

    public static String getFunctionName(int function) {
        return function > 0 && function < FUNCTION_NAMES.length ? FUNCTION_NAMES[function] : "unknown function<" + function + ">";
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SerialLinkCfg) {
            SerialLinkCfg p = (SerialLinkCfg)o;
            if (this.slots == null) {
                return p.slots == null;
            }
            if (p.slots != null && this.slots.length == p.slots.length) {
                for (int i = 0; i < this.slots.length; ++i) {
                    if (this.slots[i].equals(p.slots[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public SerialLinkCfg clone() {
        try {
            SerialLinkCfg copy = (SerialLinkCfg)super.clone();
            copy.slots = this.slots == null ? null : Arrays.copyOf(this.slots, this.slots.length);
            return copy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

