/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import sbgc.service.SerialCommand;

@XStreamAlias(value="step-signal-cfg")
public class StepSignalCfg
implements Cloneable {
    public int src_ch;
    public int num_steps;
    public int level;
    public int init_val;
    public boolean menu_button;
    public static final int NUM_STEPS_MASK = 7;
    public static final int MENU_BUTTON_FLAG = 8;
    public static final int INIT_VAL_EEPROM_FLAG = 16;
    public static final int INIT_VAL_ZERO_FLAG = 32;
    public static final int LEVEL_MASK = 192;
    public static final int[] NUM_STEPS = new int[]{2, 3, 5, 10, 15, 25, 50, 100};

    public void readConfig(SerialCommand cmd) throws IOException {
        this.src_ch = cmd.readByte();
        int cfg = cmd.readByte();
        this.num_steps = cfg & 7;
        this.level = (cfg & 0xC0) >> 6;
        this.init_val = cfg & 0x30;
        this.menu_button = (cfg & 8) != 0;
    }

    public void writeConfig(SerialCommand cmd) throws IOException {
        cmd.writeByte(this.src_ch);
        int cfg = this.num_steps & 7 | this.level << 6 & 0xC0 | this.init_val & 0x30 | (this.menu_button ? 8 : 0);
        cmd.writeByte(cfg);
    }

    public StepSignalCfg clone() throws CloneNotSupportedException {
        StepSignalCfg copy = (StepSignalCfg)super.clone();
        return copy;
    }

    public static StepSignalCfg[] copyOf(StepSignalCfg[] arr) throws CloneNotSupportedException {
        if (arr != null) {
            StepSignalCfg[] copy = new StepSignalCfg[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                copy[i] = arr[i].clone();
            }
            return copy;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StepSignalCfg)) {
            return false;
        }
        StepSignalCfg other = (StepSignalCfg)o;
        return this.src_ch == other.src_ch && this.num_steps == other.num_steps && this.level == other.level && this.init_val == other.init_val && this.menu_button == other.menu_button;
    }
}

