/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import sbgc.object.ErrorInfo;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.DataLogger;
import simplebgc_gui.SimpleBGC_GUIApp;

public class VibrationTest {
    static final Logger logger = Logger.getLogger((String)VibrationTest.class.getName());
    public static final long TEST_DURATION_CNT = 12500L;
    public static final int SAMPLES_NUM_IN_BATCH = 32;
    public static final float SCALE_FACTOR = 0.25f;
    public static final HashMap<Integer, String> ERROR_BITS = new HashMap();
    private static final DecimalFormat FLOAT_FORMATTER;
    DataLogger dataLogger = null;
    long data_cnt;
    int prev_cnt;
    int missed_cnt;
    long duration;
    public static final VibrationTest instance;
    private int next_progress = 0;
    IProgressListener progressListener = null;

    public boolean isActive() {
        return this.dataLogger != null;
    }

    public synchronized void start(int sensor, String filename, IProgressListener _progressListener) throws Exception {
        this.duration = 12500L;
        try {
            if (this.dataLogger != null) {
                this.dataLogger.finish();
            }
            this.dataLogger = new DataLogger(filename, false);
            this.dataLogger.setHeader(Arrays.asList("%sbgc_test_data", Integer.toString(32768), Integer.toString(sensor)));
        }
        catch (Exception e) {
            throw new Exception("Can't open log file for writing: " + e.toString());
        }
        this.progressListener = _progressListener;
        this.data_cnt = 0L;
        this.prev_cnt = -1;
        this.missed_cnt = 0;
        SerialCommand cmd = new SerialCommand(125);
        cmd.writeDWord(this.duration);
        cmd.writeByte(sensor);
        cmd.writeEmptyArr(20);
        if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L)) {
            if (this.dataLogger != null) {
                this.dataLogger.finish();
                this.dataLogger = null;
            }
            throw new Exception("No response on test start command");
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressStart("Vibration test started.", false);
        }
        this.next_progress = 5;
    }

    public synchronized void sendStopCmd() {
        try {
            SerialCommand cmd = new SerialCommand(125);
            if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L) && this.dataLogger != null) {
                this.dataLogger.finish();
                this.dataLogger = null;
                if (this.progressListener != null) {
                    this.progressListener.onProgressFinish(false);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error sending stop command: " + e.toString()));
        }
    }

    public void parse_data(SerialCommand cmd) {
        try {
            int cnt = cmd.readByte();
            int got_cnt = 0;
            while (cmd.getBytesAvailable() >= 6) {
                int[] data = cmd.readWordArr(3);
                float[] sample = new float[]{(float)data[0] * 0.25f, (float)data[1] * 0.25f, (float)data[2] * 0.25f};
                this.logData(sample);
                ++got_cnt;
            }
            int delta = cnt - this.prev_cnt & 0xFF;
            if (delta != got_cnt) {
                this.missed_cnt += delta;
                ErrorInfo.setErrorText("Missed data: " + this.missed_cnt);
            }
            this.data_cnt += (long)delta;
            this.prev_cnt = cnt;
            int progress = (int)(this.data_cnt * 100L / this.duration);
            if (progress >= this.next_progress && this.progressListener != null) {
                this.progressListener.onProgressChange(progress);
                this.next_progress = progress + 1;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error parsing CMD_BODE_TEST_DATA: " + e.toString()));
        }
    }

    void logData(float[] sample) {
        if (this.dataLogger != null) {
            this.dataLogger.logData(String.join((CharSequence)";", FLOAT_FORMATTER.format(sample[0]), FLOAT_FORMATTER.format(sample[1]), FLOAT_FORMATTER.format(sample[2])));
        }
    }

    public void on_stop_cmd(SerialCommand cmd) {
        try {
            long cnt = cmd.readDWordUnsigned();
            int error = cmd.readWordUnsigned();
            cmd.startReading();
            if (this.dataLogger != null) {
                this.dataLogger.finish();
                ErrorInfo.updateStatus("Test result successfuly stored to " + this.dataLogger.getLogFileName());
                this.dataLogger = null;
                if (error != 0 && !SimpleBGC_GUIApp.mainView.showConfirmDialog("Errors during test: " + VibrationTest.getErrorDescr(error) + "\nDo you want to continue?")) {
                    if (this.progressListener != null) {
                        this.progressListener.onProgressFinish(false);
                    }
                } else {
                    if (cnt == this.data_cnt) {
                        ErrorInfo.setErrorText(null);
                    } else {
                        SimpleBGC_GUIApp.mainView.showErrorMessage("Missed data during test: " + (cnt - this.data_cnt));
                        logger.debug((Object)("cnt: " + cnt + ", data_cnt: " + this.data_cnt));
                    }
                    if (this.progressListener != null) {
                        this.progressListener.onProgressFinish(true);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public File getFile() {
        return this.dataLogger != null ? this.dataLogger.getLogFile() : null;
    }

    public static String getErrorDescr(int error) {
        StringBuilder res = new StringBuilder();
        for (Integer bit : ERROR_BITS.keySet()) {
            if ((error & bit) != 0) {
                res.append(ERROR_BITS.get(bit)).append("; ");
            }
            error &= ~bit.intValue();
        }
        if (error != 0) {
            res.append("unknown code '" + error + "'");
        }
        return res.toString();
    }

    static {
        ERROR_BITS.put(1, "SENSOR_DATA_READ");
        ERROR_BITS.put(2, "TX_BUF_OVERFLOW");
        ERROR_BITS.put(4, "UNKNOWN_SENSOR");
        ERROR_BITS.put(8, "SENSOR_CONFIGURE");
        ERROR_BITS.put(16, "DATA_CLIPPED");
        FLOAT_FORMATTER = new DecimalFormat("0.#####E0", new DecimalFormatSymbols(Locale.ENGLISH));
        instance = new VibrationTest();
    }
}

