/*
 * Decompiled with CFR 0.152.
 */
package sbgc.optimizer;

import java.util.Arrays;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.Optimizer;
import sbgc.service.upgrade.IProgressListener;

public class RndOptimizerImpl
extends Optimizer {
    public static final int PARAM_RND_SAMPLES = 5;
    static final int CNT_NO_IMPROVEMENT_TO_RESTART_FROM_ZERO = 50;
    static final int CNT_NO_IMPROVEMENT_TO_RESTART_FROM_CURRENT = 30;
    static final float RND_STEP_SIZE_INIT_ZERO = 0.5f;
    static final float RND_STEP_SIZE_INIT_CURRENT = 0.3f;
    static final float RND_STEP_SIZE_DECAY_ON_RESTART_ZERO = 0.8f;
    static final float RND_STEP_SIZE_DECAY_ON_RESTART_CURRENT = 0.9f;
    float progress;

    public RndOptimizerImpl(IOptimizable system, IProgressListener progressListener, boolean isStartFromCurrent, int iterNumMax) throws Exception {
        super(system, progressListener, isStartFromCurrent, iterNumMax);
    }

    @Override
    protected float _optimize(IOptimizedParams p) throws Exception {
        float rnd_step_size_decay;
        float rnd_step_size;
        int no_best_cnt_to_restart;
        this.progress = 1.0f;
        float[] n_params = new float[p.getOptimizedParamsNum()];
        p.getNormalizedParams(n_params);
        float[] n_params_best = Arrays.copyOf(n_params, n_params.length);
        int no_best_cnt = 0;
        float cost_best = 1000000.0f;
        if (this.isStartFromCurrent) {
            no_best_cnt_to_restart = 30;
            rnd_step_size = 0.3f;
            rnd_step_size_decay = 0.9f;
        } else {
            no_best_cnt_to_restart = 50;
            rnd_step_size = 0.5f;
            rnd_step_size_decay = 0.8f;
        }
        int iterCnt = 0;
        int iterRestartCnt = 0;
        while (iterCnt < this.iterNumMax && this.isActive) {
            boolean is_improved = false;
            for (int n_idx = 0; n_idx < p.getOptimizedParamsNum(); ++n_idx) {
                if (!p.isParamEffective(n_idx)) continue;
                float cost_local_best = 1000000.0f;
                float val_local_best = n_params[n_idx];
                float val_orig = n_params[n_idx];
                for (int n = 0; n < 5; ++n) {
                    float val_bac = n_params[n_idx];
                    n_params[n_idx] = RndOptimizerImpl.make_rnd_step(n_params[n_idx], rnd_step_size);
                    p.setNormalizedParams(n_params, n_idx);
                    float cost_new = this.system.cost_function(p, this.getProgress());
                    if (cost_new < cost_local_best) {
                        val_local_best = n_params[n_idx];
                        cost_local_best = cost_new;
                        continue;
                    }
                    if (cost_new != 1000000.0f) continue;
                    if (cost_local_best == 1000000.0f) continue;
                    n_params[n_idx] = val_bac;
                }
                if (cost_local_best != 1000000.0f) {
                    n_params[n_idx] = val_local_best;
                } else if (cost_best != 1000000.0f) {
                    n_params[n_idx] = val_orig;
                }
                p.setNormalizedParams(n_params, -1);
                if (cost_local_best < cost_best) {
                    is_improved = true;
                    cost_best = cost_local_best;
                    n_params_best = Arrays.copyOf(n_params, n_params.length);
                }
                if (iterCnt % 10 != 0) continue;
                logger.debug(String.format("iter %d(%d), idx %d: no_best=%d cost=%.4f rnd=%.4f \n\t(%s)", iterCnt, iterRestartCnt, n_idx, no_best_cnt, Float.valueOf(cost_local_best), Float.valueOf(rnd_step_size), p.toString()));
            }
            if (!is_improved && ++no_best_cnt > no_best_cnt_to_restart) {
                no_best_cnt = 0;
                iterRestartCnt = 0;
                n_params = Arrays.copyOf(n_params_best, n_params_best.length);
                p.setNormalizedParams(n_params, -1);
                logger.debug(String.format("Restarting from best values (%s)", p.toString()));
                rnd_step_size *= rnd_step_size_decay;
            }
            this.progress = 1.0f - (float)iterCnt / (float)this.iterNumMax;
            this.updateProgress(iterCnt * 100 / this.iterNumMax);
            this.system.iteration_step(p, this.progress);
            ++iterCnt;
            ++iterRestartCnt;
        }
        p.setNormalizedParams(n_params_best, -1);
        return cost_best;
    }

    @Override
    protected float getProgress() {
        return this.progress;
    }
}

