/*
 * Decompiled with CFR 0.152.
 */
package sbgc.optimizer;

import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.Optimizer;
import sbgc.optimizer.Vertex;

class Simplex {
    public final int dimension;
    public final Vertex[] verticies;
    public float maxSize;

    public Simplex(Vertex origin, float stepLength) {
        this.dimension = origin.point.length;
        this.verticies = new Vertex[this.dimension + 1];
        this.verticies[0] = new Vertex(origin);
        for (int i = 1; i < this.verticies.length; ++i) {
            Vertex v = new Vertex(origin);
            Optimizer.makeRandomStep(v.point, stepLength);
            this.verticies[i] = v;
        }
    }

    public float[] getCentroid() {
        float[] centroid = new float[this.dimension];
        float scale = 1.0f / (float)this.dimension;
        int i = 0;
        while (i < this.dimension) {
            for (int j = 0; j < this.dimension; ++j) {
                int n = i;
                centroid[n] = centroid[n] + this.verticies[j].point[i];
            }
            int n = i++;
            centroid[n] = centroid[n] * scale;
        }
        return centroid;
    }

    public void replaceWorstPoint(Vertex v) {
        for (int i = 0; i < this.dimension; ++i) {
            if (this.verticies[i].compareTo(v) <= 0) continue;
            Vertex tmp = this.verticies[i];
            this.verticies[i] = v;
            v = tmp;
        }
        this.verticies[this.verticies.length - 1] = v;
    }

    public float getMaxLength(IOptimizedParams cp) {
        float max = 0.0f;
        for (int i = 0; i < this.verticies.length; ++i) {
            for (int j = i + 1; j < this.verticies.length; ++j) {
                float d = this.verticies[i].distanceTo(this.verticies[j], cp);
                if (!(d > max)) continue;
                max = d;
            }
        }
        return max;
    }
}

