/*
 * Decompiled with CFR 0.152.
 */
package sbgc.optimizer;

import java.util.Arrays;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.Optimizer;
import sbgc.optimizer.Simplex;
import sbgc.optimizer.Vertex;
import sbgc.service.upgrade.IProgressListener;

public class SimplexOptimizerImpl
extends Optimizer {
    public static final float INITIAL_SIMPLEX_LENGTH = 0.1f;
    public static final float INITIAL_SIMPLEX_LENGTH_FROM_CURRENT = 0.02f;
    public static final int RND_ITERATIONS_MAX = 100;
    public static final float RND_SIMPLEX_MIN_SIZE = 0.001f;
    public static final float RND_STEP_SIZE = 0.2f;
    public static final float RND_INITIAL_SIMPLEX_LENGTH = 0.05f;
    public static final float STOP_CONDITION_SIMPLEX_MAX_LENGTH = 1.0E-5f;
    public static final int STOP_CONDITION_CHECK_PERIOD = 10;
    public static final int STOP_CONDITION_MIN_ITERATIONS = 10;
    public static final int ITER_NUM_MAX_DEFAULT = 2000;
    private static final float K_REFLECTION = 1.0f;
    private static final float K_EXSPANSION = 2.0f;
    private static final float K_CONTRACTION = 0.5f;
    private static final float K_SHRINK = 0.5f;
    float simplexLength;
    int RND_SEED_NUM;

    public SimplexOptimizerImpl(IOptimizable system, IProgressListener progressListener, boolean isStartFromCurrent, int iterNumMax, int rnd_seed_num) throws Exception {
        super(system, progressListener, isStartFromCurrent, iterNumMax);
        this.RND_SEED_NUM = isStartFromCurrent ? 0 : rnd_seed_num;
    }

    @Override
    public float getProgress() {
        return this.simplexLength;
    }

    @Override
    protected float _optimize(IOptimizedParams cp) throws Exception {
        float[] n_params = new float[cp.getOptimizedParamsNum()];
        cp.getNormalizedParams(n_params);
        Simplex simplex = new Simplex(new Vertex(n_params), this.isStartFromCurrent ? 0.02f : 0.1f);
        int n = simplex.verticies.length - 1;
        this.updateCost(cp, simplex);
        Stat stat = new Stat();
        int rndIterCnt = 0;
        Vertex rnd_best = null;
        for (int iterCnt = 0; iterCnt < this.iterNumMax && this.isActive; ++iterCnt) {
            Vertex best = simplex.verticies[0];
            Vertex preWorst = simplex.verticies[n - 1];
            Vertex worst = simplex.verticies[n];
            float[] centroid = simplex.getCentroid();
            Vertex reflected = new Vertex(centroid);
            reflected.shiftTo(worst.point, -1.0f);
            this.updateCost(cp, reflected);
            if (best.compareTo(reflected) <= 0 && reflected.compareTo(preWorst) < 0) {
                simplex.replaceWorstPoint(reflected);
                ++stat.reflectionCnt;
            } else if (reflected.compareTo(best) < 0) {
                Vertex expanded = new Vertex(centroid);
                expanded.shiftTo(reflected.point, 2.0f);
                this.updateCost(cp, expanded);
                if (expanded.compareTo(reflected) < 0) {
                    simplex.replaceWorstPoint(expanded);
                    ++stat.expansionCnt;
                } else {
                    simplex.replaceWorstPoint(reflected);
                    ++stat.reflectionCnt;
                }
            } else {
                boolean isUpdated = false;
                Vertex contracted = new Vertex(centroid);
                if (reflected.compareTo(worst) < 0) {
                    contracted.shiftTo(reflected.point, 0.5f);
                    this.updateCost(cp, contracted);
                    if (contracted.compareTo(reflected) <= 0) {
                        simplex.replaceWorstPoint(contracted);
                        isUpdated = true;
                    }
                } else {
                    contracted.shiftTo(worst.point, 0.5f);
                    this.updateCost(cp, contracted);
                    if (contracted.compareTo(worst) < 0) {
                        simplex.replaceWorstPoint(contracted);
                        isUpdated = true;
                    }
                }
                if (isUpdated) {
                    ++stat.contractionCnt;
                } else {
                    for (int i = 1; i < simplex.verticies.length; ++i) {
                        simplex.verticies[i].shiftTo(simplex.verticies[0].point, 0.5f);
                        simplex.verticies[i].value = Float.NaN;
                    }
                    this.updateCost(cp, simplex);
                    ++stat.shrinkCnt;
                }
            }
            this.simplexLength = simplex.getMaxLength(cp);
            if (rndIterCnt < this.RND_SEED_NUM && (this.simplexLength < 0.001f || iterCnt > 100)) {
                if (rnd_best == null || best.value < rnd_best.value) {
                    rnd_best = best;
                    logger.debug(String.format("Best result improved: %.4f", Float.valueOf(best.value)));
                }
                float rndStep = 0.2f * (float)(this.RND_SEED_NUM - ++rndIterCnt) / (float)this.RND_SEED_NUM;
                logger.debug(String.format("rnd.iter=%d finished at %d with s=%g, cost=%.4f", rndIterCnt, iterCnt, Float.valueOf(this.simplexLength), Float.valueOf(best.value)));
                if (rndIterCnt == this.RND_SEED_NUM) {
                    simplex = new Simplex(rnd_best, 0.010000001f);
                } else {
                    Vertex v = new Vertex(best.point);
                    SimplexOptimizerImpl.makeRandomStep(v.point, rndStep);
                    simplex = new Simplex(v, 0.05f);
                    stat.reset();
                }
                this.updateCost(cp, simplex);
                iterCnt = 0;
                continue;
            }
            if (best.value == 1000000.0f && worst.value == 1000000.0f) {
                for (Vertex v : simplex.verticies) {
                    this.makeStabilizeStep(cp, v.point);
                    v.value = Float.NaN;
                }
                this.updateCost(cp, simplex);
                stat.reset();
                logger.debug(String.format("iter %d: wrong solution (%s)", iterCnt, cp.toString()));
                continue;
            }
            if (iterCnt % 10 == 0) {
                logger.debug(String.format("iter %d: cost=%.4f simplex=%.8f r/e/c/s=%d/%d/%d/%d\n\t(%s)", iterCnt, Float.valueOf(best.value), Float.valueOf(this.simplexLength), stat.reflectionCnt, stat.expansionCnt, stat.contractionCnt, stat.shrinkCnt, cp.toString()));
            }
            if (iterCnt % 10 != 0) continue;
            this.updateProgress((rndIterCnt * 100 + iterCnt) * 100 / (this.RND_SEED_NUM * 100 + this.iterNumMax));
            if (!(this.simplexLength < 1.0E-5f)) continue;
            logger.debug(String.format("Stop condition triggered: simplex length %g < %g", Float.valueOf(this.simplexLength), Float.valueOf(1.0E-5f)));
            break;
        }
        Vertex best = simplex.verticies[0];
        cp.setNormalizedParams(best.point, -1);
        return best.value;
    }

    void updateCost(IOptimizedParams p, Vertex v) throws Exception {
        v.value = this.computeCost(p, v.point);
    }

    void updateCost(IOptimizedParams p, Simplex s) throws Exception {
        for (Vertex v : s.verticies) {
            if (!Float.isNaN(v.value)) continue;
            v.value = this.computeCost(p, v.point);
        }
        Arrays.sort(s.verticies);
    }

    class Stat {
        int reflectionCnt;
        int expansionCnt;
        int contractionCnt;
        int shrinkCnt;

        Stat() {
        }

        public void reset() {
            this.reflectionCnt = 0;
            this.expansionCnt = 0;
            this.contractionCnt = 0;
            this.shrinkCnt = 0;
        }
    }
}

