/*
 * Decompiled with CFR 0.152.
 */
package sbgc.optimizer;

import java.util.Arrays;
import sbgc.optimizer.IOptimizedParams;
import sbgc.utils.MathUtils;

class Vertex
implements Comparable<Vertex> {
    public float[] point;
    public float value;

    public Vertex(float[] point, float value) {
        this.point = Arrays.copyOf(point, point.length);
        this.value = value;
    }

    public Vertex(float[] point) {
        this(point, Float.NaN);
    }

    public Vertex(Vertex v) {
        this.point = Arrays.copyOf(v.point, v.point.length);
        this.value = v.value;
    }

    @Override
    public int compareTo(Vertex v) {
        return Float.compare(this.value, v.value);
    }

    public float distanceTo(Vertex v, IOptimizedParams cp) {
        double sum = 0.0;
        for (int i = 0; i < this.point.length; ++i) {
            if (cp == null || !cp.isParamEffective(i)) continue;
            double diff = this.point[i] - v.point[i];
            sum += diff * diff;
        }
        return (float)Math.sqrt(sum);
    }

    public void shiftTo(float[] to, float ratio) {
        for (int j = 0; j < this.point.length; ++j) {
            int n = j;
            this.point[n] = this.point[n] + ratio * (to[j] - this.point[j]);
            this.point[j] = MathUtils.constrain(this.point[j], 0.0f, 1.0f);
        }
    }
}

