/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.manager;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import sbgc.script_parser.manager.BinaryReadException;
import sbgc.script_parser.script.CommandId;
import sbgc.script_parser.script.ScriptCmd;
import sbgc.script_parser.script.ScriptCmdParam;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.service.DataInputStreamLE;
import simplebgc_gui.SimpleBGC_GUIApp;

public class BinaryReader {
    public static ScriptProgram readScriptProgram(byte[] scriptProgramBytes) throws BinaryReadException {
        ByteArrayInputStream bas = new ByteArrayInputStream(scriptProgramBytes);
        DataInputStreamLE ds = new DataInputStreamLE(bas);
        ScriptProgram scriptProgram = null;
        System.out.println(SimpleBGC_GUIApp.getResourceMap().getString("info.BinaryReader.startParsing", new Object[0]));
        try {
            int cmdNum = ds.readShortUnsigned();
            BinaryReader.checkConstants(cmdNum, 10000, 0, SimpleBGC_GUIApp.getResourceMap().getString("error.BinaryReader.invalidCmd", new Object[0]));
            ScriptCmd[] scriptCmds = new ScriptCmd[10000];
            for (int i = 0; i < cmdNum; ++i) {
                scriptCmds[i] = BinaryReader.readScriptCmd(ds);
                System.out.println(scriptCmds[i].toStringDump());
            }
            scriptProgram = new ScriptProgram(cmdNum, scriptCmds);
        }
        catch (EOFException eofException) {
            throw new BinaryReadException(SimpleBGC_GUIApp.getResourceMap().getString("error.BinaryReader.eOFException", new Object[0]));
        }
        catch (IOException e) {
            throw new BinaryReadException(SimpleBGC_GUIApp.getResourceMap().getString("error.BinaryReader.iOException", new Object[0]));
        }
        System.out.println(SimpleBGC_GUIApp.getResourceMap().getString("info.BinaryReader.okParsing", new Object[0]));
        return scriptProgram;
    }

    private static ScriptCmd readScriptCmd(DataInputStreamLE ds) throws IOException, BinaryReadException {
        int cmdId = ds.readByte();
        int paramNum = ds.readByte();
        BinaryReader.checkConstants(paramNum, 10, 0, SimpleBGC_GUIApp.getResourceMap().getString("error.BinaryReader.invalidParamNum", new Object[0]));
        ScriptCmdParam[] scriptCmdParams = new ScriptCmdParam[10];
        CommandId commandId = CommandId.fromId(cmdId);
        for (int j = 0; j < paramNum; ++j) {
            scriptCmdParams[j] = ScriptCmdParam.read(ds, commandId);
        }
        return new ScriptCmd(cmdId, paramNum, scriptCmdParams);
    }

    public static void checkConstants(int value, int topLimit, int botLimit, String message) throws BinaryReadException {
        if (value < botLimit || value > topLimit) {
            throw new BinaryReadException(message);
        }
    }
}

