/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.script_parser.manager.CommandException;
import sbgc.script_parser.manager.ParserException;
import sbgc.script_parser.script.CommandId;
import sbgc.script_parser.script.ParamId;
import sbgc.script_parser.script.ScriptCmd;
import sbgc.script_parser.script.ScriptCmdParam;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.script_parser.utils.FileHelper;
import sbgc.script_parser.utils.Utils;
import sbgc.service.SerialCommand;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ScriptParser {
    static final Logger logger = Logger.getLogger((String)ScriptParser.class.getName());
    List<CommandException> errorList = new LinkedList<CommandException>();
    HashMap<String, Integer> labels = null;
    ArrayList<ScriptStr> cleanScriptStrings = null;
    private static Pattern pattern;

    public ScriptProgram parseScriptFromFile(String filePath) throws ParserException, IOException {
        return this.parseScriptFromString(new FileHelper().readFile(filePath));
    }

    public ScriptProgram parseScriptFromString(String programStr) throws ParserException {
        return this.parseScriptFromArray(programStr.split("\n"));
    }

    public ScriptProgram parseScriptFromArray(String[] scriptCode) throws ParserException {
        ScriptCmd[] commands = new ScriptCmd[10000];
        int numCommands = 0;
        int numAllSymbols = 0;
        this.labels = new HashMap();
        this.cleanScriptStrings = new ArrayList();
        String label = null;
        Pattern labelPattern = Pattern.compile("^\\s*(\\w+)\\s*\\:(.*)$");
        for (int i = 0; i < scriptCode.length; ++i) {
            String scriptStr;
            Matcher m;
            if (i > 0) {
                numAllSymbols += scriptCode[i - 1].length();
            }
            if ((m = labelPattern.matcher(scriptStr = this.removeUTF8BOM(scriptCode[i]).trim())).matches()) {
                label = m.group(1);
                scriptStr = m.group(2).trim();
            }
            if (scriptStr.startsWith("#") || scriptStr.equalsIgnoreCase("")) continue;
            this.cleanScriptStrings.add(new ScriptStr(scriptStr, numAllSymbols, i + 1));
            if (label == null) continue;
            this.labels.put(label, this.cleanScriptStrings.size());
            label = null;
        }
        for (ScriptStr s : this.cleanScriptStrings) {
            commands[numCommands] = this.getCmd(s.str, s.rawLine, s.startPos);
            if (++numCommands < commands.length) continue;
            this.errorList.add(new CommandException("Max. number of commands exceed: " + commands.length, s.rawLine, 0, ""));
            break;
        }
        if (!this.errorList.isEmpty()) {
            throw new ParserException(this.errorList);
        }
        ScriptProgram scriptProgram = new ScriptProgram(numCommands, commands);
        return scriptProgram;
    }

    private ScriptCmd getCmd(String cmdStr, int lineNum, int cmdPos) {
        int i;
        String[] scriptCmdArray = cmdStr.replaceAll("\r", "").split("\\s+(?![^\\(]*\\))");
        String commandName = scriptCmdArray[0];
        String[] cmdParamsArray = Arrays.copyOfRange(scriptCmdArray, 1, scriptCmdArray.length);
        CommandId cmdId = CommandId.fromString(commandName);
        if (cmdId == null) {
            this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.badCommandName", new Object[0]) + " " + commandName, lineNum, cmdPos, ""));
            return null;
        }
        ScriptCmdParam[] scriptCmdParams = this.getCmdParams(cmdParamsArray, lineNum, cmdPos, cmdId);
        if (scriptCmdParams == null) {
            return null;
        }
        int numParameters = cmdParamsArray.length;
        for (i = 0; i < numParameters; ++i) {
            ParamId id;
            if (scriptCmdParams[i].isNumeric() && !cmdId.getParams().contains((Object)ParamId.NUMERIC)) {
                this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.numParameterIsNotAllow", new Object[0]) + " " + commandName, lineNum, cmdPos, ""));
                return null;
            }
            if (!scriptCmdParams[i].isNamed() || (id = scriptCmdParams[i].getNamedId()) != null && cmdId.getParams().contains((Object)id)) continue;
            this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.parameter", new Object[0]) + " " + scriptCmdParams[i].toString() + " " + SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.isNotAloow", new Object[0]) + " " + commandName, lineNum, cmdPos, ""));
            return null;
        }
        if (numParameters == 0 && cmdId != CommandId.RESET) {
            this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.emptyParameter", new Object[0]) + " " + commandName, lineNum, cmdPos, ""));
            return null;
        }
        if (cmdId == CommandId.TRIGGER) {
            for (i = 0; i < numParameters; ++i) {
                if (!scriptCmdParams[i].isNumeric() || (double)scriptCmdParams[i].getValue() == 0.0 || (double)scriptCmdParams[i].getValue() == 1.0 || (double)scriptCmdParams[i].getValue() == 2.0) continue;
                this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.parameter", new Object[0]) + " " + scriptCmdParams[i].toString() + " " + SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.isNotAloow", new Object[0]) + " " + commandName, lineNum, cmdPos, ""));
                return null;
            }
        }
        ScriptCmd cmd = new ScriptCmd(cmdId.ordinal() + 1, numParameters, scriptCmdParams);
        cmd.setLineNum(lineNum);
        return cmd;
    }

    private ScriptCmdParam[] getCmdParams(String[] cmdParamsArray, int lineNum, int cmdPos, CommandId cmdId) {
        ScriptCmdParam[] scriptCmdParams = new ScriptCmdParam[10];
        if (cmdParamsArray.length > 10) {
            this.errorList.add(new CommandException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.toManyParams", new Object[0]), lineNum, cmdPos, ""));
            return null;
        }
        for (int j = 0; j < cmdParamsArray.length; ++j) {
            ScriptCmdParam param = this.getCmdParam(cmdParamsArray[j], lineNum, cmdPos, cmdId);
            if (param == null) {
                return null;
            }
            scriptCmdParams[j] = param;
        }
        return scriptCmdParams;
    }

    private ScriptCmdParam getCmdParam(String cmdParam, int lineNum, int cmdPos, CommandId cmdId) {
        String parameterName = null;
        try {
            Matcher matcher = pattern.matcher(cmdParam);
            if (matcher.matches()) {
                parameterName = matcher.group(1);
                String paramValue = matcher.group(2);
                String srcName = matcher.group(3);
                String rcMin = matcher.group(4);
                String rcMax = matcher.group(5);
                ScriptCmdParam scriptCmdParam = new ScriptCmdParam(cmdId);
                scriptCmdParam.setScriptParser(this);
                if (Utils.isInteger(parameterName)) {
                    scriptCmdParam.setId(Utils.toInteger(parameterName));
                    if (scriptCmdParam.isNamed()) {
                        throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterName", new Object[0]) + " " + parameterName);
                    }
                } else {
                    ParamId paramId = ParamId.fromString(parameterName);
                    if (paramId == null) {
                        throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterName", new Object[0]) + " " + parameterName);
                    }
                    scriptCmdParam.setId(paramId.toInteger());
                }
                if (paramValue != null) {
                    scriptCmdParam.setValue(paramValue);
                } else {
                    scriptCmdParam.setSrc(srcName, rcMin, rcMax);
                }
                return scriptCmdParam;
            }
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParams", new Object[0]) + " " + cmdParam);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (parameterName != null) {
                msg = msg + " for parameter " + parameterName;
            }
            this.errorList.add(new CommandException(msg, lineNum, cmdPos, ""));
            return null;
        }
    }

    private String removeUTF8BOM(String s) {
        return s.replace("\ufeff", "");
    }

    public static void parseCmdScriptDebug(SerialCommand cmd) {
        try {
            final int lineNumber = cmd.readWordUnsigned();
            final int error = cmd.readByte();
            logger.debug((Object)("script line " + lineNumber + ", error=" + error));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.panelScripting.processScriptDebugInfo(lineNumber, error);
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public Integer getLineNumForLabel(String label) {
        if (this.labels != null) {
            return this.labels.get(label);
        }
        return null;
    }

    public boolean isLineNumValid(int lineNum) {
        return this.cleanScriptStrings != null && lineNum >= 1 && lineNum <= this.cleanScriptStrings.size();
    }

    static {
        StringBuffer special_values = new StringBuffer();
        for (String op : ParamId.OPERATOR_VALUES) {
            special_values.append("\\").append(op).append("|");
        }
        for (String c : ParamId.COND_VALUES) {
            special_values.append("\\").append(c).append("|");
        }
        pattern = Pattern.compile("^(\\w+)\\(\\s*(?:([-]?\\d*\\.?\\d+|\\w+|(?:" + special_values.substring(0, special_values.length() - 1) + "))|(\\w+)\\s*\\[\\s*([-]?\\d*\\.?\\d+)\\s*\\,\\s*([-]?\\d*\\.?\\d+)\\s*\\])\\s*\\)$");
    }

    class ScriptStr {
        public String str;
        public int startPos;
        public int rawLine;

        public ScriptStr(String str, int startPos, int rawLine) {
            this.str = str;
            this.startPos = startPos;
            this.rawLine = rawLine;
        }
    }
}

