/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.script;

import java.util.Arrays;
import java.util.List;
import sbgc.script_parser.script.ParamId;

public enum CommandId {
    ANGLE("A", ParamId.RA, ParamId.PA, ParamId.YA, ParamId.RS, ParamId.PS, ParamId.YS, ParamId.TIMEOUT, ParamId.RMOD, ParamId.PMOD, ParamId.YMOD),
    INC("I", ParamId.RA, ParamId.PA, ParamId.YA, ParamId.RS, ParamId.PS, ParamId.YS, ParamId.TIMEOUT, ParamId.RMOD, ParamId.PMOD, ParamId.YMOD),
    SPEED("S", ParamId.RS, ParamId.PS, ParamId.YS),
    RESET("R", new ParamId[0]),
    TRIGGER("T", ParamId.NUMERIC, ParamId.TIMEOUT),
    DELAY("D", ParamId.TIMEOUT),
    WAIT("W", ParamId.RA, ParamId.PA, ParamId.YA, ParamId.RS, ParamId.PS, ParamId.YS, ParamId.TIMEOUT),
    CONFIG(null, ParamId.ACC_LIMIT_R, ParamId.ACC_LIMIT_P, ParamId.ACC_LIMIT_Y, ParamId.SPEED_R, ParamId.SPEED_P, ParamId.SPEED_Y, ParamId.INIT_SYSTEM_ON_FINISH, ParamId.JERK_SLOPE_R, ParamId.JERK_SLOPE_P, ParamId.JERK_SLOPE_Y),
    SERVO(null, ParamId.NUMERIC, ParamId.TIMEOUT, ParamId.TIME),
    MENU_CMD(null, ParamId.TIMEOUT, ParamId.CMD_ID),
    SET_ADJ_VAR(null, ParamId.NAME, ParamId.VALUE, ParamId.OPERATOR),
    PLAY_SOUND(null, ParamId.CMD_ID, ParamId.TIMEOUT),
    IF(null, ParamId.NAME, ParamId.VALUE, ParamId.COND, ParamId.GOTO);

    private final List<ParamId> params;
    private final String shortName;

    private CommandId(String shortName, ParamId ... params) {
        this.params = Arrays.asList(params);
        this.shortName = shortName;
    }

    public static CommandId fromString(String name) {
        for (CommandId id : CommandId.values()) {
            if (!id.name().equalsIgnoreCase(name) && (id.shortName == null || !name.equalsIgnoreCase(id.shortName))) continue;
            return id;
        }
        return null;
    }

    public static CommandId fromId(int id) {
        return CommandId.values()[id - 1];
    }

    public List<ParamId> getParams() {
        return this.params;
    }
}

