/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.script;

import java.io.IOException;
import java.io.Serializable;
import sbgc.script_parser.script.BadProgramException;
import sbgc.script_parser.script.CommandId;
import sbgc.script_parser.script.ParamId;
import sbgc.script_parser.script.ScriptCmdParam;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.service.DataOutputStreamLE;
import simplebgc_gui.SimpleBGC_GUIApp;

public class ScriptCmd
implements Serializable {
    private int id;
    private int paramNum;
    private ScriptCmdParam[] params = new ScriptCmdParam[10];
    private int lineNum = -1;
    private String label = null;

    public ScriptCmd(int id, int paramNum, ScriptCmdParam[] params) {
        this.id = id;
        this.paramNum = paramNum;
        this.params = params;
    }

    public int getId() {
        return this.id;
    }

    public int getParamNum() {
        return this.paramNum;
    }

    public ScriptCmdParam[] getParams() {
        return this.params;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(ScriptCmd scriptCmd) {
        if (scriptCmd.getId() != this.id || scriptCmd.getParamNum() != this.paramNum) {
            return false;
        }
        for (int i = 0; i < this.paramNum; ++i) {
            if (this.params[i].equals(scriptCmd.getParams()[i])) continue;
            return false;
        }
        return true;
    }

    public String toStringDump() {
        String stringDump = Integer.toString(this.id) + " ";
        for (int i = 0; i < this.paramNum; ++i) {
            stringDump = stringDump + this.params[i].toStringDump() + " ";
        }
        return stringDump;
    }

    public String toString() {
        String cmdString = Integer.toString(this.id) + " ";
        for (int i = 0; i < this.paramNum; ++i) {
            ScriptCmdParam scriptCmdParam = this.params[i];
            cmdString = cmdString + Integer.toString(scriptCmdParam.getId()) + "(" + Float.toString(scriptCmdParam.getValue()) + ") ";
        }
        return cmdString;
    }

    public String toScriptString(ScriptProgram scriptProgram) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CommandId.fromId(this.id).toString());
        for (int i = 0; i < this.paramNum; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.params[i].toScriptString(scriptProgram));
        }
        return stringBuffer.toString();
    }

    public void write(DataOutputStreamLE out) throws IOException {
        out.writeByte(this.id);
        out.writeByte(this.paramNum);
        for (int i = 0; i < this.paramNum; ++i) {
            this.params[i].write(out, CommandId.fromId(this.id));
        }
    }

    public void verify() throws BadProgramException {
        if (this.id - 1 >= CommandId.values().length) {
            throw new BadProgramException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidCommandId", new Object[0]));
        }
        CommandId commandId = CommandId.fromId(this.id);
        for (int i = 0; i < this.paramNum; ++i) {
            ParamId paramId;
            this.params[i].verify();
            if (!this.params[i].isNamed() || (paramId = this.params[i].getNamedId()) != null && commandId.getParams().contains((Object)paramId)) continue;
            throw new BadProgramException(SimpleBGC_GUIApp.getResourceMap().getString("error.ScriptParser.invalidParameterForCommand", new Object[0]));
        }
    }
}

