/*
 * Decompiled with CFR 0.152.
 */
package sbgc.script_parser.script;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import sbgc.script_parser.script.BadProgramException;
import sbgc.script_parser.script.ScriptCmd;
import sbgc.service.DataOutputStreamLE;

public class ScriptProgram
implements Serializable {
    private int cmdNum;
    private ScriptCmd[] cmd = new ScriptCmd[10000];

    public ScriptProgram(int cmdNum, ScriptCmd[] cmd) {
        this.cmdNum = cmdNum;
        this.cmd = cmd;
    }

    public int getCmdNum() {
        return this.cmdNum;
    }

    public ScriptCmd[] getCmd() {
        return this.cmd;
    }

    public boolean equals(ScriptProgram scriptProgram) {
        if (this.cmdNum != scriptProgram.getCmdNum()) {
            return false;
        }
        for (int i = 0; i < this.cmdNum; ++i) {
            if (this.cmd[i].equals(scriptProgram.getCmd()[i])) continue;
            return false;
        }
        return true;
    }

    public String toScriptString() {
        String[] lines = new String[this.cmdNum];
        for (int i = 0; i < this.cmdNum; ++i) {
            lines[i] = this.cmd[i].toScriptString(this);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cmdNum; ++i) {
            if (this.cmd[i].getLabel() != null) {
                stringBuffer.append(this.cmd[i].getLabel());
                stringBuffer.append(": ");
            }
            stringBuffer.append(lines[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void write(DataOutputStreamLE out) throws IOException {
        out.writeShort(this.cmdNum);
        for (int i = 0; i < this.cmdNum; ++i) {
            this.cmd[i].write(out);
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStreamLE out = new DataOutputStreamLE(bos);
        this.write(out);
        return bos.toByteArray();
    }

    public void verify() throws BadProgramException {
        for (int i = 0; i < this.cmdNum; ++i) {
            this.cmd[i].verify();
        }
    }

    public static int getScriptFileId(int slot) {
        return 256 + (slot - 1);
    }

    public int cmdIdxToLineNumber(int cmdIdx) {
        if (cmdIdx < 0) {
            cmdIdx = 0;
        }
        if (cmdIdx >= this.cmdNum) {
            cmdIdx = this.cmdNum - 1;
        }
        return this.cmd[cmdIdx].getLineNum() > 0 ? this.cmd[cmdIdx].getLineNum() : cmdIdx + 1;
    }

    public String addAutoLabel(int lineNum) {
        int idx = lineNum - 1;
        if (idx >= 0 && idx < this.cmdNum) {
            if (this.cmd[idx].getLabel() == null) {
                this.cmd[idx].setLabel("LINE" + lineNum);
            }
            return this.cmd[idx].getLabel();
        }
        return null;
    }
}

