/*
 * Decompiled with CFR 0.152.
 */
package sbgc.serial.command;

import java.io.IOException;
import org.apache.log4j.Logger;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SerialCommandSignMessageImpl {
    private static final Log logger = new Log(Logger.getLogger((String)SerialCommandSignMessageImpl.class.getName()));
    private int[] sign = new int[32];

    public String getSign() {
        return HexUtil.toHex(this.sign);
    }

    public void setSign(int[] sign) {
        this.sign = sign;
    }

    public static SerialCommandSignMessageImpl parse(SerialCommand cmd) throws IOException {
        SerialCommandSignMessageImpl command = new SerialCommandSignMessageImpl();
        int[] signData = new int[32];
        for (int j = 0; j < 32; ++j) {
            signData[j] = cmd.readByte();
        }
        command.setSign(signData);
        cmd.checkFinished();
        return command;
    }

    public String toString() {
        return "sign: " + this.getSign().substring(0, 5) + "..";
    }

    public static SerialCommand getCommandSignMessage(String message, int signType) throws Exception {
        SerialCommand command = new SerialCommand(50);
        command.writeByte(signType);
        byte[] data = HexUtil.fromHex(message);
        if (data.length != 32) {
            throw new Exception("Signed message should be exactly 32 bytes long!");
        }
        command.write(data);
        return command;
    }

    public static String signMessage(String message, int signType) throws Exception {
        SerialCommand command = SerialCommandSignMessageImpl.getCommandSignMessage(message, signType);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(command, 5000L);
        if (resp != null && resp.getId() == command.getId()) {
            logger.trace("Parsing sign message result...");
            SerialCommandSignMessageImpl signImpl = SerialCommandSignMessageImpl.parse(resp);
            String sign = signImpl.getSign();
            logger.trace("Sign: " + sign.substring(0, 5) + "...");
            return sign;
        }
        throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.failed_to_sign", new Object[0]));
    }
}

