/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import sbgc.mavlink.IMavLinkCommandListener;
import sbgc.mavlink.MavLink;
import sbgc.mavlink.MavLinkMessage;
import sbgc.service.DataPortNetworkBase;
import sbgc.service.IDataPort;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;

public class DataPortMavLinkImpl
extends DataPortNetworkBase
implements IDataPort,
IMavLinkCommandListener {
    public static final int PAYLOAD_TYPE_CMD_ID_OFFSET = Short.MAX_VALUE;
    public static final int PAYLOAD_TYPE_CMD_ID_RAW_DATA = 256;
    final MavLink mavLink;
    final IDataPort dataPort;
    final MavLinkMessage msg_tunnel;
    final MavLinkMessage msg_heartbeat;
    int target_comp_id;
    Thread heartbeatThread = null;

    public DataPortMavLinkImpl(IDataPort dataPort, int target_comp_id, int tunnelType) throws Exception {
        this.dataPort = dataPort;
        this.target_comp_id = target_comp_id;
        this.mavLink = new MavLink(null);
        this.mavLink.setComponent_id(242);
        this.mavLink.setOut_protocol(2);
        switch (tunnelType) {
            case 10: {
                this.msg_tunnel = new MavLinkMessage(385);
                break;
            }
            case 1: {
                this.msg_tunnel = new MavLinkMessage(248);
                break;
            }
            default: {
                throw new Exception("Unsupported tunnel type: " + tunnelType);
            }
        }
        this.msg_heartbeat = new MavLinkMessage(0);
        this.msg_heartbeat.payload = new byte[9];
        this.msg_heartbeat.payload[4] = 6;
        this.msg_heartbeat.payload[5] = 8;
        this.msg_heartbeat.payload[8] = 3;
    }

    @Override
    public synchronized void connect() throws Exception {
        this.mavLink.setCommandListener(this);
        this.baseConnect();
        this.dataPort.connect();
        this.mavLink.setDataPort(this.dataPort);
        this.heartbeatThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    DataPortMavLinkImpl.this.mavLink.send(DataPortMavLinkImpl.this.msg_heartbeat);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                        break;
                    }
                }
                logger.debug("HeartbeatThread is finished.");
            }
        });
        this.heartbeatThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() {
        if (this.heartbeatThread != null) {
            try {
                this.heartbeatThread.interrupt();
                this.heartbeatThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.heartbeatThread = null;
        MavLink mavLink = this.mavLink;
        synchronized (mavLink) {
            this.mavLink.setCommandListener(null);
            this.mavLink.setDataPort(null);
        }
        try {
            this.baseDisconnect();
            logger.info("Disconecting data port " + this.dataPort.getClass().getName() + "..");
            this.dataPort.disconnect();
        }
        catch (Exception e) {
            logger.error("Error closing MavLink tunnel: " + e.toString());
        }
    }

    @Override
    public void configure(int baudRate, int parity) throws Exception {
        this.dataPort.configure(baudRate, parity);
    }

    @Override
    public boolean isBaudRateSupported() {
        return this.dataPort.isBaudRateSupported();
    }

    @Override
    public boolean isBLESupported() {
        return this.dataPort.isBLESupported();
    }

    @Override
    public void setMode(int mode) {
        this.dataPort.setMode(mode);
    }

    @Override
    public void sendCmd(SerialCommand cmd, SerialCommandProcessor.ProtocolVersion protocolVer) throws Exception {
        this._send(cmd.id, cmd.data, 0, cmd.len);
    }

    @Override
    public void sendData(byte[] data, int pos, int len) throws Exception {
        this._send(256, data, pos, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _send(int cmdId, byte[] buf, int pos, int len) throws Exception {
        block10: {
            try {
                if (this.isConnected && this.mavLink.getSystem_id() > 0) {
                    Object tmp;
                    if (this.msg_tunnel.id == 385) {
                        tmp = new SerialCommand(0, len + 5);
                        ((SerialCommand)tmp).writeWord(cmdId + Short.MAX_VALUE);
                        ((SerialCommand)tmp).writeByte(this.mavLink.getSystem_id());
                        ((SerialCommand)tmp).writeByte(this.target_comp_id);
                        ((SerialCommand)tmp).writeByte(len);
                        ((SerialCommand)tmp).write(buf, pos, len);
                        this.msg_tunnel.payload = ((SerialCommand)tmp).data;
                    } else if (this.msg_tunnel.id == 248) {
                        tmp = new SerialCommand(0, len + 6);
                        ((SerialCommand)tmp).writeWord(cmdId + Short.MAX_VALUE);
                        ((SerialCommand)tmp).writeByte(0);
                        ((SerialCommand)tmp).writeByte(this.mavLink.getSystem_id());
                        ((SerialCommand)tmp).writeByte(this.target_comp_id);
                        ((SerialCommand)tmp).writeByte(len);
                        ((SerialCommand)tmp).write(buf, pos, len);
                        this.msg_tunnel.payload = ((SerialCommand)tmp).data;
                    } else {
                        throw new Exception("unknown message type");
                    }
                    tmp = this.msg_tunnel;
                    synchronized (tmp) {
                        this.mavLink.send(this.msg_tunnel);
                        this.lastSendTime = this.dataPort.getLastSendTime();
                        break block10;
                    }
                }
                throw new Exception("tunnel is not ready.");
            }
            catch (Exception e) {
                logger.warn("Command " + cmdId + " was not sent: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean onCommandReceived(MavLinkMessage msg) {
        if (msg.id == 0 && msg.system_id != this.mavLink.getSystem_id()) {
            logger.debug("Detected system_id=" + msg.system_id);
            this.mavLink.setSystem_id(msg.system_id);
        }
        if (msg.id == 385 || msg.id == 248) {
            SerialCommand buf = new SerialCommand(0, msg.payload);
            try {
                int payload_length;
                int target_comp;
                int target_sys;
                int cmd_id;
                if (msg.id == 385) {
                    cmd_id = buf.readWordUnsigned() - Short.MAX_VALUE;
                    target_sys = buf.readByte();
                    target_comp = buf.readByte();
                    payload_length = buf.readByte();
                } else {
                    cmd_id = buf.readWordUnsigned() - Short.MAX_VALUE;
                    buf.readByte();
                    target_sys = buf.readByte();
                    target_comp = buf.readByte();
                    payload_length = buf.readByte();
                }
                byte[] payload = new byte[payload_length];
                buf.read(payload, 0, Math.min(buf.getBytesAvailable(), payload_length));
                logger.trace("MavLink tunnel in: target=" + target_sys + ", " + target_comp + ", cmdId=" + cmd_id + ", payload=" + payload_length + " bytes");
                if (target_sys == this.mavLink.getSystem_id() && target_comp == this.mavLink.getComponent_id()) {
                    if (cmd_id > 0 && cmd_id <= 255) {
                        SerialCommand cmd = new SerialCommand(cmd_id, payload);
                        SerialCommandProcessor.processInCmd(cmd);
                    } else if (cmd_id == 256) {
                        super.onDataReceived(payload, 0, payload.length);
                    } else {
                        logger.debug("Unsupported msg #" + msg.id + ", ignored");
                    }
                } else {
                    logger.warn("Wrong target in msg #" + msg.id + ", ignored");
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
            catch (Exception e) {
                logger.stackTrace(e);
            }
        }
        return false;
    }
}

