/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.log4j.Logger;
import sbgc.service.IDataPort;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialEventDispatchThread;
import sbgc.utils.Log;

public abstract class DataPortNetworkBase
implements IDataPort {
    public static final Log logger = new Log(Logger.getLogger((String)DataPortNetworkBase.class.getName()));
    public static final int MAX_COMMAND_SIZE = 512;
    public static final int PIPE_BUFFER_SIZE = 5120;
    boolean isConnected;
    private PipedInputStream pipedInputStream = null;
    private PipedOutputStream pipedOutputStream = null;
    SerialEventDispatchThread eventDispatcher = null;
    int readTimeout = -1;
    long lastSendTime = -1L;

    protected void baseConnect() throws Exception {
        this.pipedOutputStream = new PipedOutputStream();
        this.pipedInputStream = new PipedInputStream(this.pipedOutputStream, 5120);
        this.isConnected = true;
        this.eventDispatcher = new SerialEventDispatchThread();
        this.eventDispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void baseDisconnect() throws Exception {
        logger.debug("Disconnecting DataPortNetworkBase..");
        this.isConnected = false;
        this.pipedOutputStream.close();
        PipedInputStream pipedInputStream = this.pipedInputStream;
        synchronized (pipedInputStream) {
            this.pipedInputStream.close();
            this.pipedInputStream.notifyAll();
        }
        this.eventDispatcher.interrupt();
        this.eventDispatcher.join(1000L);
    }

    protected void onDataReceived(byte[] data, int offset, int length) throws Exception {
        this.pipedOutputStream.write(data, offset, length);
        this.pipedOutputStream.flush();
        this.eventDispatcher.fireEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws Exception {
        PipedInputStream pipedInputStream = this.pipedInputStream;
        synchronized (pipedInputStream) {
            if (this.readTimeout >= 0) {
                long wait_time;
                long timeout_ms = System.currentTimeMillis() + (long)this.readTimeout;
                while (this.pipedInputStream.available() == 0 && (wait_time = timeout_ms - System.currentTimeMillis()) > 0L) {
                    this.pipedInputStream.wait(wait_time);
                }
                return this.pipedInputStream.available() > 0 ? this.pipedInputStream.read() : -1;
            }
            return this.pipedInputStream.read();
        }
    }

    @Override
    public void sendCmd(SerialCommand cmd, SerialCommandProcessor.ProtocolVersion protocolVer) throws Exception {
        byte[] data = cmd.getBytes(protocolVer);
        this.sendData(data, 0, data.length);
    }

    @Override
    public InputStream getInputStream() {
        return this.pipedInputStream;
    }

    @Override
    public void removeEventListener() {
        this.eventDispatcher.removeEventListener();
    }

    @Override
    public void addEventListener(SerialPortEventListener listener) {
        this.eventDispatcher.addEventListener(listener);
    }

    @Override
    public void enableReceiveTimeout(int timeout) throws Exception {
        this.readTimeout = timeout;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public boolean isBaudRateSupported() {
        return false;
    }

    @Override
    public boolean isBLESupported() {
        return false;
    }

    @Override
    public void setMode(int mode) {
    }

    @Override
    public long getLastSendTime() {
        return this.lastSendTime;
    }
}

