/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import sbgc.service.DataPortNetworkBase;
import sbgc.service.ICommandResponseListener;
import sbgc.service.IDataPort;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;

public class DataPortProxyImpl
extends DataPortNetworkBase
implements IDataPort,
ICommandResponseListener {
    SerialCommand cmdOut = new SerialCommand(113);

    @Override
    public synchronized void connect() throws Exception {
        SerialCommandDispatcher.getInstance().addResponseListener(this);
        this.baseConnect();
    }

    @Override
    public synchronized void disconnect() {
        SerialCommandDispatcher.getInstance().removeResponseListener(this);
        try {
            this.baseDisconnect();
        }
        catch (Exception e) {
            logger.error("Error closing serial proxy: " + e.toString());
        }
    }

    @Override
    public void configure(int baudRate, int parity) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(byte[] data, int pos, int len) throws Exception {
        if (this.isConnected) {
            SerialCommand serialCommand = this.cmdOut;
            synchronized (serialCommand) {
                this.cmdOut.reset();
                this.cmdOut.write(data, pos, len);
                SerialCommandProcessor.sendCommand(this.cmdOut);
                if (SerialCommandProcessor.dataPort != null) {
                    this.lastSendTime = SerialCommandProcessor.dataPort.getLastSendTime();
                }
            }
        }
    }

    @Override
    public void onCommandReceived(SerialCommand cmd) {
        if (cmd.id == 113) {
            int dataLength = cmd.getBytesAvailable();
            logger.trace("DataPortProxy in: " + SerialCommand.dumpBytes(cmd.data, cmd.len));
            try {
                super.onDataReceived(cmd.data, 0, dataLength);
            }
            catch (Exception e) {
                logger.stackTrace(e);
            }
        }
    }

    @Override
    public int getCommandId() {
        return 113;
    }
}

