/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import sbgc.service.IDataPort;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DataPortSerialImpl
implements IDataPort {
    public static final int MODE_BLE = 1;
    public static final int BLE_PACKET_SIZE = 20;
    public static final int BLE_PACKET_PERIOD_MS = 7;
    static final Log logger = new Log(Logger.getLogger((String)DataPortSerialImpl.class.getName()));
    private SerialPort serialPort = null;
    private String portName = null;
    private long lastSendTime = -1L;
    private int curBaudRate = 0;
    private int mode = 0;

    public DataPortSerialImpl(String portName) {
        this.portName = portName;
    }

    @Override
    public void connect() throws Exception {
        CommPortIdentifier portIdentifier = null;
        try {
            portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.portName);
        }
        catch (Exception e) {
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.cant_open_port", this.portName));
        }
        if (portIdentifier.isCurrentlyOwned()) {
            throw new Exception(SimpleBGC_GUIApp.getResourceMap().getString("error.port_occupied", this.portName));
        }
        RXTXPort commPort = portIdentifier.open(DataPortSerialImpl.class.getName(), 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new Exception("This port type not supported: " + this.portName);
        }
        this.serialPort = (SerialPort)commPort;
        logger.info("Opened " + this.portName);
    }

    @Override
    public void disconnect() throws Exception {
        if (this.serialPort != null) {
            this.serialPort.getInputStream().close();
            this.serialPort.close();
        }
    }

    @Override
    public void sendCmd(SerialCommand cmd, SerialCommandProcessor.ProtocolVersion protocolVer) throws Exception {
        byte[] data = cmd.getBytes(protocolVer);
        this.sendData(data, 0, data.length);
    }

    @Override
    public void sendData(byte[] data, int offset, int length) throws Exception {
        if (this.serialPort != null) {
            if (this.mode == 1) {
                int len;
                int to_pos = Math.min(offset + length, data.length);
                for (int pos = offset; pos < to_pos; pos += len) {
                    long wait = 7L - (System.currentTimeMillis() - this.lastSendTime);
                    if (wait > 0L) {
                        Thread.sleep(wait);
                    }
                    len = Math.min(20, to_pos - pos);
                    this._sendData(data, pos, len);
                }
            } else {
                this._sendData(data, offset, length);
            }
        }
    }

    private void _sendData(byte[] data, int pos, int len) throws Exception {
        if (this.serialPort != null) {
            OutputStream os = this.serialPort.getOutputStream();
            os.write(data, pos, len);
            os.flush();
            this.lastSendTime = System.currentTimeMillis();
            if (this.curBaudRate > 0) {
                this.lastSendTime += (long)Math.round(1000.0f * (float)len * 10.0f / (float)this.curBaudRate);
            }
            if (SimpleBGC_GUIApp.serialDebug) {
                logger.trace(this.portName + " out: " + HexUtil.toHex(data, pos, len, " "));
            }
        }
    }

    @Override
    public int read() throws Exception {
        return this.serialPort.getInputStream().read();
    }

    @Override
    public void configure(int baudRate, int parity) throws Exception {
        if (this.serialPort != null) {
            this.serialPort.setSerialPortParams(baudRate, 8, 1, parity);
            this.curBaudRate = baudRate;
        }
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.serialPort != null) {
            return this.serialPort.getInputStream();
        }
        return null;
    }

    @Override
    public void removeEventListener() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
        }
    }

    @Override
    public void addEventListener(SerialPortEventListener listener) throws Exception {
        if (this.serialPort != null) {
            this.serialPort.addEventListener(listener);
            this.serialPort.notifyOnDataAvailable(true);
        }
    }

    @Override
    public void enableReceiveTimeout(int timeout) throws Exception {
        if (this.serialPort != null) {
            this.serialPort.enableReceiveTimeout(timeout);
        }
    }

    @Override
    public boolean isBaudRateSupported() {
        return true;
    }

    @Override
    public boolean isBLESupported() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.serialPort != null;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    @Override
    public long getLastSendTime() {
        return this.lastSendTime;
    }
}

