/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import sbgc.object.Sprav;
import sbgc.service.IJoystickUpdateEventListener;
import sbgc.utils.Log;

public class Joystick
implements Runnable {
    protected Log logger = null;
    private final Controller controller;
    private boolean isActive = false;
    private Thread thread = null;
    private final IJoystickUpdateEventListener listener;
    public int update_interval_ms;
    public static final Component.Identifier[] ANALOG_AXES_IDENTIFIERS = new Component.Identifier[]{Component.Identifier.Axis.X, Component.Identifier.Axis.Y, Component.Identifier.Axis.Z, Component.Identifier.Axis.RX, Component.Identifier.Axis.RY, Component.Identifier.Axis.RZ, Component.Identifier.Axis.POV};
    public static final Component.Identifier[] BUTTON_IDENTIFIERS = new Component.Identifier[]{Component.Identifier.Button._0, Component.Identifier.Button._1, Component.Identifier.Button._2, Component.Identifier.Button._3, Component.Identifier.Button._4, Component.Identifier.Button._5, Component.Identifier.Button._6, Component.Identifier.Button._7, Component.Identifier.Button._8, Component.Identifier.Button._9};
    private static final HashMap<Component.Identifier, Integer> buttonIndex = new HashMap();
    public float[] analogValues = new float[ANALOG_AXES_IDENTIFIERS.length];
    public boolean[] buttons = new boolean[BUTTON_IDENTIFIERS.length];
    private Object[] buttonEvents;

    public Joystick(String controllerName, int update_interval_ms, IJoystickUpdateEventListener listener) throws Exception {
        this.update_interval_ms = update_interval_ms;
        this.listener = listener;
        this.logger = Log.getLogger(Joystick.class.getName());
        this.buttonEvents = new Object[BUTTON_IDENTIFIERS.length];
        for (int i = 0; i < this.buttonEvents.length; ++i) {
            this.buttonEvents[i] = new LinkedList();
        }
        Controller c = null;
        Controller[] ca = ControllerEnvironment.getDefaultEnvironment().getControllers();
        for (int i = 0; i < ca.length; ++i) {
            this.logger.trace("Controller: " + ca[i].getName() + " type: " + ca[i].getType().toString());
            if (ca[i].getType() != Controller.Type.GAMEPAD || controllerName != null && !ca[i].getName().equals(controllerName)) continue;
            c = ca[i];
            break;
        }
        this.controller = c;
        if (this.controller == null) {
            if (controllerName != null) {
                throw new Exception("Controller '" + controllerName + "' is not found in the system");
            }
            throw new Exception("No suitable controllers found");
        }
    }

    public static ArrayList<Sprav> getControllerList() {
        ArrayList<Sprav> controllerList = new ArrayList<Sprav>();
        Controller[] ca = ControllerEnvironment.getDefaultEnvironment().getControllers();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i].getType() != Controller.Type.GAMEPAD) continue;
            controllerList.add(new Sprav(ca[i].getPortNumber(), ca[i].getName()));
        }
        return controllerList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        this.logger.debug("Starting joystick thread..");
        if (!this.isActive) {
            if (!this.controller.poll()) throw new Exception("Controller is not connected");
            this.thread = new Thread(this);
            this.thread.start();
            return;
        } else {
            this.logger.warn("Joystick thread is alive");
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.logger.debug("Finishing joystick thread..");
            this.isActive = false;
            this.thread.interrupt();
        }
    }

    public void debugInfo() {
        this.logger.debug("Component: " + this.controller.getName() + " type: " + this.controller.getType().toString());
        Component[] components = this.controller.getComponents();
        this.logger.debug("Component Count: " + components.length);
        for (int j = 0; j < components.length; ++j) {
            this.logger.debug("Component " + j + ": " + components[j].getName());
            System.out.print("    ComponentType: ");
            if (components[j].isRelative()) {
                System.out.print("Relative");
            } else {
                System.out.print("Absolute");
            }
            if (components[j].isAnalog()) {
                System.out.print(" Analog");
                continue;
            }
            System.out.print(" Digital");
        }
    }

    @Override
    public void run() {
        this.logger.debug("Joystick thread is started.");
        this.isActive = true;
        EventQueue queue = this.controller.getEventQueue();
        Event event = new Event();
        while (this.isActive) {
            int i;
            this.controller.poll();
            for (i = 0; i < ANALOG_AXES_IDENTIFIERS.length; ++i) {
                Component c = this.controller.getComponent(ANALOG_AXES_IDENTIFIERS[i]);
                if (c == null) continue;
                this.analogValues[i] = c.getPollData();
            }
            while (queue.getNextEvent(event)) {
                Integer idx;
                Component c = event.getComponent();
                if (c.isAnalog() || (idx = buttonIndex.get(c.getIdentifier())) == null) continue;
                boolean val = event.getValue() == 1.0f;
                ((LinkedList)this.buttonEvents[idx]).addLast(val);
            }
            for (i = 0; i < this.buttons.length; ++i) {
                Boolean nextVal = (Boolean)((LinkedList)this.buttonEvents[i]).pollFirst();
                if (nextVal == null) continue;
                this.buttons[i] = nextVal;
            }
            if (this.listener != null) {
                this.listener.onJoystickUpdateEvent(this);
            }
            try {
                Thread.sleep(this.update_interval_ms);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.debug("Joystick thread is finished.");
    }

    static {
        for (int i = 0; i < BUTTON_IDENTIFIERS.length; ++i) {
            buttonIndex.put(BUTTON_IDENTIFIERS[i], i);
        }
    }
}

