/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.DebugVars;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.TabbedPanelMonitoring;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class RealtimeDataThread {
    static final Logger logger = Logger.getLogger((String)RealtimeDataThread.class.getName());
    public static final int SUSPENDED_FRAME_RATE = 5;
    private static int frameRate = 1;
    private static Thread thread = null;
    private static volatile boolean paused = false;
    private static boolean suspended = false;

    public static void start() {
        if (thread != null) {
            thread.interrupt();
        }
        logger.info((Object)"Starting realtime data thread..");
        final TabbedPanelMonitoring panelMonitoring = SimpleBGC_GUIApp.mainView.panelMonitoring;
        thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("RTData");
                if (Settings.is("realtime.debug_vars")) {
                    DebugVars.requestDebugVarsInfo(0);
                }
                if (Settings.is("realtime.log_to_file")) {
                    panelMonitoring.startLogging(Settings.get("realtime.log_rewrite", "true").equals("true"));
                }
                SerialCommand cmd_realtime_data_4 = new SerialCommand(BoardInfo.checkMinPartnerFirmwareVer(2410) ? 25 : 23);
                SerialCommand cmd_debug_vars_3 = new SerialCommand(254);
                int slot_cnt = 0;
                while (!this.isInterrupted()) {
                    int _frameRate = suspended ? Math.min(frameRate, 5) : frameRate;
                    int delay = 1000 / _frameRate;
                    try {
                        Thread thread = thread;
                        synchronized (thread) {
                            while (paused) {
                                this.wait();
                            }
                        }
                        if (SimpleBGC_GUIApp.mainView.panelMonitoring.isRequestBasicDataEnabled()) {
                            SerialCommandProcessor.sendCommand(cmd_realtime_data_4);
                        }
                        Thread.sleep(delay / 2);
                        if (SimpleBGC_GUIApp.mainView.isPanelVisible(panelMonitoring) || panelMonitoring.isDataLogEnabled()) {
                            int canDrvIdx;
                            if (DebugVars.hasInfo() && DebugVars.fillRequestCommand(cmd_debug_vars_3)) {
                                SerialCommandProcessor.sendCommand(cmd_debug_vars_3);
                            }
                            if (!suspended && (canDrvIdx = SimpleBGC_GUIApp.mainView.panelMonitoring.getCurCanDrvIdx()) >= 0) {
                                SerialCommand cmd = new SerialCommand(101);
                                cmd.writeByte(1 << canDrvIdx);
                                SerialCommandProcessor.sendCommand(cmd);
                            }
                        }
                        if (!suspended) {
                            if (SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelAdjVars) && slot_cnt == 0) {
                                SerialCommand cmd = new SerialCommand(46);
                                cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.trigger_cur_slot);
                                if (SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar != null) {
                                    cmd.writeWord(SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar.src_ch);
                                    cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.selectedVar.var_id);
                                } else {
                                    cmd.writeEmptyArr(3);
                                }
                                cmd.writeWord(SimpleBGC_GUIApp.mainView.panelAdjVars.showLUTSignalId);
                                cmd.writeByte(SimpleBGC_GUIApp.mainView.panelAdjVars.showLUTVarId);
                                cmd.writeEmptyArr(10);
                                SerialCommandProcessor.sendCommand(cmd);
                            }
                            if (SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelMavlink)) {
                                if (slot_cnt == 1) {
                                    SerialCommand cmd = new SerialCommand(250);
                                    SerialCommandProcessor.sendCommand(cmd);
                                } else if (slot_cnt == 2 && BoardInfo.hasBoardFeature(65536L)) {
                                    SerialCommandProcessor.sendCommand(new SerialCommand(106));
                                }
                            } else if (SimpleBGC_GUIApp.mainView.isPanelVisible(SimpleBGC_GUIApp.mainView.panelHardwareSettings)) {
                                SerialCommandProcessor.sendCommand(new SerialCommand(106));
                            }
                        }
                        Thread.sleep(delay / 2);
                    }
                    catch (InterruptedException ignore) {
                        break;
                    }
                    catch (IOException e) {
                        logger.error((Object)e.toString());
                    }
                    slot_cnt = (slot_cnt + 1) % 4;
                    SimpleBGC_GUIApp.mainView.panelMonitoring.chart.update();
                }
                panelMonitoring.stopLogging();
                logger.info((Object)"RealtimeDataThread is finished.");
            }
        };
        thread.start();
    }

    public static void stop() {
        logger.info((Object)"Finishing realtime data thread..");
        if (thread != null) {
            thread.interrupt();
        }
    }

    public static void setFrameRate(int rate) {
        frameRate = rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pause(final boolean state) {
        boolean old_state = paused;
        paused = state;
        if (old_state != state) {
            if (thread != null && !paused) {
                logger.debug((Object)"Resuming realtime data thread..");
                Thread thread = RealtimeDataThread.thread;
                synchronized (thread) {
                    RealtimeDataThread.thread.notify();
                }
            }
            if (SimpleBGC_GUIApp.mainView != null) {
                SimpleBGC_GUIView.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!state) {
                            SimpleBGC_GUIApp.mainView.panelMonitoring.chart.start();
                        }
                        SimpleBGC_GUIApp.mainView.updateRealtimeData();
                    }
                });
            }
        }
        return old_state;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void suspend(boolean state) {
        suspended = state;
    }

    public static boolean isSuspended() {
        return suspended;
    }
}

