/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sbgc.object.AutoPIDInfo;
import sbgc.object.BoardInfo;
import sbgc.object.BodeTest;
import sbgc.object.CanDrvRealtimeData;
import sbgc.object.DebugVars;
import sbgc.object.ErrorInfo;
import sbgc.object.RealtimeData;
import sbgc.object.VibrationTest;
import sbgc.script_parser.manager.ScriptParser;
import sbgc.service.ConnectThread;
import sbgc.service.ICommandListener;
import sbgc.service.ICommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SerialCommandDispatcher
implements ICommandListener {
    private static SerialCommandDispatcher instance = new SerialCommandDispatcher();
    static final Logger logger = Logger.getLogger((String)SerialCommandDispatcher.class.getName());
    private final ConcurrentHashMap<Integer, CopyOnWriteArrayList<ICommandResponseListener>> listeners = new ConcurrentHashMap();

    public static SerialCommandDispatcher getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(ICommandResponseListener listener) {
        logger.debug((Object)("Adding listeners for cmd " + listener.getCommandId() + ".."));
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<ICommandResponseListener>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<Object> commandListeners = null;
            if (this.listeners.get(listener.getCommandId()) != null) {
                commandListeners = this.listeners.get(listener.getCommandId());
            } else {
                commandListeners = new CopyOnWriteArrayList();
                this.listeners.put(listener.getCommandId(), commandListeners);
            }
            commandListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResponseListener(ICommandResponseListener listener) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<ICommandResponseListener>> concurrentHashMap = this.listeners;
        synchronized (concurrentHashMap) {
            CopyOnWriteArrayList<ICommandResponseListener> commandListeners = this.listeners.get(listener.getCommandId());
            if (commandListeners != null) {
                logger.debug((Object)("Removing listeners for cmd " + listener.getCommandId() + ".."));
                commandListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serialCommandEvent(SerialCommand cmd) {
        int commandIdForListener = cmd.id;
        SerialCommandProcessor.debugSerialCommand(cmd, false);
        try {
            CopyOnWriteArrayList<ICommandResponseListener> matchedListeners;
            block3 : switch (cmd.id) {
                case 21: 
                case 33: 
                case 62: 
                case 82: 
                case 104: {
                    SerialCommandProcessor.onReadParamsCmd(cmd);
                    break;
                }
                case 67: {
                    int c;
                    commandIdForListener = c = cmd.readByte();
                    logger.debug((Object)("Command (" + c + ") confirmed."));
                    switch (c) {
                        case 22: 
                        case 34: 
                        case 44: 
                        case 63: 
                        case 87: 
                        case 105: {
                            SerialCommandProcessor.onWriteCmdConfirmation(c, cmd);
                            break block3;
                        }
                        case 59: 
                        case 65: 
                        case 93: 
                        case 103: {
                            int action = 1;
                            if (cmd.getBytesAvailable() > 0) {
                                action = cmd.readByte();
                            }
                            if (action == 1 || action == 3) {
                                ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.sensor_calibration_started", new Object[0]));
                                break block3;
                            }
                            if (action == 255) {
                                ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.sensor_calibration_finished", new Object[0]));
                                break block3;
                            }
                            if (action == 2) {
                                ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.sensor_calibration_deleted", new Object[0]));
                                break block3;
                            }
                            if (action == 254) {
                                ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.sensor_calibration_error", new Object[0]));
                                break block3;
                            }
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.command_sent", new Object[0]));
                            break block3;
                        }
                        case 80: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.poles_calibration", new Object[0]));
                            break block3;
                        }
                        case 71: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.ext_gain_calibration", new Object[0]));
                            break block3;
                        }
                        case 77: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.motors_on", new Object[0]));
                            break block3;
                        }
                        case 109: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.motors_off", new Object[0]));
                            break block3;
                        }
                        case 26: 
                        case 27: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.encoder_calibration", new Object[0]));
                            break block3;
                        }
                        case 35: {
                            ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.auto_pid_started", new Object[0]));
                            break block3;
                        }
                        case 47: 
                        case 67: 
                        case 108: 
                        case 121: 
                        case 137: {
                            break block3;
                        }
                    }
                    ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.command_sent", new Object[0]));
                    break;
                }
                case 20: 
                case 86: {
                    BoardInfo info = BoardInfo.getBoardInfo();
                    if (cmd.id != 86 && info == null) break;
                    info = BoardInfo.parse(cmd);
                    logger.info((Object)info.toString());
                    if (cmd.id == 86) {
                        SerialCommandProcessor.sendCommand(new SerialCommand(20));
                        break;
                    }
                    this.processCmdInUI(cmd);
                    break;
                }
                case 23: 
                case 25: 
                case 68: {
                    RealtimeData.parse(cmd);
                    break;
                }
                case 253: {
                    DebugVars.parseInfo(cmd);
                    break;
                }
                case 254: {
                    DebugVars.parse(cmd);
                    break;
                }
                case 38: {
                    BodeTest.instance.parse_data(cmd);
                    break;
                }
                case 37: {
                    BodeTest.instance.on_stop_cmd(cmd);
                    break;
                }
                case 46: {
                    RealtimeData.parseCmdAdjVarsState(cmd);
                    break;
                }
                case 114: {
                    ErrorInfo.updateStatus(SimpleBGC_GUIApp.getResourceMap().getString("status.reset", new Object[0]));
                    if ((BoardInfo.getBoardInfo() == null || (BoardInfo.getBoardInfo().connectionFlags & 1) == 0) && (SimpleBGC_GUIApp.mainView == null || SimpleBGC_GUIApp.mainView.isSerialCommunicationActive())) break;
                    new Thread(){

                        @Override
                        public void run() {
                            ConnectThread.reconnect(3000);
                        }
                    }.start();
                    break;
                }
                case 58: {
                    ScriptParser.parseCmdScriptDebug(cmd);
                    break;
                }
                case 251: {
                    RealtimeData.parseCmdMavlinkDebug(cmd);
                    break;
                }
                case 250: {
                    RealtimeData.parseCmdMavlinkInfo(cmd);
                    break;
                }
                case 255: {
                    int cmd_id_err;
                    commandIdForListener = cmd_id_err = cmd.readByte();
                    String err_info = ErrorInfo.formatCmdErrorInfo(cmd);
                    logger.error((Object)("CMD_ERROR on command id=" + cmd_id_err + " received: " + err_info));
                    ErrorInfo.updateStatus(err_info);
                    break;
                }
                case 101: {
                    CanDrvRealtimeData.parse(cmd);
                    break;
                }
                case 249: {
                    SimpleBGC_GUIApp.mainView.panelDebug.parseCmdSetDebugPort(cmd);
                    break;
                }
                case 28: {
                    if (BoardInfo.getBoardInfo() != null) {
                        BoardInfo.getBoardInfo().parseProfileNames(cmd);
                    }
                }
                case 35: 
                case 92: 
                case 106: {
                    this.processCmdInUI(cmd);
                    break;
                }
                case 126: {
                    VibrationTest.instance.parse_data(cmd);
                    break;
                }
                case 125: {
                    VibrationTest.instance.on_stop_cmd(cmd);
                    break;
                }
                case 248: {
                    SimpleBGC_GUIApp.mainView.panelDebug.parseCmdDebugStr(cmd);
                }
            }
            Integer key = new Integer(commandIdForListener);
            if (this.listeners.containsKey(key) && (matchedListeners = this.listeners.get(key)) != null) {
                Iterator<ICommandResponseListener> iterator = matchedListeners.iterator();
                while (iterator.hasNext()) {
                    ICommandResponseListener listener;
                    ICommandResponseListener iCommandResponseListener = listener = iterator.next();
                    synchronized (iCommandResponseListener) {
                        cmd.startReading();
                        listener.onCommandReceived(cmd);
                    }
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.warn((Object)("Error dispatching command " + cmd.id + ": " + e.toString()));
            ErrorInfo.addError(256);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    void processCmdInUI(final SerialCommand cmd) {
        if (SimpleBGC_GUIApp.mainView != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        switch (cmd.id) {
                            case 20: 
                            case 86: {
                                SimpleBGC_GUIApp.mainView.updateBoardInfo();
                                break;
                            }
                            case 28: {
                                SimpleBGC_GUIApp.mainView.updateProfileNames();
                                break;
                            }
                            case 92: {
                                SimpleBGC_GUIApp.mainView.panelStabilizationSettings.parseCoggingCalibInfo(cmd);
                                break;
                            }
                            case 35: {
                                SimpleBGC_GUIApp.mainView.panelStabilizationSettings.updateAutoPIDInfo(AutoPIDInfo.parse(cmd));
                                break;
                            }
                            case 106: {
                                SimpleBGC_GUIApp.mainView.panelMavlink.parseExtIMUDebugInfo(cmd);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to process serial command " + cmd.id + ": " + e.toString()));
                    }
                }
            });
        }
    }
}

