/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service;

import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.CRC32;
import javax.swing.SwingUtilities;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.CANDeviceScanInfo;
import sbgc.object.CanDrvHardParams;
import sbgc.object.CustomTune;
import sbgc.object.ErrorInfo;
import sbgc.object.Sprav;
import sbgc.service.CommandResponseListener;
import sbgc.service.ConnectThread;
import sbgc.service.ICommandListener;
import sbgc.service.IDataPort;
import sbgc.service.ParamsReaderThread;
import sbgc.service.ParamsWriterThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SerialCommandProcessor {
    static ICommandListener commandListener = null;
    static IDataPort dataPort = null;
    static final Log logger = Log.getLogger(SerialCommandProcessor.class.getName());
    static final SimpleDateFormat msFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    static ParamsWriterThread writeParamsThread = null;
    static ParamsReaderThread readParamsThread = null;
    static int confirmedCmdId;
    static SerialCommand cmdReadFile;
    public static final int PROFILE_ID_ALL_PROFILES = -1;
    public static final int PROFILE_ID_CUR_PROFILE = 50;
    public static final int PROFILE_ID_ADJ_VARS = 51;
    public static final int PROFILE_ID_CAN_ID_MAP = 52;
    public static final int PROFILE_ID_CAN_DRV_SOFT = 53;
    public static final int PROFILE_ID_REACTION_PARAMS = 54;
    static ProtocolVersion protocolVerCfg;
    static ProtocolVersion protocolVerIn;
    static ProtocolVersion protocolVerOut;
    private static Date lastPing;
    private static final int ONLINE_TIME_MS = 1000;
    public static final int ERR_FILE_NOT_FOUND = 2;
    private static final String[] fileErrors;
    private static final int[] menu_select_profile;
    public static int EXT_SENS_FLAG_HIGH_PRIOR;

    public static void setCommandListener(ICommandListener l) {
        commandListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDataPort(IDataPort s) {
        dataPort = s;
        if (dataPort != null) {
            IDataPort iDataPort = dataPort;
            synchronized (iDataPort) {
                try {
                    dataPort.removeEventListener();
                    dataPort.addEventListener(new SerialReader(dataPort.getInputStream()));
                    dataPort.enableReceiveTimeout(500);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dataPort = null;
                }
            }
        }
    }

    public static IDataPort getDataPort() {
        return dataPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCommand(SerialCommand cmd) {
        block5: {
            SerialCommandProcessor.debugSerialCommand(cmd, true);
            try {
                if (dataPort == null) break block5;
                IDataPort iDataPort = dataPort;
                synchronized (iDataPort) {
                    dataPort.sendCmd(cmd, protocolVerOut);
                }
            }
            catch (Exception e) {
                ErrorInfo.addError(32);
            }
        }
    }

    public static ProtocolVersion protocolVerFromInt(int v) {
        if (v == 1) {
            return ProtocolVersion.V1;
        }
        if (v == 2) {
            return ProtocolVersion.V2;
        }
        return ProtocolVersion.AUTO;
    }

    public static void applyProtocolVerSettings() {
        try {
            protocolVerCfg = SerialCommandProcessor.protocolVerFromInt(Integer.parseInt(Settings.get("serial.protocol_ver", "0")));
        }
        catch (Exception ignore) {
            protocolVerCfg = ProtocolVersion.AUTO;
        }
        if (protocolVerCfg == ProtocolVersion.AUTO) {
            if (BoardInfo.getBoardInfo() != null) {
                protocolVerOut = BoardInfo.checkMinPartnerFirmwareVer(2680) ? ProtocolVersion.V2 : ProtocolVersion.V1;
                protocolVerIn = protocolVerOut;
            } else {
                protocolVerIn = protocolVerCfg;
                protocolVerOut = ProtocolVersion.V1;
            }
        } else {
            protocolVerIn = protocolVerOut = protocolVerCfg;
        }
        logger.debug("Protocol version set to " + protocolVerIn.name() + "(in), " + protocolVerOut.name() + "(out)");
    }

    public static void setProtocolVer(ProtocolVersion ver) {
        protocolVerOut = protocolVerIn = ver;
    }

    public static void setProtocolVerOut(ProtocolVersion ver) {
        protocolVerOut = ver;
    }

    public static void setProtocolVerIn(ProtocolVersion ver) {
        protocolVerIn = ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnline() {
        Date date = lastPing;
        synchronized (date) {
            return new Date().getTime() - lastPing.getTime() < 1000L;
        }
    }

    public static void debugSerialCommand(final SerialCommand cmd, final boolean isOut) {
        int level;
        if (SimpleBGC_GUIApp.mainView != null && (level = SimpleBGC_GUIApp.mainView.panelDebug.showCommandLevel(cmd, cmd.isHeavyDutyCommand(isOut))) != 0) {
            logger.debug((isOut ? "OUT:" : "IN:") + cmd.toString() + (isOut ? "" : " " + msFormat.format(new Date(cmd.timestamp))));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.panelDebug.debugMessage(Log.formatCurTime() + " " + (isOut ? "out" : "in") + ": " + (level == 2 ? cmd.toString() : "[" + cmd.id + "," + cmd.len + "]"));
                }
            });
        }
    }

    public static void processInCmd(SerialCommand cmd) {
        if (commandListener != null) {
            cmd.startReading();
            if (commandListener.serialCommandEvent(cmd)) {
                ErrorInfo.clearError(256);
                lastPing = new Date();
            } else {
                logger.warn("Unknown command id=" + cmd.id);
                ErrorInfo.addError(256);
            }
        } else if (!cmd.isHeavyDutyCommand(false)) {
            logger.debug("IN:" + cmd.toString() + " " + msFormat.format(new Date(cmd.timestamp)));
        }
    }

    public static boolean isReadParamsThreadActive() {
        return readParamsThread != null && readParamsThread.isAlive();
    }

    public static boolean isWriteParamsThreadActive() {
        return writeParamsThread != null && writeParamsThread.isAlive();
    }

    public static void readAllParams(int profileId) {
        if (!SerialCommandProcessor.isReadParamsThreadActive() && !SerialCommandProcessor.isWriteParamsThreadActive()) {
            logger.info("Reading all params for profile " + profileId + " from the board..");
            readParamsThread = new ParamsReaderThread(profileId, logger);
            readParamsThread.start();
        }
    }

    public static void onReadParamsCmd(SerialCommand cmd) throws Exception {
        if (!SerialCommandProcessor.isReadParamsThreadActive()) {
            int profile_id = cmd.readByte();
            BoardParams newParams = BoardParams.getCurParams().clone();
            newParams.parse(cmd, profile_id, BoardInfo.getBoardInfo());
            logger.info("Profile " + profile_id + " successfuly parsed");
            BoardParams.setCurParams(newParams);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateBoardParams();
                }
            });
        }
    }

    public static void useDefaults(final int profile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    boolean rtState = RealtimeDataThread.pause(true);
                    try {
                        SimpleBGC_GUIApp.mainView.onProgressStart("Resetting system to factory defaults settings...", true);
                        SerialCommand cmd = new SerialCommand(70, 1);
                        cmd.writeByte(profile);
                        CommandResponseListener resetListener = CommandResponseListener.registerResponseListener(114, 60000L);
                        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 20000L, SimpleBGC_GUIApp.mainView);
                        if (resp == null) {
                            throw new Exception("No response on CMD_USE_DEFAULTS command!");
                        }
                        if (resp.id == 255) {
                            throw new Exception(ErrorInfo.formatCmdErrorInfo(resp));
                        }
                        if (!BoardInfo.checkMinPartnerFirmwareVer(1)) break block14;
                        resp = resetListener.waitFor(SimpleBGC_GUIApp.mainView);
                        ConnectThread.initConnection(true);
                        for (int i = 0; i < 100 && !ConnectThread.isConnected; ++i) {
                            try {
                                ConnectThread.getThread().join(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (SimpleBGC_GUIApp.mainView.onProgressChange(i)) continue;
                            return;
                        }
                        if (!ConnectThread.isConnected) {
                            throw new Exception("Failed to reconnect to the board.");
                        }
                        SerialCommandProcessor.readAllParams(-1);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.toString());
                    }
                    catch (Exception e) {
                        SimpleBGC_GUIApp.mainView.showErrorMessage(e.getMessage());
                    }
                    finally {
                        RealtimeDataThread.pause(rtState);
                        SimpleBGC_GUIApp.mainView.onProgressFinish(true);
                    }
                }
            }
        }).start();
    }

    public static void waitForReset(IProgressListener progressListener) {
        SerialCommandProcessor.waitForReset(progressListener, 5000);
    }

    public static void waitForReset(IProgressListener progressListener, int delay_ms) {
        logger.debug("Waiting for CMD_RESET..");
        CommandResponseListener resetListener = CommandResponseListener.registerResponseListener(114, 6000L);
        try {
            if (resetListener.waitFor(progressListener) != null) {
                logger.debug("Delay " + delay_ms + " ms..");
                for (int i = 0; i < delay_ms; i += 100) {
                    if (progressListener != null && !progressListener.onProgressChange(i * 100 / delay_ms)) {
                        return;
                    }
                    Thread.sleep(100L);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public static ParamsWriterThread writeAllParams(BoardParams params, int profileId, IProgressListener progressListener) {
        if (!SerialCommandProcessor.isReadParamsThreadActive() && !SerialCommandProcessor.isWriteParamsThreadActive() && params != null) {
            logger.info("Writing all params for profile " + profileId + " to the board..");
            if (params.loadedFrom == BoardParams.LoadedFrom.BOARD_INCOMPLETE && SimpleBGC_GUIApp.mainView != null && !SimpleBGC_GUIApp.mainView.showConfirmDialog(SimpleBGC_GUIApp.getResourceMap().getString("confirm.write_incomplete_params", new Object[0]), true)) {
                return null;
            }
            writeParamsThread = new ParamsWriterThread(params, profileId, logger, progressListener);
            writeParamsThread.start();
            return writeParamsThread;
        }
        return null;
    }

    public static void onWriteCmdConfirmation(int cmd_id, SerialCommand cmd) {
        if (writeParamsThread != null) {
            writeParamsThread.onWriteCmdConfirmation(cmd_id, cmd);
        }
    }

    public static void stopSerialCommunication() {
        if (SerialCommandProcessor.isWriteParamsThreadActive()) {
            writeParamsThread.interrupt();
        }
        if (SerialCommandProcessor.isReadParamsThreadActive()) {
            readParamsThread.interrupt();
        }
    }

    public static byte[] readEEPROM(int fromAddr, int len, IProgressListener progressListener) throws Exception {
        logger.info("Reading EPROM from address " + fromAddr + " " + len + " bytes..");
        byte[] buf = new byte[len];
        boolean rtState = RealtimeDataThread.pause(true);
        try {
            int part_size = 192;
            int offset = 0;
            while (offset < len) {
                int addr = fromAddr + offset;
                SerialCommand cmd = new SerialCommand(48, 6);
                cmd.writeDWord(addr);
                cmd.writeWord(Math.min(len - offset, 192));
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 1000L);
                if (resp == null || resp.id != cmd.id) {
                    throw new Exception("No response on CMD_EEPROM_READ command");
                }
                if (addr == (int)resp.readDWordUnsigned()) {
                    int size = resp.len - 4;
                    if (offset + size <= buf.length) {
                        resp.read(buf, offset, size);
                        if (progressListener == null || progressListener.onProgressChange((offset += size) * 100 / len)) continue;
                        throw new InterruptedException("Operation is cancelled by user!");
                    }
                    throw new Exception("Wrong data received: addr=" + addr + ", size=" + size);
                }
                throw new Exception("Wrong data received while reading from addr=" + addr);
            }
        }
        catch (Exception e) {
            logger.error(e + Log.formatStackTrace(e));
            throw e;
        }
        finally {
            RealtimeDataThread.pause(rtState);
        }
        return buf;
    }

    public static void writeEEPROM(int toAddr, byte[] data, IProgressListener progressListener) throws Exception {
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null && boardInfo.eeprom_size > 0) {
            if (toAddr + data.length > boardInfo.eeprom_size) {
                throw new Exception("Writing to address " + toAddr + " portion of " + data.length + " bytes overflows the board's EEPROM size (" + boardInfo.eeprom_size + ")");
            }
            boolean rtState = RealtimeDataThread.pause(true);
            try {
                int part_size = 192;
                for (int offset = 0; offset < data.length; offset += part_size) {
                    int addr = toAddr + offset;
                    SerialCommand cmd = new SerialCommand(47);
                    cmd.writeDWord(addr);
                    cmd.write(data, offset, Math.min(data.length - offset, part_size));
                    SerialCommandProcessor.sendCommand(cmd);
                    SerialCommand resp = CommandResponseListener.waitFor(cmd.id, 1000L);
                    if (resp == null) {
                        throw new Exception("No response on CMD_EEPROM_WRITE command");
                    }
                    resp.readByte();
                    if (addr == (int)resp.readDWordUnsigned()) {
                        if (progressListener == null || progressListener.onProgressChange(addr * 100 / data.length)) continue;
                        throw new InterruptedException("Operation is cancelled by user!");
                    }
                    throw new Exception("Wrong confirmation received while writing to addr=" + addr);
                }
            }
            catch (Exception e) {
                logger.error(e + Log.formatStackTrace(e));
                throw e;
            }
            finally {
                RealtimeDataThread.pause(rtState);
            }
        } else {
            throw new Exception("BoardInfo is not received, or EEPROM writing is not supported!");
        }
    }

    public static void sendCalibExtended(int cmdId, int imuType, int action, int time_ms, boolean waitConfirm) throws Exception {
        SerialCommand cmd = new SerialCommand(cmdId);
        cmd.writeByte(imuType);
        cmd.writeByte(action);
        cmd.writeWord(time_ms);
        cmd.writeEmptyArr(8);
        if (waitConfirm) {
            SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
            if (resp != null) {
                if (resp.id == 67) {
                    return;
                }
                if (resp.id == 255) {
                    throw new Exception(ErrorInfo.formatCmdErrorInfo(resp));
                }
            }
            throw new Exception("Calibration command was not confirmed.");
        }
        SerialCommandProcessor.sendCommand(cmd);
    }

    public static void writeFile(int fileId, byte[] data, IProgressListener progressListener) throws Exception {
        boolean rtState = RealtimeDataThread.pause(true);
        try {
            if (data != null && data.length > 0) {
                logger.debug("Writing file Id=" + fileId + " size " + data.length + " bytes to EEPROM..");
                int part_size = 192;
                for (int addr = 0; addr < data.length; addr += part_size) {
                    SerialCommand cmd = new SerialCommand(54);
                    cmd.writeWord(fileId);
                    cmd.writeWord(data.length);
                    cmd.writeWord(addr / 64);
                    if (addr + part_size > data.length) {
                        part_size = data.length - addr;
                    }
                    cmd.write(data, addr, part_size);
                    SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
                    if (resp == null || resp.id != 67) {
                        throw new Exception("No response on CMD_WRITE_FILE command");
                    }
                    resp.readByte();
                    int err = resp.readByte();
                    if (err == 0) {
                        if (progressListener == null || progressListener.onProgressChange(addr * 100 / data.length)) continue;
                        throw new InterruptedException("Operation is cancelled by user!");
                    }
                    throw new Exception("Error writing to addr=" + addr + ": " + SerialCommandProcessor.getFileErrorMessage(err));
                }
            } else {
                logger.debug("Deleting file Id=" + fileId + " from the EEPROM..");
                SerialCommand cmd = new SerialCommand(54);
                cmd.writeWord(fileId);
                cmd.writeWord(0);
                cmd.writeWord(0);
                SerialCommandProcessor.sendCommand(cmd);
                SerialCommand resp = CommandResponseListener.waitFor(cmd.id, 5000L);
                if (resp == null) {
                    throw new Exception("No response on CMD_WRITE_FILE command");
                }
                resp.readByte();
                int err = resp.readByte();
                if (err != 0 && err != 2) {
                    throw new Exception("Error deleting file: " + SerialCommandProcessor.getFileErrorMessage(err));
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            RealtimeDataThread.pause(rtState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static byte[] readFile(int fileId, IProgressListener progressListener) throws Exception {
        var2_2 = SerialCommandProcessor.cmdReadFile;
        // MONITORENTER : var2_2
        SerialCommandProcessor.logger.debug("Reading file " + fileId + " from the board..");
        rtState = RealtimeDataThread.pause(true);
        cmd = SerialCommandProcessor.cmdReadFile;
        try {
            data = null;
            part_size = 192;
            addr = 0;
            while (true) {
                block19: {
                    page_offset = addr / 64;
                    cmd.reset();
                    cmd.writeWord(fileId);
                    cmd.writeWord(page_offset);
                    cmd.writeWord(part_size);
                    cmd.writeEmptyArr(14);
                    resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                    if (resp == null) throw new Exception("No response on CMD_READ_FILE command");
                    if (resp.id == 255) {
                        throw new Exception("No response on CMD_READ_FILE command");
                    }
                    var10_11 = resp;
                    // MONITORENTER : var10_11
                    resp.startReading();
                    if (resp.len == 1) {
                        err = resp.readByte();
                        if (err != 2) throw new Exception("Error reading from addr=" + addr + ": " + SerialCommandProcessor.getFileErrorMessage(err));
                        throw new FileNotFoundException("File id=" + fileId + " is not found");
                    }
                    file_size = resp.readWordUnsigned();
                    page_offset_resp = resp.readWordUnsigned();
                    if (page_offset != page_offset_resp) ** GOTO lbl50
                    if (data == null) {
                        data = new byte[file_size];
                    } else if (data.length != file_size) {
                        throw new Exception("Wrong file size in CMD_READ_FILE: " + file_size);
                    }
                    size = resp.getBytesAvailable();
                    if (addr + size > data.length) break block19;
                    resp.read(data, addr, size);
                    if (progressListener != null && !progressListener.onProgressChange((addr += size) * 100 / data.length)) {
                        throw new InterruptedException("Operation is cancelled by user!");
                    }
                    if (addr == data.length) {
                        SerialCommandProcessor.logger.debug("File is read successfully: " + data.length + " bytes");
                        var14_15 = data;
                        // MONITOREXIT : var10_11
                        return var14_15;
                    }
                    ** GOTO lbl50
                }
                throw new Exception("Wrong data size in CMD_READ_FILE: " + size);
lbl50:
                // 2 sources

                // MONITOREXIT : var10_11
                continue;
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            RealtimeDataThread.pause(rtState);
        }
    }

    public static final String getFileErrorMessage(int err) {
        if (err < fileErrors.length) {
            return fileErrors[err];
        }
        return "Unknow error code <" + err + ">";
    }

    public static void flashModuleFirmware(byte[] data, int deviceId, IProgressListener progressListener) throws Exception {
        boolean rtState = RealtimeDataThread.pause(true);
        int missed = 4 - data.length % 4;
        if (missed < 4) {
            byte[] new_data = Arrays.copyOf(data, data.length + missed);
            while (--missed > 0) {
                new_data[data.length + missed] = -1;
            }
            data = new_data;
        }
        SerialCommand resp = null;
        try {
            CRC32 crc32 = new CRC32();
            SerialCommand cmd = new SerialCommand(78);
            cmd.writeByte(deviceId);
            cmd.writeDWord(data.length);
            resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
            if (resp == null || resp.id != 67) {
                throw new Exception("Error sending CMD_MODULE_FLASH_START command");
            }
            int addr = 0;
            int packetId = 0;
            while (addr < data.length) {
                cmd = new SerialCommand(81);
                cmd.writeByte(deviceId);
                cmd.writeByte(packetId &= 0xFF);
                cmd.writeDWord(addr);
                int size = Math.min(128, data.length - addr);
                crc32.reset();
                crc32.update(data, addr, size);
                cmd.writeDWord(crc32.getValue());
                cmd.write(data, addr, size);
                resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
                if (resp == null || resp.id != 67) {
                    throw new Exception("Error sending CMD_MODULE_FLASH_WRITE command");
                }
                resp.readByte();
                int resp_packetId = resp.readByte();
                if (resp_packetId != packetId) {
                    throw new Exception("Wrong confirmatin on command CMD_MODULE_FLASH_WRITE");
                }
                if (progressListener != null && !progressListener.onProgressChange(addr * 100 / data.length)) {
                    throw new InterruptedException("Operation is cancelled by user!");
                }
                addr += 128;
                ++packetId;
            }
            cmd = new SerialCommand(83);
            cmd.writeByte(deviceId);
            crc32.reset();
            crc32.update(data);
            cmd.writeDWord(crc32.getValue());
            resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
            if (resp == null || resp.id != 67) {
                throw new Exception("Error sending CMD_MODULE_FLASH_FINISH command");
            }
        }
        catch (Exception e) {
            if (resp != null && resp.id == 255) {
                resp.readByte();
                int errCode = resp.readByte();
                int p1 = resp.readWord();
                int p2 = resp.readWord();
                throw new Exception(e.getMessage() + " (code " + errCode + ":" + p1 + ":" + p2 + ")");
            }
            throw e;
        }
        finally {
            RealtimeDataThread.pause(rtState);
        }
    }

    public static ArrayList<Sprav> requestModuleList(IProgressListener progressListener) throws Exception {
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(new SerialCommand(76), 10000L, progressListener);
        if (resp == null) {
            throw new Exception("No response on CMD_MODULE_LIST command");
        }
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        int size = resp.readByte();
        while (--size >= 0) {
            int id = resp.readByte();
            int board_ver = resp.readWordUnsigned();
            int boot_ver = resp.readWordUnsigned();
            int main_ver = resp.readWordUnsigned();
            resp.skipBytes(6);
            list.add(new Sprav(id, BoardInfo.getCANModuleName(id) + String.format(" (hw.ver: %.2f, frw.ver: %.2f, boot.ver: %.2f)", (double)board_ver / 100.0, (double)main_ver / 100.0, (double)boot_ver / 100.0)));
        }
        resp.checkFinished();
        return list;
    }

    public static boolean sendCmdCalibCogging(int action, boolean waitConfirm, boolean[] axis, int[] angle, int[] lpf, int[] speed, int[] period, int iterations) {
        try {
            SerialCommand cmd = new SerialCommand(93);
            cmd.writeByte(action);
            cmd.writeByte((axis[0] ? 1 : 0) | (axis[1] ? 2 : 0) | (axis[2] ? 4 : 0));
            for (int i = 0; i < 3; ++i) {
                cmd.writeWord(angle[i]);
                cmd.writeByte(lpf[i]);
                cmd.writeByte(speed[i]);
                cmd.writeWord(period[i]);
                cmd.writeEmptyArr(9);
            }
            cmd.writeByte(iterations);
            cmd.writeEmptyArr(9);
            if (waitConfirm) {
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
                if (resp == null || resp.id != 67) {
                    return false;
                }
            } else {
                SerialCommandProcessor.sendCommand(cmd);
            }
            return true;
        }
        catch (Exception e) {
            logger.stackTrace(e);
            return false;
        }
    }

    public static void sendCmdProfileSet(int slot, int action, IProgressListener progressListener) throws Exception {
        SerialCommand cmd = new SerialCommand(95);
        cmd.writeByte(slot);
        cmd.writeByte(action);
        cmd.writeEmptyArr(8);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L, progressListener);
        if (resp == null || resp.id != 67 || resp.len < 2) {
            throw new Exception("No answer on command!");
        }
        resp.readByte();
        int res = resp.readByte();
        if (res != 0) {
            throw new Exception("Error executing command: " + SerialCommandProcessor.getFileErrorMessage(res));
        }
    }

    public static CanDrvHardParams readCanDrvHardParams(int module_id, int action, IProgressListener progressListener) throws Exception {
        SerialCommand cmd = new SerialCommand(97);
        cmd.writeByte(module_id);
        cmd.writeByte(action);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L, progressListener);
        if (resp == null) {
            throw new Exception("No answer on command!");
        }
        if (resp.id == 255) {
            resp.readByte();
            int err_code = resp.readByte();
            throw new Exception(SerialCommandProcessor.getFileErrorMessage(err_code));
        }
        if (resp.id == 97) {
            int id = resp.readByte();
            if (id == module_id) {
                CanDrvHardParams p = new CanDrvHardParams();
                p.parseSerialCommand(resp);
                return p;
            }
            throw new Exception("Wrong module Id in response: " + id);
        }
        throw new Exception("Unknow response: " + resp.id);
    }

    public static void writeCanDrvHardParams(int module_id, CanDrvHardParams p, IProgressListener progressListener) throws Exception {
        SerialCommand cmd = new SerialCommand(97);
        cmd.writeByte(module_id);
        cmd.writeByte(15);
        p.formatSerialCommand(cmd);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L, progressListener);
        if (resp == null) {
            throw new Exception("No answer on command!");
        }
        if (resp.id == 255) {
            resp.readByte();
            int err_code = resp.readByte();
            throw new Exception(SerialCommandProcessor.getFileErrorMessage(err_code));
        }
        if (resp.id == 67) {
            resp.readByte();
            int id = resp.readByte();
            if (id != module_id) {
                throw new Exception("Wrong module Id in response: " + id);
            }
        } else {
            throw new Exception("Unknow response: " + resp.id);
        }
    }

    public static SerialCommand createCmdCanDrvCalibrate(int drvIdx, int action) throws Exception {
        SerialCommand cmd = new SerialCommand(99);
        cmd.writeByte(drvIdx);
        cmd.writeByte(action);
        cmd.writeEmptyArr(18);
        return cmd;
    }

    public static void activateProfile(int profileId) {
        SerialCommandProcessor.sendCmdExecuteMenu(menu_select_profile[profileId]);
    }

    public static HashMap<String, CANDeviceScanInfo> sendCmdCanDrvDeviceScan(IProgressListener progressListener) throws Exception {
        SerialCommand cmd = new SerialCommand(96);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 20000L, progressListener);
        if (resp == null) {
            throw new Exception("No answer on command!");
        }
        if (resp.id == 255) {
            resp.readByte();
            int err_code = resp.readByte();
            throw new Exception("Controller has responded \n\"" + SerialCommandProcessor.getFileErrorMessage(err_code) + "\"");
        }
        if (resp.id == 96) {
            HashMap<String, CANDeviceScanInfo> deviceScanList = new HashMap<String, CANDeviceScanInfo>();
            int[] uid_arr = new int[12];
            while (resp.getBytesAvailable() > 0) {
                CANDeviceScanInfo d = new CANDeviceScanInfo();
                resp.readByteArr(uid_arr);
                d.id = resp.readByte();
                int tmp = resp.readByte();
                d.type = tmp & 0x7F;
                d.hard_assign = (tmp & 0x80) > 0;
                deviceScanList.put(HexUtil.toHex(uid_arr), d);
            }
            resp.checkFinished();
            return deviceScanList;
        }
        throw new Exception("Unknow response: " + resp.id);
    }

    public static void sendCmdBeepSound(int tune_id, String tune_str) throws Exception {
        int[] BEEP_MODES = new int[]{32, 2, 64, 1};
        int BEEP_MODE_CUSTOM_MELODY = 32768;
        SerialCommand cmd = new SerialCommand(89);
        if (tune_str != null && !tune_str.isEmpty()) {
            cmd.writeWord(32768);
            cmd.write(CustomTune.stringToBytes(tune_str));
        } else {
            cmd.writeWord(BEEP_MODES[tune_id]);
            cmd.writeEmptyArr(10);
        }
        SerialCommandProcessor.sendCommand(cmd);
    }

    public static int sendCmdSetSetDeviceAddr(int device, long addr, int flags, IProgressListener progressListener) throws Exception {
        if (device == 34) {
            device = 1;
        }
        SerialCommand cmd = new SerialCommand(107);
        cmd.writeByte(device);
        cmd.writeDWord(addr);
        cmd.writeWord(flags);
        cmd.writeEmptyArr(28);
        SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L, progressListener);
        if (resp.id == 67) {
            return 0;
        }
        if (resp.id == 255) {
            return resp.data[1] != 0 ? resp.data[1] : 255;
        }
        return -1;
    }

    public static void sendCmdExecuteMenu(int menuCmd) {
        try {
            SerialCommand cmd = new SerialCommand(69, 1);
            cmd.writeByte(menuCmd);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
    }

    public static void sendCmdReset() {
        SerialCommandProcessor.sendCommand(new SerialCommand(114));
    }

    public static ProtocolVersion getCurProtocolVer() {
        return protocolVerIn;
    }

    public static String sendCmdWriteParamsSet(boolean startFinish) {
        if (BoardInfo.checkMinPartnerFirmwareVer(2695)) {
            logger.info((startFinish ? "Starting" : "Finishing") + " 'write command set' mode..");
            try {
                SerialCommand cmd = new SerialCommand(119);
                cmd.writeByte(startFinish ? 1 : 0);
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 2000L);
                if (resp == null) {
                    return new String("No answer on CMD_WRITE_PARAMS_SET");
                }
                if (resp.id == 255) {
                    return "CMD_WRITE_PARAMS_SET: " + ErrorInfo.formatCmdErrorInfo(resp);
                }
            }
            catch (InterruptedException cmd) {
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return null;
    }

    public static SerialCommand extImuWrapCmd(int wrapCmdId, int cmdId, boolean highPriority) throws IOException {
        SerialCommand cmd = new SerialCommand(wrapCmdId);
        if (wrapCmdId == 150) {
            cmd.writeByte(highPriority ? EXT_SENS_FLAG_HIGH_PRIOR : 0);
        }
        cmd.writeByte(cmdId);
        return cmd;
    }

    public static boolean isPortConnected() {
        return SimpleBGC_GUIApp.mainView.isPortConnected();
    }

    public static boolean readBoardInfo(int cmdId) {
        logger.debug("Requesting board info (" + cmdId + ")..");
        try {
            SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(new SerialCommand(cmdId), 3000L);
            BoardInfo.parse(resp);
        }
        catch (Exception e) {
            logger.warn(e.toString());
        }
        return false;
    }

    public static SerialCommand getCmdBoardInfo(String password) {
        SerialCommand cmdBoardInfo = new SerialCommand(86);
        try {
            cmdBoardInfo.writeWord(Settings.is("connect.BLE") ? 7 : 0);
            if (password != null && password.length() > 0) {
                cmdBoardInfo.writeString(password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmdBoardInfo;
    }

    public static String getEmergencyStopErrorInfo(IProgressListener progressListener) {
        String info = null;
        try {
            byte[] data = SerialCommandProcessor.readEEPROM(4416, 128, progressListener);
            info = BoardInfo.formatEmergencyStopErrorInfo(data);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return info;
    }

    public static void send_CMD_API_VIRT_CH_HIGH_RES(int[] values) {
        try {
            SerialCommand cmd = new SerialCommand(116);
            for (int i = 0; i < values.length; ++i) {
                cmd.writeWord(values[i]);
            }
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
    }

    public static SerialCommand getCmdCalibOrientCorr(int mode) {
        SerialCommand cmd = new SerialCommand(91);
        try {
            cmd.writeByte(mode);
            cmd.writeEmptyArr(15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    static {
        cmdReadFile = new SerialCommand(53);
        protocolVerCfg = ProtocolVersion.AUTO;
        protocolVerIn = ProtocolVersion.AUTO;
        protocolVerOut = ProtocolVersion.V1;
        lastPing = new Date();
        fileErrors = new String[]{"No error", "EEPROM access fault", "File is not found", "FAT records fault", "No free space left", "FAT is full", "File size is invalid", "CRC check failed", "Limit reached", "File corrupted", "Wrong params", "File system is locked by another operation"};
        menu_select_profile = new int[]{1, 2, 3, 14, 15};
        EXT_SENS_FLAG_HIGH_PRIOR = 1;
    }

    public static class SerialReader
    implements SerialPortEventListener {
        final InputStream in;
        boolean isActive;
        byte[] hdr = new byte[3];

        public SerialReader(InputStream in) {
            this.in = in;
            this.isActive = true;
        }

        public void serialEvent(SerialPortEvent arg0) {
            try {
                while (this.in.available() > 0) {
                    int c = this.in.read();
                    ProtocolVersion cur_ver = ProtocolVersion.AUTO;
                    if (protocolVerIn == ProtocolVersion.AUTO) {
                        if (c == 62) {
                            cur_ver = ProtocolVersion.V1;
                        } else if (c == 36) {
                            cur_ver = ProtocolVersion.V2;
                        }
                    } else if (protocolVerIn == ProtocolVersion.V1) {
                        if (c == 62) {
                            cur_ver = ProtocolVersion.V1;
                        }
                    } else if (c == 36) {
                        cur_ver = ProtocolVersion.V2;
                    }
                    if (cur_ver != ProtocolVersion.AUTO) {
                        int cs;
                        int size;
                        long timestamp = System.currentTimeMillis();
                        int id = this.in.read();
                        if ((id + (size = this.in.read()) & 0xFF) == ((cs = this.in.read()) & 0xFF)) {
                            boolean crc_ok;
                            int cnt;
                            SerialCommand cmd = new SerialCommand(id, size, timestamp);
                            while (cmd.len < size && (cnt = this.in.read(cmd.data, cmd.len, size - cmd.len)) > 0) {
                                cmd.len += cnt;
                            }
                            if (cur_ver == ProtocolVersion.V1) {
                                crc_ok = cmd.getChecksum() == this.in.read();
                            } else {
                                int crc16 = FileUtil.crc16_init();
                                this.hdr[0] = (byte)id;
                                this.hdr[1] = (byte)size;
                                this.hdr[2] = (byte)cs;
                                crc16 = FileUtil.crc16_update(this.hdr, 0, 3, crc16);
                                boolean bl = crc_ok = (crc16 = FileUtil.crc16_update(cmd.data, 0, cmd.len, crc16)) == (this.in.read() & 0xFF) + ((this.in.read() & 0xFF) << 8);
                            }
                            if (crc_ok) {
                                ErrorInfo.clearError(32);
                                SerialCommandProcessor.processInCmd(cmd);
                                continue;
                            }
                            logger.warn("wrong data checksum! " + cmd.toString());
                            ErrorInfo.addError(32);
                            continue;
                        }
                        logger.warn("wrong header checksum!");
                        ErrorInfo.addError(32);
                        continue;
                    }
                    logger.warn("Unknown start byte: " + c);
                    ErrorInfo.addError(32);
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception: " + e.toString());
                ErrorInfo.addError(32);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum ProtocolVersion {
        AUTO,
        V1,
        V2;

    }
}

