/*
 * Decompiled with CFR 0.152.
 */
package sbgc.service.upgrade;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.Log;
import sbgc.utils.xml.IParseable;
import sbgc.utils.xml.XmlUtils;

public class VersionFactory
implements IParseable {
    private static final Log logger = new Log(Logger.getLogger((String)VersionFactory.class.getName()));
    public static final String[] versionTypes = new String[]{"firmware", "gui"};
    private HashMap<String, VersionImpl> parsedVersions = new HashMap();

    public static VersionImpl getVersion(Integer ver) {
        VersionImpl version = new VersionImpl(ver);
        return version;
    }

    public static HashMap<String, VersionImpl> parseVersionsFromXml(byte[] xml) throws Exception {
        VersionFactory factory = new VersionFactory();
        XmlUtils.parse(xml, (IParseable)factory);
        return factory.getParsedVersions();
    }

    public static VersionImpl parseVersionFromTagAttributes(Attributes attributes) throws Exception {
        Integer ver = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!"ver".equalsIgnoreCase(attributes.getLocalName(i))) continue;
            String verValue = attributes.getValue(i);
            try {
                ver = new Integer(verValue);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Invalid value for \"ver\" attribute: " + verValue);
            }
        }
        return VersionFactory.getVersion(ver);
    }

    public HashMap<String, VersionImpl> getParsedVersions() {
        return this.parsedVersions;
    }

    @Override
    public void onStartElement(String name, Attributes attributes) {
        for (String versionType : versionTypes) {
            if (!versionType.equalsIgnoreCase(name)) continue;
            try {
                this.parsedVersions.put(versionType, VersionFactory.parseVersionFromTagAttributes(attributes));
            }
            catch (Exception e) {
                logger.error("Error parsing \"" + versionType + "\" tag: " + e.toString());
            }
        }
    }

    @Override
    public void onEndElement(String name, String content) {
    }

    public static String formatBoardVersion(int ver) {
        return String.format("%.1f", (double)ver / 10.0);
    }
}

