/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import sbgc.object.DebugVar;
import sbgc.utils.AvgFilter;
import sbgc.utils.PeakMeter;

public class AnglePanel
extends JPanel {
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static final Color colorBar = new Color(204, 204, 204);
    private static final Color colorPeak = new Color(0, 153, 255);
    private static final Color colorPowerBarBorder = new Color(0, 0, 0);
    private static final Color colorPowerBar = new Color(170, 0, 0);
    private static final Stroke debugVarStroke = new BasicStroke(3.0f);
    private static final int ANG_METER_SCALE = 10;
    private static final int powerBarHeight = 40;
    private static final int powerBarWidth = 10;
    private BufferedImage img = null;
    private BufferedImage bgImg = null;
    private BufferedImage markerImg = null;
    private BufferedImage markerRCImg = null;
    private BufferedImage balanceImg = null;
    private BufferedImage frameImg = null;
    private BufferedImage pausedImg = null;
    private float rotationAngle = 0.0f;
    private float RCAngle = 0.0f;
    private PeakMeter peakMeter;
    private AvgFilter avgFilter;
    private int power;
    private Float frameAngle = null;
    private Integer balanceError = null;
    private HashMap<Integer, DebugVar> debugVars = new HashMap();
    private boolean isPaused = false;

    public AnglePanel(URL imgURL, URL bgImgURL) throws IOException {
        this.img = ImageIO.read(imgURL);
        if (bgImgURL != null) {
            this.bgImg = ImageIO.read(bgImgURL);
        }
        this.markerImg = ImageIO.read(this.getClass().getResource("/simplebgc_gui/resources/marker.png"));
        this.markerRCImg = ImageIO.read(this.getClass().getResource("/simplebgc_gui/resources/marker_rc3.png"));
        this.balanceImg = ImageIO.read(this.getClass().getResource("/simplebgc_gui/resources/marker_balance.png"));
        this.frameImg = ImageIO.read(this.getClass().getResource("/simplebgc_gui/resources/frame_arrow.png"));
        this.pausedImg = ImageIO.read(this.getClass().getResource("/simplebgc_gui/resources/paused.png"));
        this.setVisible(true);
        df.getDecimalFormatSymbols().setDecimalSeparator('.');
        this.peakMeter = new PeakMeter(70);
        this.avgFilter = new AvgFilter(50.0f);
    }

    public static int constrain(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    @Override
    public void paintComponent(Graphics g) {
        int spanX;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform oldTransform = g2d.getTransform();
        int spanY = spanX = (this.getWidth() - this.img.getWidth()) / 2;
        int centerX = this.getWidth() / 2;
        int centerY = this.img.getHeight() / 2 + spanY;
        if (this.frameAngle != null) {
            double angle = Math.toRadians(this.frameAngle.floatValue());
            g2d.rotate(angle, centerX, centerY);
            g2d.drawImage((Image)this.frameImg, centerX - this.frameImg.getWidth() / 2, centerY - this.frameImg.getHeight() / 2, this);
            g2d.rotate(-angle, centerX, centerY);
        }
        if (this.bgImg != null) {
            spanY = (this.bgImg.getHeight() - this.img.getHeight()) / 2;
            int bgSpan = (this.getWidth() - this.bgImg.getWidth()) / 2;
            g2d.drawImage((Image)this.bgImg, bgSpan, 0, this);
        }
        int y = this.getHeight() - 30;
        g2d.setFont(new Font("Arial", 1, 12));
        g2d.setColor(colorBar);
        g2d.drawString(df.format(this.rotationAngle), centerX - 25, y);
        g2d.setColor(colorPeak);
        g2d.drawString(df.format(this.getError()), centerX + 15, y);
        y += 5;
        g2d.setColor(colorBar);
        int size = AnglePanel.constrain((int)(this.peakMeter.getCur() * 10.0f), -50, 50);
        if (size > 0) {
            g2d.fillRect(centerX, y, size, 10);
        } else if (size < 0) {
            g2d.fillRect(centerX + size, y, -size, 10);
        }
        g2d.setColor(colorPeak);
        int min = AnglePanel.constrain((int)(this.peakMeter.getMin() * 10.0f), -50, 0);
        g2d.fillRect(centerX + min - 1, y, 2, 10);
        int max = AnglePanel.constrain((int)(this.peakMeter.getMax() * 10.0f), 0, 50);
        g2d.fillRect(centerX + max - 1, y, 2, 10);
        g2d.setColor(colorPowerBarBorder);
        y = this.getHeight() - 40 - 2;
        int x = this.getWidth() - 10 - 1;
        g2d.drawRect(x, y, 10, 40);
        g2d.setColor(colorPowerBar);
        int powerHeight = 39 * this.power / 255;
        g2d.fillRect(x + 1, y + 40 - powerHeight, 9, powerHeight);
        if (this.balanceError != null) {
            g2d.drawImage((Image)this.balanceImg, centerX - this.balanceImg.getWidth() / 2 + this.balanceError * 50 / 512, 105, this);
        }
        double angle = Math.toRadians(this.rotationAngle);
        g2d.rotate(angle, centerX, centerY);
        g2d.drawImage((Image)this.img, spanX, spanY, this);
        double delta = Math.toRadians(this.RCAngle * 10.0f) - angle;
        g2d.rotate(delta, centerX, centerY);
        g2d.drawImage((Image)this.markerRCImg, centerX - this.markerRCImg.getWidth() / 2, 0, this);
        angle += delta;
        delta = Math.toRadians(this.rotationAngle * 10.0f) - angle;
        g2d.rotate(delta, centerX, centerY);
        g2d.drawImage((Image)this.markerImg, centerX - this.markerImg.getWidth() / 2, 0, this);
        angle += delta;
        g2d.setStroke(debugVarStroke);
        for (DebugVar v : this.debugVars.values()) {
            float a = v.value * 3.834952E-4f;
            delta = (double)a - angle;
            g2d.rotate(delta, centerX, centerY);
            g2d.setColor(v.color);
            g2d.drawLine(centerX, 0, centerX, 20);
            angle += delta;
        }
        g2d.setTransform(oldTransform);
        if (this.isPaused) {
            g2d.drawImage((Image)this.pausedImg, 0, 10, this);
        }
    }

    public void setRotationAngle(float angle, float rc_angle) {
        this.rotationAngle = angle;
        this.RCAngle = rc_angle;
        float err = angle - rc_angle;
        this.avgFilter.addData(err);
        this.peakMeter.addData(err - this.avgFilter.res());
    }

    public final float getError() {
        return this.peakMeter.getMax() - this.peakMeter.getMin();
    }

    public void setPower(int power) {
        this.power = power;
    }

    public void setBalanceError(int error) {
        this.balanceError = error;
    }

    public void setFrameAngle(float frameAngle) {
        this.frameAngle = Float.valueOf(frameAngle);
    }

    public void setDebugVar(DebugVar v) {
        this.debugVars.put(v.id, v);
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }
}

