/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sbgc.service.SerialCommand;
import sbgc.ui.BodeRespDataView;
import sbgc.utils.FileUtil;

class AutoPIDDebugView
extends BodeRespDataView {
    @Override
    protected String getTitle() {
        return "Auto-PID debug";
    }

    @Override
    protected String getXLabel() {
        return "Frequency, Hz";
    }

    @Override
    protected String getYLabel() {
        return "dB, deg.";
    }

    @Override
    protected void parseFile() throws Exception {
        byte[] data = FileUtil.readBytes(AutoPIDDebugView.getFilePath(this.fileName));
        SerialCommand cmd = new SerialCommand(0, data);
        XYSeries gain_s = new XYSeries((Comparable)((Object)"P.Gain"));
        XYSeries phase_s = new XYSeries((Comparable)((Object)"P.Phase"));
        XYSeries ctrl_gain_s = new XYSeries((Comparable)((Object)"Ctrl.Gain"));
        XYSeries ctrl_phase_s = new XYSeries((Comparable)((Object)"Ctrl.Phase"));
        XYSeries sens_s = new XYSeries((Comparable)((Object)"Sensitivity"));
        XYSeries threshold_s = new XYSeries((Comparable)((Object)"Threshold"));
        int freq_num = cmd.readWordUnsigned();
        float best_cost = (float)cmd.readWord() * 0.1f;
        cmd.skipBytes(32 - cmd.getBytesRead());
        while (cmd.getBytesAvailable() > 0) {
            float freq = (float)cmd.readWordUnsigned() * 0.01f;
            float threshold = (float)cmd.readByte() * 0.1f;
            float gain = (float)cmd.readWord() * 0.01f;
            int phase = cmd.readByteSigned() * 2;
            float ctrl_gain = (float)cmd.readWord() * 0.01f;
            int ctrl_phase = cmd.readByteSigned() * 2;
            float sens = (float)cmd.readWord() * 0.01f;
            gain_s.add((double)freq, (double)gain);
            phase_s.add((double)freq, (double)phase);
            threshold_s.add((double)freq, (double)threshold);
            sens_s.add((double)freq, (double)sens);
            ctrl_gain_s.add((double)freq, (double)ctrl_gain);
            ctrl_phase_s.add((double)freq, (double)ctrl_phase);
        }
        XYSeriesCollection ds0 = new XYSeriesCollection();
        ds0.addSeries(gain_s);
        ds0.addSeries(sens_s);
        ds0.addSeries(ctrl_gain_s);
        ds0.addSeries(threshold_s);
        XYSeriesCollection ds1 = new XYSeriesCollection();
        ds1.addSeries(phase_s);
        ds1.addSeries(ctrl_phase_s);
        this.dataset = new XYDataset[]{ds0, ds1};
        this.fileInfo = String.format("Frequency slots: %d\nBest cost: %.2f\n", freq_num, Float.valueOf(best_cost));
    }
}

