/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sbgc.service.SerialCommand;
import sbgc.ui.DataPlotView;
import sbgc.utils.FileUtil;

class BodeRespDataView
extends DataPlotView {
    @Override
    protected String getTitle() {
        return "Bode System Response in logarithmic scale";
    }

    @Override
    protected String getXLabel() {
        return "Frequency, Hz";
    }

    @Override
    protected String getYLabel() {
        return "dB, deg.";
    }

    @Override
    protected void customizeChart() {
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis("");
        logarithmicAxis.setStrictValuesFlag(false);
        logarithmicAxis.setRange(2.0, 500.0);
        XYPlot plot = this.chart.getXYPlot();
        plot.setDomainAxis((ValueAxis)logarithmicAxis);
        NumberAxis gainAxis = new NumberAxis("dB");
        gainAxis.setRange(-100.0, 20.0);
        plot.setRangeAxis(0, (ValueAxis)gainAxis);
        plot.setRenderer(0, (XYItemRenderer)new StandardXYItemRenderer());
        NumberAxis phaseAxis = new NumberAxis(null);
        phaseAxis.setRange(-185.0, 185.0);
        phaseAxis.setTickUnit(new NumberTickUnit(30.0));
        plot.setRangeAxis(1, (ValueAxis)phaseAxis);
        plot.setRenderer(1, (XYItemRenderer)new StandardXYItemRenderer());
    }

    @Override
    protected void parseFile() throws Exception {
        byte[] data = FileUtil.readBytes(BodeRespDataView.getFilePath(this.fileName));
        SerialCommand cmd = new SerialCommand(0, data);
        XYSeries gain_s = new XYSeries((Comparable)((Object)"Gain"));
        XYSeries phase_s = new XYSeries((Comparable)((Object)"Phase"));
        int freq_num = cmd.readWordUnsigned();
        int fft_time = cmd.readWordUnsigned();
        float[] in_minMax = cmd.readFloatArr(2);
        float[] out_minMax = cmd.readFloatArr(2);
        cmd.skipBytes(32 - cmd.getBytesRead());
        while (cmd.getBytesAvailable() > 0) {
            float freq = (float)cmd.readWordUnsigned() * 0.01f;
            float gain = (float)cmd.readWord() * 0.01f;
            float phase = (float)cmd.readByteSigned() * 0.70866144f;
            gain_s.add((double)freq, (double)gain);
            phase_s.add((double)freq, (double)phase);
        }
        XYSeriesCollection ds0 = new XYSeriesCollection();
        ds0.addSeries(gain_s);
        XYSeriesCollection ds1 = new XYSeriesCollection();
        ds1.addSeries(phase_s);
        this.dataset = new XYDataset[]{ds0, ds1};
        this.fileInfo = String.format("FFT compute time: %d ms.\nNumber of points: %d\nInput range: (%.2f .. %.2f)\nOutput range: (%.2f .. %.2f)", fft_time, freq_num, Float.valueOf(in_minMax[0]), Float.valueOf(in_minMax[1]), Float.valueOf(out_minMax[0]), Float.valueOf(out_minMax[1]));
    }
}

