/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import sbgc.service.SerialCommand;
import sbgc.ui.DataPlotView;
import sbgc.utils.FileUtil;
import sbgc.utils.MathUtils;

class BodeTestDataView
extends DataPlotView {
    @Override
    protected String getTitle() {
        return "Bode Test data (In,Out vs Time)";
    }

    @Override
    protected String getXLabel() {
        return "Time, ms";
    }

    @Override
    protected String getYLabel() {
        return "Gyro units";
    }

    @Override
    protected void parseFile() throws Exception {
        byte[] data = FileUtil.readBytes(BodeTestDataView.getFilePath(this.fileName));
        SerialCommand cmd = new SerialCommand(0, data);
        XYSeries in_s = new XYSeries((Comparable)((Object)"In"));
        XYSeries out_s = new XYSeries((Comparable)((Object)"Out"));
        long time_us = 0L;
        float[] in_minMax = MathUtils.minMaxInit();
        float[] out_minMax = MathUtils.minMaxInit();
        while (cmd.getBytesAvailable() > 0) {
            int in = cmd.readWord();
            int out = cmd.readWord();
            in_s.add((double)(time_us += 1600L) / 1000.0, (double)in);
            out_s.add((double)time_us / 1000.0, (double)out);
            MathUtils.minMax(in_minMax, in);
            MathUtils.minMax(out_minMax, out);
        }
        XYSeriesCollection ds = new XYSeriesCollection();
        ds.addSeries(in_s);
        ds.addSeries(out_s);
        this.dataset = new XYDataset[]{ds};
        this.fileInfo = String.format("Test duration: %.2f s.\nInput range: (%.0f .. %.0f)\nOutput range: (%.0f .. %.0f)", Float.valueOf((float)time_us / 1000000.0f), Float.valueOf(in_minMax[0]), Float.valueOf(in_minMax[1]), Float.valueOf(out_minMax[0]), Float.valueOf(out_minMax[1]));
    }
}

