/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardParams;
import sbgc.object.CANDeviceScanInfo;
import sbgc.object.CANModule;
import sbgc.ui.SpravComboBoxModel;
import simplebgc_gui.SimpleBGC_GUIApp;

public class CANModuleIdPanel
extends JPanel {
    public final String UID;
    public JButton jButtonDelete;
    public JComboBox jComboBoxId;
    public JLabel jLabelConnected;
    public JLabel jLabelType;
    public JLabel jLabelUID;

    public CANModuleIdPanel(String UID, CANDeviceScanInfo deviceInfo, HashMap<String, CANDeviceScanInfo> deviceScanList) {
        this.UID = UID;
        this.initComponents();
        CANModule m = CANModule.getById(deviceInfo.id);
        CANDeviceScanInfo scanInfo = null;
        if (deviceScanList == null) {
            this.jButtonDelete.setEnabled(false);
            this.jComboBoxId.setEnabled(false);
            this.jLabelConnected.setText("?");
        } else {
            scanInfo = deviceScanList.get(UID);
            if (scanInfo != null) {
                deviceInfo.type = scanInfo.type;
                deviceInfo.hard_assign = scanInfo.hard_assign;
                this.jButtonDelete.setEnabled(false);
                this.jLabelConnected.setText("yes");
            } else {
                this.jLabelConnected.setText("no");
            }
            if (deviceInfo.hard_assign) {
                this.jComboBoxId.setEnabled(false);
            }
        }
        int type = 0;
        if (scanInfo != null) {
            type = scanInfo.type;
        } else if (m != null) {
            type = m.type;
        }
        this.jLabelUID.setText(UID);
        this.jComboBoxId.setModel(new SpravComboBoxModel(CANModule.getOptionsForType(type), deviceInfo.id));
        this.jLabelType.setText(type > 0 ? CANModule.getTypeName(type) : "?");
    }

    private void initComponents() {
        this.jLabelUID = new JLabel();
        this.jLabelType = new JLabel();
        this.jButtonDelete = new JButton();
        this.jComboBoxId = new JComboBox();
        this.jLabelConnected = new JLabel();
        this.setMaximumSize(new Dimension(7000, 40));
        this.setMinimumSize(new Dimension(700, 40));
        this.setName("Form");
        this.setPreferredSize(new Dimension(700, 40));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(CANModuleIdPanel.class);
        this.jLabelUID.setText(resourceMap.getString("jLabelUID.text", new Object[0]));
        this.jLabelUID.setName("jLabelUID");
        this.add((Component)this.jLabelUID, new AbsoluteConstraints(10, 10, 150, -1));
        this.jLabelType.setText(resourceMap.getString("jLabelType.text", new Object[0]));
        this.jLabelType.setName("jLabelType");
        this.add((Component)this.jLabelType, new AbsoluteConstraints(180, 10, 110, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(CANModuleIdPanel.class, this);
        this.jButtonDelete.setAction(actionMap.get("deleteElement"));
        this.jButtonDelete.setText(resourceMap.getString("jButtonDelete.text", new Object[0]));
        this.jButtonDelete.setName("jButtonDelete");
        this.add((Component)this.jButtonDelete, new AbsoluteConstraints(570, 10, -1, -1));
        this.jComboBoxId.setName("jComboBoxId");
        this.add((Component)this.jComboBoxId, new AbsoluteConstraints(360, 10, 200, -1));
        this.jLabelConnected.setHorizontalAlignment(0);
        this.jLabelConnected.setText(resourceMap.getString("jLabelConnected.text", new Object[0]));
        this.jLabelConnected.setName("jLabelConnected");
        this.add((Component)this.jLabelConnected, new AbsoluteConstraints(300, 10, 40, -1));
    }

    @Action
    public void deleteElement() {
        BoardParams params = BoardParams.getCurParams();
        if (params.CAN_device_id_map != null) {
            params.CAN_device_id_map.remove(this.UID);
            SimpleBGC_GUIApp.mainView.panelCAN.updateDeviceIdMap(params);
        }
    }
}

