/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import sbgc.ui.AutoPIDDebugView;
import sbgc.ui.BodeRespDataView;
import sbgc.ui.BodeTestDataView;
import sbgc.utils.Settings;
import simplebgc_gui.TabWindow;

public abstract class DataPlotView
extends JPanel {
    static final HashMap<Integer, Class> fileTypeClass = new HashMap();
    protected int fileType;
    protected int fileId;
    protected String fileName;
    protected JFreeChart chart;
    protected ChartPanel chartPanel;
    protected TabWindow tabWindow;
    protected XYDataset[] dataset;
    protected String fileInfo;
    private JPanel jPanelCont;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane;
    private JTextArea jTextAreaFileInfo;

    public DataPlotView() {
        this.initComponents();
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanelCont = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaFileInfo = new JTextArea();
        this.setName("Form");
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane.setDividerLocation(200);
        this.jSplitPane.setDividerSize(4);
        this.jSplitPane.setName("jSplitPane");
        this.jPanelCont.setName("jPanelCont");
        this.jPanelCont.setLayout(new BorderLayout());
        this.jSplitPane.setRightComponent(this.jPanelCont);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextAreaFileInfo.setColumns(20);
        this.jTextAreaFileInfo.setRows(5);
        this.jTextAreaFileInfo.setName("jTextAreaFileInfo");
        this.jScrollPane1.setViewportView(this.jTextAreaFileInfo);
        this.jSplitPane.setLeftComponent(this.jScrollPane1);
        this.add(this.jSplitPane);
    }

    public static DataPlotView create(int fileId, String fileName) throws Exception {
        File f = DataPlotView.getFilePath(fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("File not found: " + f.getPath());
        }
        int fileType = fileId >> 8 & 0xFF;
        Class c = fileTypeClass.get(fileType);
        if (c != null) {
            DataPlotView d = (DataPlotView)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            d.fileId = fileId;
            d.fileType = fileType;
            d.fileName = fileName;
            d.setName(fileName);
            d.initChart();
            return d;
        }
        throw new UnsupportedOperationException("Unsupported file type " + fileType);
    }

    public void showDialog() {
        Runnable onClose = new Runnable(){

            @Override
            public void run() {
                Settings.set("window." + DataPlotView.this.getName() + ".split", Integer.toString(DataPlotView.this.jSplitPane.getDividerLocation()));
            }
        };
        try {
            this.tabWindow = new TabWindow(this, this.getClass(), this.fileName + " - " + this.getTitle(), null, false, onClose);
            this.tabWindow.showDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update() throws Exception {
        this.parseFile();
        if (this.dataset != null) {
            XYPlot plot = this.chart.getXYPlot();
            for (int i = 0; i < this.dataset.length; ++i) {
                plot.setDataset(i, this.dataset[i]);
                plot.mapDatasetToRangeAxis(i, i);
            }
        }
        this.jTextAreaFileInfo.setText(this.fileInfo);
    }

    public boolean isActive() {
        return this.tabWindow != null && !this.tabWindow.isClosed();
    }

    public void close() {
        if (this.tabWindow != null && !this.tabWindow.isClosed()) {
            this.tabWindow.closeDialog(1);
        }
    }

    private void initChart() throws Exception {
        String splitPos = Settings.get("window." + this.getName() + ".split");
        if (splitPos != null) {
            this.jSplitPane.setDividerLocation(Integer.parseInt(splitPos));
        }
        this.chart = ChartFactory.createXYLineChart(null, (String)this.getXLabel(), (String)this.getYLabel(), null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true, true, true, false, true);
        this.chartPanel.setFillZoomRectangle(true);
        this.chartPanel.setMouseWheelEnabled(true);
        this.jPanelCont.add((Component)this.chartPanel, "Center");
        this.customizeChart();
        this.update();
    }

    public static File getFilePath(String fileName) throws Exception {
        String dir = Settings.getUserDir() + File.separatorChar + "files";
        return new File(dir + File.separatorChar + fileName);
    }

    protected abstract void parseFile() throws Exception;

    protected abstract String getTitle();

    protected String getXLabel() {
        return null;
    }

    protected String getYLabel() {
        return null;
    }

    protected void customizeChart() {
    }

    static {
        fileTypeClass.put(14, AutoPIDDebugView.class);
        fileTypeClass.put(15, BodeRespDataView.class);
        fileTypeClass.put(16, BodeTestDataView.class);
    }
}

