/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import sbgc.object.BoardParams;
import sbgc.ui.Expo;

public class ExpoCurvePanel
extends JPanel {
    private static final Color backgroundColor = new Color(85, 85, 85);
    private static final Color[] strokeColors = new Color[]{new Color(0, 153, 204), new Color(204, 153, 0), new Color(0, 170, 51)};
    private static final int strokeWidth = 2;
    Expo[] expo = new Expo[3];
    boolean multiCurve;

    public ExpoCurvePanel(int max_in, int max_out) {
        for (int i = 0; i < this.expo.length; ++i) {
            this.expo[i] = new Expo(max_in, max_out);
        }
        this.setVisible(true);
    }

    public void setRate(int idx, int rate) {
        this.expo[idx].setRate(rate);
        this.repaint();
    }

    public void setDeadband(int idx, int deadband) {
        this.expo[idx].setDeadband(deadband);
        this.repaint();
    }

    public void setMultiCurve(boolean state) {
        this.multiCurve = state;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x0 = this.getInsets().left;
        int y0 = this.getInsets().top;
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right - 1;
        int height = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 1;
        g2d.setPaint(backgroundColor);
        g2d.fillRect(x0, y0, width, height);
        for (int idx = 0; idx < 3; ++idx) {
            Expo e = this.expo[idx];
            if (e != null) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(strokeColors[idx]);
                int py_prev = y0 + height;
                for (int px = 0; px < width; ++px) {
                    int x = px * e.max_in / width;
                    int y = x < e.deadband ? 0 : (int)e.calculate((x - e.deadband) * e.max_in / (e.max_in - e.deadband));
                    int py = y0 + height - y * height / e.max_out;
                    g2d.drawLine(x0 + px, py_prev, x0 + px + 1, py);
                    py_prev = py;
                }
            }
            if (!this.multiCurve) break;
        }
        if (this.multiCurve) {
            for (int i = 0; i < 3; ++i) {
                g2d.setColor(strokeColors[i]);
                FontMetrics fm = g2d.getFontMetrics();
                g2d.drawString(BoardParams.AXIS_NAME[i], 5, (i + 1) * fm.getHeight());
            }
        }
    }
}

