/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;

public class JoystickFldPanel
extends JPanel {
    public static final String EVENT_POS_RESET = "pos_reset";
    public static final String EVENT_POS_UPDATE = "pos_update";
    public static final int BORDER_THICKNESS = 2;
    private static final int THUMB_DIAMETER = 50;
    private static final int THUMB_RADIUS = 25;
    private static final int LOCK_AXIS_MIN_OFFSET = 5;
    public static final Color THUMB_IDLE_COLOR = new Color(24452);
    public static final Color THUMB_MOVE_COLOR = new Color(39372);
    public static final Color ARROWS_COLOR = new Color(0x666666);
    public static final Color BORDER_COLOR = Color.BLACK;
    public static final Color BACKGROUND_COLOR = Color.GRAY;
    private static final int STATE_IDLE = 0;
    private static final int STATE_MOVING = 1;
    private static final int STATE_LOCK = 10;
    private static final int STATE_LOCK_X = 11;
    private static final int STATE_LOCK_Y = 12;
    private final int outputMax;
    private int panelWidth;
    private int panelWidth2;
    private int arrowRadius;
    int state;
    int offsetX;
    int offsetY;
    int lockStartX;
    int lockStartY;
    private boolean[] autoCenter = new boolean[2];
    private boolean lockX;
    private boolean lockY;
    private final Point thumbPos = new Point();
    protected SwingPropertyChangeSupport propertySupporter = new SwingPropertyChangeSupport(this);

    public JoystickFldPanel(int output_max) {
        this.outputMax = output_max;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JoystickFldPanel.this.offsetX = e.getX() - ((JoystickFldPanel)JoystickFldPanel.this).thumbPos.x;
                    JoystickFldPanel.this.offsetY = e.getY() - ((JoystickFldPanel)JoystickFldPanel.this).thumbPos.y;
                    if (JoystickFldPanel.this.offsetX * JoystickFldPanel.this.offsetX + JoystickFldPanel.this.offsetY * JoystickFldPanel.this.offsetY < 625) {
                        JoystickFldPanel.this.state = e.getClickCount() >= 2 ? 10 : 1;
                        JoystickFldPanel.this.lockStartX = ((JoystickFldPanel)JoystickFldPanel.this).thumbPos.x;
                        JoystickFldPanel.this.lockStartY = ((JoystickFldPanel)JoystickFldPanel.this).thumbPos.y;
                        JoystickFldPanel.this.updateThumbPos(e.getX(), e.getY());
                        JoystickFldPanel.this.repaintAndTriggerListeners();
                    } else if (e.getClickCount() >= 2) {
                        JoystickFldPanel.this.resetThumbPad();
                        JoystickFldPanel.this.propertySupporter.firePropertyChange(JoystickFldPanel.EVENT_POS_RESET, null, null);
                        JoystickFldPanel.this.repaintAndTriggerListeners();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && JoystickFldPanel.this.state >= 1) {
                    JoystickFldPanel.this.updateThumbPos(e.getX(), e.getY());
                    JoystickFldPanel.this.repaintAndTriggerListeners();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JoystickFldPanel.this.state = 0;
                    JoystickFldPanel.this.autoCenterThumbPad();
                    JoystickFldPanel.this.repaintAndTriggerListeners();
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void repaintAndTriggerListeners() {
        this.repaint();
        this.propertySupporter.firePropertyChange(EVENT_POS_UPDATE, null, this.getOutputPos());
    }

    private void setSize(int width) {
        if (this.panelWidth != width) {
            this.panelWidth = width;
            this.panelWidth2 = this.panelWidth / 2;
            this.arrowRadius = this.panelWidth / 24;
            this.resetThumbPad();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelWidth);
    }

    private void autoCenterThumbPad() {
        if (this.autoCenter[0]) {
            this.thumbPos.x = this.panelWidth2;
        }
        if (this.autoCenter[1]) {
            this.thumbPos.y = this.panelWidth2;
        }
    }

    private void resetThumbPad() {
        this.thumbPos.x = this.panelWidth2;
        this.thumbPos.y = this.panelWidth2;
    }

    private void updateThumbPos(int mouseX, int mouseY) {
        mouseY -= this.offsetY;
        if ((mouseX -= this.offsetX) < 25) {
            mouseX = 25;
        } else if (mouseX > this.panelWidth - 25) {
            mouseX = this.panelWidth - 25;
        }
        if (mouseY < 25) {
            mouseY = 25;
        } else if (mouseY > this.panelWidth - 25) {
            mouseY = this.panelWidth - 25;
        }
        this.thumbPos.x = mouseX;
        this.thumbPos.y = mouseY;
        if (this.state == 10) {
            int distX = Math.abs(this.thumbPos.x - this.lockStartX);
            int distY = Math.abs(this.thumbPos.y - this.lockStartY);
            if (distX > 5 || distY > 5) {
                if (distX > distY + 1) {
                    this.state = 12;
                } else if (distY > distX + 1) {
                    this.state = 11;
                }
            }
        }
        if (this.state == 11 || this.lockX) {
            this.thumbPos.x = this.lockStartX;
        }
        if (this.state == 12 || this.lockY) {
            this.thumbPos.y = this.lockStartY;
        }
    }

    Point getOutputPos() {
        Point result = new Point();
        result.x = this.outputMax * (this.thumbPos.x - this.panelWidth2) / (this.panelWidth2 - 25);
        result.y = -this.outputMax * (this.thumbPos.y - this.panelWidth2) / (this.panelWidth2 - 25);
        return result;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setSize(Math.min(this.getWidth(), this.getHeight()));
        g.setColor(BORDER_COLOR);
        g.fillOval(25, 25, this.panelWidth - 50, this.panelWidth - 50);
        g.setColor(BACKGROUND_COLOR);
        g.fillOval(27, 27, this.panelWidth - 50 - 4, this.panelWidth - 50 - 4);
        g.setColor(ARROWS_COLOR);
        int[] left_x = new int[]{50 - this.arrowRadius, 50 + this.arrowRadius, 50 + this.arrowRadius};
        int[] left_y = new int[]{this.panelWidth2, this.panelWidth2 + this.arrowRadius, this.panelWidth2 - this.arrowRadius};
        g.fillPolygon(left_x, left_y, 3);
        int[] right_x = new int[]{this.panelWidth - 50 + this.arrowRadius, this.panelWidth - 50 - this.arrowRadius, this.panelWidth - 50 - this.arrowRadius};
        int[] right_y = new int[]{this.panelWidth2, this.panelWidth2 + this.arrowRadius, this.panelWidth2 - this.arrowRadius};
        g.fillPolygon(right_x, right_y, 3);
        int[] up_x = left_y;
        int[] up_y = left_x;
        g.fillPolygon(up_x, up_y, 3);
        int[] down_x = right_y;
        int[] down_y = right_x;
        g.fillPolygon(down_x, down_y, 3);
        g.setColor(BORDER_COLOR);
        g.fillOval(this.thumbPos.x - 25 - 2, this.thumbPos.y - 25 - 2, 54, 54);
        g.setColor(this.state == 0 ? THUMB_IDLE_COLOR : THUMB_MOVE_COLOR);
        g.fillOval(this.thumbPos.x - 25, this.thumbPos.y - 25, 50, 50);
        g.setColor(BORDER_COLOR);
        if (this.state == 10 || this.state == 12) {
            g.drawLine(this.thumbPos.x - 25, this.thumbPos.y, this.thumbPos.x + 25, this.thumbPos.y);
        }
        if (this.state == 10 || this.state == 11) {
            g.drawLine(this.thumbPos.x, this.thumbPos.y - 25, this.thumbPos.x, this.thumbPos.y + 25);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupporter.addPropertyChangeListener(listener);
    }

    public void setAutoCenter(int xy, boolean value) {
        this.autoCenter[xy] = value;
        this.autoCenterThumbPad();
        this.repaintAndTriggerListeners();
    }

    public void setAxisLock(boolean lockX, boolean lockY) {
        this.lockX = lockX;
        this.lockY = lockY;
    }
}

