/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public class RCDataPanel
extends JPanel {
    private static final Color backgroundColor = new Color(68, 68, 68);
    private static final Color barColor = new Color(0, 85, 153);
    private static final Color barCapColor = new Color(0, 51, 102);
    private static final Color markerColor = new Color(255, 255, 255, 100);
    private static final Color labelColor = new Color(255, 255, 255, 150);
    private static final Color valueColor = new Color(255, 255, 255);
    private static final Font labelFont = new Font("Arial", 1, 11);
    private static final Color alertColor = new Color(255, 51, 0, 100);
    Float data = null;
    String label = null;
    ArrayList<Float> markers = new ArrayList();
    float min = 1000.0f;
    float max = 2000.0f;
    Float alert = null;
    String valueFormat = "%.0f";
    boolean autoScale = false;

    public RCDataPanel(String label) {
        this.setVisible(true);
        this.label = label;
    }

    public RCDataPanel(String label, String valueFormat) {
        this(label);
        this.valueFormat = valueFormat;
    }

    public RCDataPanel(String label, String valueFormat, float min, float max, boolean autoScale) {
        this(label, valueFormat);
        this.min = min;
        this.max = max;
        this.autoScale = autoScale;
    }

    public RCDataPanel(String label, int width, int height) {
        this(label);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int x0 = this.getInsets().left;
        int y0 = this.getInsets().top;
        int w = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        g2d.setPaint(backgroundColor);
        g2d.fillRect(x0, y0, w, h);
        if (this.data != null) {
            x = (int)((this.data.floatValue() - this.min) * (float)w / (this.max - this.min));
            g2d.setPaint(barColor);
            g2d.fillRect(x0, y0, x, h);
            g2d.setColor(barCapColor);
            g2d.fillRect(x0 + x, y0, 3, h);
        }
        if (this.alert != null) {
            x = (int)((this.alert.floatValue() - this.min) * (float)w / (this.max - this.min));
            g2d.setPaint(alertColor);
            g2d.fillRect(x0, y0, x, h);
        }
        for (Float marker : this.markers) {
            g2d.setPaint(markerColor);
            g2d.fillRect(x0 + (int)((marker.floatValue() - this.min) * (float)w / (this.max - this.min)), y0 + 3, 5, h - 6);
        }
        g2d.setFont(labelFont);
        FontMetrics fm = g2d.getFontMetrics();
        int labelY = y0 + (h - fm.getHeight()) / 2 + fm.getAscent();
        if (this.label != null) {
            g2d.setColor(labelColor);
            g2d.drawString(this.label, x0 + 10, labelY);
        }
        if (this.data != null) {
            g2d.setColor(valueColor);
            String dataStr = String.format(this.valueFormat, this.data);
            g2d.drawString(dataStr, x0 + w - fm.stringWidth(dataStr) - 10, labelY);
        }
    }

    public void setData(Integer data) {
        this.setData(data != null ? new Float(data.intValue()) : null);
    }

    public void setData(Float data) {
        this.data = data;
        if (this.autoScale) {
            this.updateAutoScale();
        }
        this.repaint();
    }

    public Float getData() {
        return this.data;
    }

    public void addMarker(Integer marker) {
        if (marker != null) {
            this.addMarker(new Float(marker.intValue()));
        }
    }

    public void addMarker(Float marker) {
        this.markers.add(marker);
        if (this.autoScale) {
            this.updateAutoScale();
        }
    }

    public void setMarker(int idx, float val) {
        if (idx < this.markers.size()) {
            this.markers.set(idx, Float.valueOf(val));
        }
        if (this.autoScale) {
            this.updateAutoScale();
        }
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public void setAlert(Float alert) {
        this.alert = alert;
    }

    public void updateAutoScale() {
        float new_min = this.min;
        float new_max = this.max;
        if (this.data != null) {
            new_max = Math.max(new_max, this.data.floatValue());
            new_min = Math.min(new_min, this.data.floatValue());
        }
        for (Float marker : this.markers) {
            if (marker.floatValue() > new_max) {
                new_max = marker.floatValue();
            }
            if (!(marker.floatValue() < new_min)) continue;
            new_min = marker.floatValue();
        }
        if (new_max > this.max) {
            this.max = new_max + (new_max - new_min) * 0.3f;
        }
        if (new_min < this.min) {
            this.min = new_min - (new_max - new_min) * 0.3f;
        }
    }

    public static void syncScale(RCDataPanel[] list) {
        float maxx = list[0].max;
        float minn = list[0].min;
        for (RCDataPanel p : list) {
            if (maxx < p.max) {
                maxx = p.max;
            }
            if (!(minn > p.min)) continue;
            minn = p.min;
        }
        for (RCDataPanel p : list) {
            if (p.max == maxx && p.min == minn) continue;
            p.max = maxx;
            p.min = minn;
            p.repaint();
        }
    }
}

