/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class SensorBarPanel
extends JPanel {
    private static final Color backgroundColor = new Color(70, 70, 70);
    private static final Color[] barColors = new Color[]{new Color(71, 142, 57), new Color(226, 179, 70), new Color(95, 160, 239)};
    private static final Color barWarnColor = new Color(255, 66, 66);
    private static final Color barPeakColor = new Color(255, 255, 0);
    private static final Font labelFont = new Font("Verdana", 1, 9);
    private static final Color labelColor = new Color(204, 204, 204);
    private static final int labelsAreaWidth = 15;
    private int max_val;
    private int min_val;
    private int range;
    private int padding;
    private boolean autoRange;
    private boolean drawPeak;
    private int width;
    private int height;
    private int x0;
    private int y0;
    private int[] data = null;
    private String[] labelTitle = null;
    private int[] labelVal = null;
    private int[] peakMin = new int[]{0, 0, 0};
    private int[] peakMax = new int[]{0, 0, 0};

    public SensorBarPanel(int min, int max, String minLabel, String maxLabel, boolean autoRange, boolean drawPeak) {
        this.autoRange = autoRange;
        this.drawPeak = drawPeak;
        this.labelVal = new int[]{min, 0, max};
        this.labelTitle = new String[]{minLabel, "0", maxLabel};
        this.setMinMax(min, max);
        this.setVisible(true);
    }

    private void setMinMax(int min, int max) {
        this.min_val = min;
        this.max_val = max;
        this.padding = (this.max_val - this.min_val) / 8;
        this.range = this.max_val - this.min_val + this.padding * 2;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.x0 = this.getInsets().left;
        this.y0 = this.getInsets().top;
        this.width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        this.height = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        g2d.setPaint(backgroundColor);
        g2d.fillRect(this.x0, this.y0, this.width, this.height);
        g2d.setFont(labelFont);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(labelColor);
        g2d.setPaint(labelColor);
        for (int i = 0; i < this.labelVal.length; ++i) {
            int y = this.valToScreenY(this.labelVal[i]);
            g2d.fillRect(this.x0 + 3, y, this.width - 15 - 6, 1);
            g2d.drawString(this.labelTitle[i], this.x0 + this.width - 15, y - fm.getHeight() / 2 + fm.getAscent());
        }
        if (this.data != null) {
            int barSpace = (this.width - 15) / this.data.length;
            int barWidth = barSpace / 2;
            int y_zero = this.valToScreenY(0);
            int y_min = this.valToScreenY(this.min_val);
            int y_max = this.valToScreenY(this.max_val);
            for (int i = 0; i < 3; ++i) {
                g2d.setPaint(barColors[i]);
                int x = this.x0 + barSpace * i + barSpace / 2 - barWidth / 2;
                int y = this.valToScreenY(this.data[i]);
                if (y > y_zero) {
                    g2d.fillRect(x, y_zero + 1, barWidth, y - y_zero);
                    if (y > y_min) {
                        g2d.setPaint(barWarnColor);
                        g2d.fillRect(x, y_min + 1, barWidth, y - y_min);
                    }
                } else {
                    g2d.fillRect(x, y, barWidth, y_zero - y);
                    if (y < y_max) {
                        g2d.setPaint(barWarnColor);
                        g2d.fillRect(x, y, barWidth, y_max - y);
                    }
                }
                if (!this.drawPeak) continue;
                g2d.setPaint(barPeakColor);
                if (this.peakMin[i] != 0) {
                    y = this.valToScreenY(this.peakMin[i]);
                    g2d.fillRect(x, y, barWidth, 1);
                }
                if (this.peakMax[i] == 0) continue;
                y = this.valToScreenY(this.peakMax[i]);
                g2d.fillRect(x, y, barWidth, 1);
            }
        }
    }

    public void drawBars(int[] data) {
        this.data = data;
        this.repaint();
        if (this.autoRange) {
            int max_val_new = this.max_val;
            int min_val_new = this.min_val;
            for (int i = 0; i < 3; ++i) {
                if (data[i] > this.max_val + this.padding) {
                    max_val_new = data[i];
                    continue;
                }
                if (data[i] >= this.min_val - this.padding) continue;
                min_val_new = data[i];
            }
            if (this.min_val != min_val_new || this.max_val != max_val_new) {
                this.setMinMax(min_val_new, max_val_new);
            }
        }
        if (this.drawPeak) {
            for (int i = 0; i < 3; ++i) {
                if (data[i] < this.peakMin[i]) {
                    this.peakMin[i] = data[i];
                }
                if (data[i] <= this.peakMax[i]) continue;
                this.peakMax[i] = data[i];
            }
        }
    }

    protected int valToScreenY(int val) {
        return this.y0 + this.height * (this.max_val + this.padding - val) / this.range;
    }
}

