/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.Complex;
import sbgc.bode_plot.ControllerOptimizer;
import sbgc.bode_plot.ControllerParams;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.ui.BodePlotJPanel;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.TabbedPanelBase;
import sbgc.utils.BGCJFileLoader;
import sbgc.utils.Settings;
import simplebgc_gui.DialogBodeTestRun;
import simplebgc_gui.DialogShowController;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;
import simplebgc_gui.TabWindow;

public class TabbedPanelAnalyze
extends TabbedPanelBase
implements ITabbedPanel {
    private static final String NAME_BODE_RESULT = "bodeResult";
    ControllerParams optimizedParams = null;
    BodePlotJPanel bodePlotJPanel = new BodePlotJPanel();
    private JPanel bodePlotJPanel_;
    private JPanel groupAnalyze;
    private JPanel groupOptimizer;
    private JButton jButtonAnalizeAddFromFile;
    private JButton jButtonAnalizeClear;
    private JButton jButtonAnalizeRun;
    private JButton jButtonHelp;
    private JButton jButtonNewWindow;
    private JButton jButtonOptimizerApply;
    private JButton jButtonOptimizerRun;
    private JButton jButtonShowController;
    private JCheckBoxMenuItem jCBMenuAutoScale;
    private JCheckBoxMenuItem jCBMenuGain;
    private JCheckBoxMenuItem jCBMenuPhase;
    private JCheckBoxMenuItem jCBMenuSensitivity;
    private JCheckBoxMenuItem jCBMenuSmooth;
    private JCheckBox jCheckBoxApplyAllProfiles;
    private JLabel jLabelOptimizerResult;
    private JPopupMenu jPopupMenuView;
    private JButton jToggleButtonMenuShow;

    public TabbedPanelAnalyze(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.bodePlotJPanel.setParent(this);
        this.bodePlotJPanel_.add(this.bodePlotJPanel);
        this.jCheckBoxApplyAllProfiles.setSelected(Settings.is("auto_pid.apply_all_profiles"));
        this.jCBMenuAutoScale.setSelected(true);
        this.jCBMenuSmooth.setSelected(true);
        this.jCBMenuGain.setSelected(true);
        this.jCBMenuPhase.setSelected(true);
        this.jCBMenuSensitivity.setSelected(true);
    }

    private void initComponents() {
        this.jPopupMenuView = new JPopupMenu();
        this.jCBMenuAutoScale = new JCheckBoxMenuItem();
        this.jCBMenuSmooth = new JCheckBoxMenuItem();
        this.jCBMenuGain = new JCheckBoxMenuItem();
        this.jCBMenuSensitivity = new JCheckBoxMenuItem();
        this.jCBMenuPhase = new JCheckBoxMenuItem();
        this.groupAnalyze = new JPanel();
        this.jButtonAnalizeAddFromFile = new JButton();
        this.jButtonAnalizeClear = new JButton();
        this.bodePlotJPanel_ = new JPanel();
        this.jButtonAnalizeRun = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonNewWindow = new JButton();
        this.jToggleButtonMenuShow = new JButton();
        this.jButtonShowController = new JButton();
        this.groupOptimizer = new JPanel();
        this.jButtonOptimizerRun = new JButton();
        this.jLabelOptimizerResult = new JLabel();
        this.jButtonOptimizerApply = new JButton();
        this.jCheckBoxApplyAllProfiles = new JCheckBox();
        this.jPopupMenuView.setName("jPopupMenuView");
        this.jPopupMenuView.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                TabbedPanelAnalyze.this.jPopupMenuViewPopupMenuCanceled(evt);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                TabbedPanelAnalyze.this.jPopupMenuViewPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelAnalyze.class);
        this.jCBMenuAutoScale.setText(resourceMap.getString("jCBMenuAutoScale.text", new Object[0]));
        this.jCBMenuAutoScale.setName("jCBMenuAutoScale");
        this.jCBMenuAutoScale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jCBMenuAutoScaleItemStateChanged(evt);
            }
        });
        this.jPopupMenuView.add(this.jCBMenuAutoScale);
        this.jCBMenuSmooth.setText(resourceMap.getString("jCBMenuSmooth.text", new Object[0]));
        this.jCBMenuSmooth.setName("jCBMenuSmooth");
        this.jCBMenuSmooth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jCBMenuSmoothItemStateChanged(evt);
            }
        });
        this.jPopupMenuView.add(this.jCBMenuSmooth);
        this.jCBMenuGain.setText(resourceMap.getString("jCBMenuGain.text", new Object[0]));
        this.jCBMenuGain.setName("jCBMenuGain");
        this.jCBMenuGain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jCBMenuGainItemStateChanged(evt);
            }
        });
        this.jPopupMenuView.add(this.jCBMenuGain);
        this.jCBMenuSensitivity.setText(resourceMap.getString("jCBMenuSensitivity.text", new Object[0]));
        this.jCBMenuSensitivity.setName("jCBMenuSensitivity");
        this.jCBMenuSensitivity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jCBMenuSensitivityItemStateChanged(evt);
            }
        });
        this.jPopupMenuView.add(this.jCBMenuSensitivity);
        this.jCBMenuPhase.setText(resourceMap.getString("jCBMenuPhase.text", new Object[0]));
        this.jCBMenuPhase.setName("jCBMenuPhase");
        this.jCBMenuPhase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jCBMenuPhaseItemStateChanged(evt);
            }
        });
        this.jPopupMenuView.add(this.jCBMenuPhase);
        this.setName("Analyze");
        this.setLayout(null);
        this.groupAnalyze.setName("groupAnalyze");
        this.jButtonAnalizeAddFromFile.setText(resourceMap.getString("jButtonAnalizeAddFromFile.text", new Object[0]));
        this.jButtonAnalizeAddFromFile.setName("jButtonAnalizeAddFromFile");
        this.jButtonAnalizeAddFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelAnalyze.this.jButtonAnalizeAddFromFileActionPerformed(evt);
            }
        });
        this.jButtonAnalizeClear.setText(resourceMap.getString("jButtonAnalizeClear.text", new Object[0]));
        this.jButtonAnalizeClear.setName("jButtonAnalizeClear");
        this.jButtonAnalizeClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelAnalyze.this.jButtonAnalizeClearActionPerformed(evt);
            }
        });
        this.bodePlotJPanel_.setBorder(BorderFactory.createEtchedBorder());
        this.bodePlotJPanel_.setName("bodePlotJPanel");
        this.bodePlotJPanel_.setPreferredSize(new Dimension(720, 340));
        this.bodePlotJPanel_.setLayout(new BoxLayout(this.bodePlotJPanel_, 2));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelAnalyze.class, this);
        this.jButtonAnalizeRun.setAction(actionMap.get("buttonBodeTestRun"));
        this.jButtonAnalizeRun.setText(resourceMap.getString("jButtonAnalizeRun.text", new Object[0]));
        this.jButtonAnalizeRun.setName("jButtonAnalizeRun");
        this.jButtonHelp.setAction(actionMap.get("buttonHelp"));
        this.jButtonHelp.setHorizontalTextPosition(0);
        this.jButtonHelp.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonHelp.setName("jButtonHelp");
        this.jButtonNewWindow.setAction(actionMap.get("buttonNewWindow"));
        this.jButtonNewWindow.setText(resourceMap.getString("jButtonNewWindow.text", new Object[0]));
        this.jButtonNewWindow.setToolTipText(resourceMap.getString("jButtonNewWindow.toolTipText", new Object[0]));
        this.jButtonNewWindow.setHorizontalTextPosition(0);
        this.jButtonNewWindow.setIconTextGap(0);
        this.jButtonNewWindow.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonNewWindow.setName("jButtonNewWindow");
        this.jToggleButtonMenuShow.setAction(actionMap.get("buttonShow"));
        this.jToggleButtonMenuShow.setText(resourceMap.getString("jToggleButtonMenuShow.text", new Object[0]));
        this.jToggleButtonMenuShow.setName("jToggleButtonMenuShow");
        this.jToggleButtonMenuShow.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelAnalyze.this.jToggleButtonMenuShowItemStateChanged(evt);
            }
        });
        this.jButtonShowController.setAction(actionMap.get("showController"));
        this.jButtonShowController.setText(resourceMap.getString("jButtonShowController.text", new Object[0]));
        this.jButtonShowController.setToolTipText(resourceMap.getString("jButtonShowController.toolTipText", new Object[0]));
        this.jButtonShowController.setName("jButtonShowController");
        GroupLayout groupAnalyzeLayout = new GroupLayout(this.groupAnalyze);
        this.groupAnalyze.setLayout(groupAnalyzeLayout);
        groupAnalyzeLayout.setHorizontalGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupAnalyzeLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonAnalizeRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalizeAddFromFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonShowController, -2, 130, -2).addGap(10, 10, 10).addComponent(this.jButtonAnalizeClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonMenuShow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 158, Short.MAX_VALUE).addComponent(this.jButtonNewWindow, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp, -2, 22, -2).addContainerGap()).addComponent(this.bodePlotJPanel_, -1, 710, Short.MAX_VALUE));
        groupAnalyzeLayout.setVerticalGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupAnalyzeLayout.createSequentialGroup().addContainerGap().addGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAnalizeAddFromFile, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonShowController)).addGroup(groupAnalyzeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAnalizeClear).addComponent(this.jToggleButtonMenuShow)).addComponent(this.jButtonAnalizeRun, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -2, 22, -2)).addComponent(this.jButtonNewWindow, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bodePlotJPanel_, -1, 325, Short.MAX_VALUE)));
        this.add(this.groupAnalyze);
        this.groupAnalyze.setBounds(0, 0, 710, 370);
        this.groupOptimizer.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupOptimizer.border.title", new Object[0])));
        this.groupOptimizer.setMaximumSize(new Dimension(Short.MAX_VALUE, 80));
        this.groupOptimizer.setName("groupOptimizer");
        this.jButtonOptimizerRun.setAction(actionMap.get("buttonOptimize"));
        this.jButtonOptimizerRun.setText(resourceMap.getString("jButtonOptimizerRun.text", new Object[0]));
        this.jButtonOptimizerRun.setToolTipText(resourceMap.getString("jButtonOptimizerRun.toolTipText", new Object[0]));
        this.jButtonOptimizerRun.setName("jButtonOptimizerRun");
        this.jLabelOptimizerResult.setText(resourceMap.getString("jLabelOptimizerResult.text", new Object[0]));
        this.jLabelOptimizerResult.setName("jLabelOptimizerResult");
        this.jButtonOptimizerApply.setAction(actionMap.get("buttonOptimizerApply"));
        this.jButtonOptimizerApply.setText(resourceMap.getString("jButtonOptimizerApply.text", new Object[0]));
        this.jButtonOptimizerApply.setToolTipText(resourceMap.getString("jButtonOptimizerApply.toolTipText", new Object[0]));
        this.jButtonOptimizerApply.setName("jButtonOptimizerApply");
        this.jCheckBoxApplyAllProfiles.setText(resourceMap.getString("jCheckBoxApplyAllProfiles.text", new Object[0]));
        this.jCheckBoxApplyAllProfiles.setName("jCheckBoxApplyAllProfiles");
        GroupLayout groupOptimizerLayout = new GroupLayout(this.groupOptimizer);
        this.groupOptimizer.setLayout(groupOptimizerLayout);
        groupOptimizerLayout.setHorizontalGroup(groupOptimizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupOptimizerLayout.createSequentialGroup().addContainerGap().addGroup(groupOptimizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelOptimizerResult, -1, 670, Short.MAX_VALUE).addGroup(groupOptimizerLayout.createSequentialGroup().addComponent(this.jButtonOptimizerRun).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonOptimizerApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxApplyAllProfiles))).addContainerGap()));
        groupOptimizerLayout.setVerticalGroup(groupOptimizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupOptimizerLayout.createSequentialGroup().addComponent(this.jLabelOptimizerResult, -1, 37, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupOptimizerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOptimizerRun).addComponent(this.jButtonOptimizerApply).addComponent(this.jCheckBoxApplyAllProfiles)).addGap(5, 5, 5)));
        this.add(this.groupOptimizer);
        this.groupOptimizer.setBounds(0, 370, 710, 100);
    }

    private void jButtonAnalizeAddFromFileActionPerformed(ActionEvent evt) {
        String[] files = new BGCJFileLoader(this.groupAnalyze, new String[]{"csv"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.csv", new Object[0]), "bode_test.last_used_dir", null, true).getFilesPath();
        if (files != null) {
            for (String file : files) {
                this.bodePlotAddFile(file);
            }
        }
    }

    private void jButtonAnalizeClearActionPerformed(ActionEvent evt) {
        this.bodePlotJPanel.clearPlot();
    }

    private void jCBMenuAutoScaleItemStateChanged(ItemEvent evt) {
        this.bodePlotJPanel.setIsAutoScaleSelected(this.jCBMenuAutoScale.isSelected());
        this.bodePlotJPanel.drawPlot();
    }

    private void jCBMenuSmoothItemStateChanged(ItemEvent evt) {
        this.bodePlotJPanel.setIsSmoothSelected(this.jCBMenuSmooth.isSelected());
        this.bodePlotJPanel.drawPlot();
    }

    private void jCBMenuGainItemStateChanged(ItemEvent evt) {
        this.bodePlotJPanel.setIsAmpShown(this.jCBMenuGain.isSelected());
        this.bodePlotJPanel.drawPlot();
    }

    private void jCBMenuSensitivityItemStateChanged(ItemEvent evt) {
        this.bodePlotJPanel.setIsSensitivityShown(this.jCBMenuSensitivity.isSelected());
        this.bodePlotJPanel.drawPlot();
    }

    private void jCBMenuPhaseItemStateChanged(ItemEvent evt) {
        this.bodePlotJPanel.setIsPhaseShown(this.jCBMenuPhase.isSelected());
        this.bodePlotJPanel.drawPlot();
    }

    private void jToggleButtonMenuShowItemStateChanged(ItemEvent evt) {
    }

    private void jPopupMenuViewPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.jToggleButtonMenuShow.setSelected(false);
    }

    private void jPopupMenuViewPopupMenuCanceled(PopupMenuEvent evt) {
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    @Override
    public void updateBoardVerUI() {
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    public void bodePlotAddFile(String filePath) {
        try {
            this.bodePlotJPanel.plotDataFromFile(filePath);
        }
        catch (Exception e) {
            this.mainView.showErrorMessage(e.toString());
            this.logger.stackTrace(e);
        }
    }

    @Action(enabledProperty="connected")
    public void buttonBodeTestRun() {
        DialogBodeTestRun dialogBodeTest = new DialogBodeTestRun(this.mainView.getFrame());
        if (!dialogBodeTest.isClosed()) {
            dialogBodeTest.showDialogNewThread();
        }
    }

    @Action
    public void buttonOptimize() {
        try {
            this.bodePlotJPanel.optimize();
        }
        catch (Exception e) {
            String msg = "Failed to start optimizer: " + e.toString();
            this.logger.error(msg, e);
            this.logger.stackTrace(e);
            this.mainView.showErrorMessage(msg);
        }
    }

    public void setOptimizedParams(ControllerParams p) {
        this.optimizedParams = p;
        this.jLabelOptimizerResult.setText("<html>" + BoardParams.getAxisName(this.optimizedParams.getAxis()) + ": " + this.optimizedParams.toParamsString().replaceAll("\n", "<br>") + "</html>");
        if (BoardParams.getCurProfile() != null) {
            this.jButtonOptimizerApply.setEnabled(true);
        }
    }

    @Action
    public void buttonOptimizerApply() {
        BoardParams params = BoardParams.getCurParams();
        if (params != null && this.optimizedParams != null) {
            boolean applyAllProfiles = this.jCheckBoxApplyAllProfiles.isSelected();
            if (SimpleBGC_GUIApp.mainView.showConfirmDialog(this.resourceMap.getString("confirm.apply_optimized_params", new Object[0]))) {
                int axis = this.optimizedParams.getAxis();
                for (BoardProfile p : params.profiles) {
                    if (!applyAllProfiles && p != BoardParams.getCurProfile()) continue;
                    if (this.optimizedParams.isGainOnly()) {
                        p.setPIDGain(axis, this.optimizedParams.getExtraGain());
                        continue;
                    }
                    float[] pids = this.optimizedParams.toParamsRange();
                    p.P_f[axis] = pids[0];
                    p.I_f[axis] = pids[1];
                    p.D_f[axis] = pids[2];
                    p.setPIDGain(axis, pids[3]);
                    p.d_lpfFreq[axis] = Math.round(this.optimizedParams.getDLpfFreq());
                    p.lpfFreq[axis] = Math.round(this.optimizedParams.getLpfFreq());
                    p.lpfEnabled[axis] = p.lpfFreq[axis] > 0;
                    p.set_LPF_Q_inv(axis, this.optimizedParams.getLpfQInv());
                    for (int idx = 0; idx < 3; ++idx) {
                        if (this.optimizedParams.getNotchGain(idx) != 0.0f) {
                            p.setNotchEnabled(axis, idx, true);
                            p.setNotchFreq(axis, idx, Math.round(this.optimizedParams.getNotchFreq(idx)));
                            p.setNotchWidth(axis, idx, Math.round(this.optimizedParams.getNotchWidth(idx)));
                            p.setNotchGain(axis, idx, Math.round(this.optimizedParams.getNotchGain(idx)));
                            continue;
                        }
                        p.setNotchEnabled(axis, idx, false);
                    }
                }
                SimpleBGC_GUIApp.mainView.updateBoardParams();
                SimpleBGC_GUIApp.mainView.updateStatus(this.resourceMap.getString("status.optimized_params_applied", new Object[0]));
                if (applyAllProfiles) {
                    this.mainView.writeParams(true);
                }
                Settings.set("auto_pid.apply_all_profiles", applyAllProfiles);
            }
        }
    }

    @Action
    public void buttonHelp() {
        JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("info.panel_analyze_help", new Object[0]), this.resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
    }

    @Action
    public void buttonNewWindow() {
        this.jButtonNewWindow.setVisible(false);
        try {
            new TabWindow(this, this.getClass(), this.getTitle(), null, true, new Runnable(){

                @Override
                public void run() {
                    TabbedPanelAnalyze.this.jButtonNewWindow.setVisible(true);
                }
            }).showDialog();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    @Action
    public void showController() {
        try {
            DialogShowController dialog = new DialogShowController((Frame)this.mainView.getFrame(), true, this.bodePlotJPanel.getBodeDataList());
            if (dialog.showDialog() == 1) {
                BoardParams params = BoardParams.getCurParams().clone();
                if (!this.mainView.applyBoardParams(params)) {
                    return;
                }
                BoardProfile p = params.profiles[params.curProfile];
                if (p == null) {
                    throw new Exception("PID parameters are not defined.");
                }
                BodeResult b = new BodeResult();
                b.startFreq = 1.0f;
                b.endFreq = 600.0f;
                ControllerParams cp = new ControllerParams(BoardInfo.getPIDControllerVer(), dialog.getAxis(), b.endFreq);
                cp.fillFromProfile(p, true);
                float[] freqLUT = new float[512];
                Complex[] timeDelayLUT = new Complex[freqLUT.length];
                ControllerOptimizer.fillFreqLUT(b.startFreq, b.endFreq, freqLUT, timeDelayLUT);
                Complex[] C_notch = ControllerOptimizer.getControllerResp(cp, freqLUT, timeDelayLUT);
                b.setName("C_" + BoardParams.getAxisName(cp.axis));
                ControllerParams cp_no_notch = new ControllerParams(BoardInfo.getPIDControllerVer(), dialog.getAxis(), b.endFreq);
                cp_no_notch.fillFromProfile(p, false);
                Complex[] C_no_notch = ControllerOptimizer.getControllerResp(cp_no_notch, freqLUT, timeDelayLUT);
                if (dialog.isShowController()) {
                    Complex[] C = ControllerOptimizer.getControllerResp(cp, freqLUT, null);
                    b.setResponse(BodeResult.getResponseAtFreq(C, freqLUT));
                    b.system = 3;
                    this.bodePlotJPanel.addBodeResult(b);
                }
                for (BodeResult bp : dialog.getSelectedResponse()) {
                    this.logger.debug("Applying controller to plant '" + bp.toString() + "'..");
                    Complex[] GC = ControllerOptimizer.applyController(ControllerOptimizer.responseToLogScaleConversion(bp.getResponse(), freqLUT), (bp.system & 0x40) == 0 ? C_no_notch : C_notch, cp.getExtraGain());
                    BodeResult bc = bp.clone();
                    bc.setResponse(BodeResult.getResponseAtFreq(GC, freqLUT));
                    bc.setName(bp.getName() + "+" + b.getName());
                    bc.system = 7;
                    this.bodePlotJPanel.addBodeResult(bc);
                }
                this.bodePlotJPanel.drawPlot();
            }
        }
        catch (Exception e) {
            this.mainView.showErrorMessage(e.toString());
        }
    }

    public void onBodeResultAdd(final BodeResult br) {
        boolean separatorFound = false;
        for (Component c : this.jPopupMenuView.getComponents()) {
            if (!(c instanceof JPopupMenu.Separator)) continue;
            separatorFound = true;
            break;
        }
        if (!separatorFound) {
            this.jPopupMenuView.addSeparator();
        }
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(br.getName());
        item.setSelected(true);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                br.setVisible(((JCheckBoxMenuItem)evt.getItem()).isSelected());
                TabbedPanelAnalyze.this.bodePlotJPanel.drawPlot();
            }
        });
        item.setName(NAME_BODE_RESULT);
        this.jPopupMenuView.add(item);
    }

    public void onBodeResultClear() {
        for (Component c : this.jPopupMenuView.getComponents()) {
            if (!(c instanceof JCheckBoxMenuItem) || !c.getName().equals(NAME_BODE_RESULT)) continue;
            this.jPopupMenuView.remove(c);
        }
    }

    @Action
    public void buttonShow() {
        this.jPopupMenuView.show(this.jToggleButtonMenuShow, this.jToggleButtonMenuShow.getWidth(), 0);
        this.jToggleButtonMenuShow.setSelected(true);
    }
}

