/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.object.ExtMotorParams;
import sbgc.object.IExtMotorParams;
import sbgc.object.ReactionParams;
import sbgc.object.Sprav;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.LogSpinnerModel;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class TabbedPanelExtraMotors
extends TabbedPanelBase
implements ITabbedPanel {
    int reaction_cur_axis = 0;
    boolean updateControlsMode = true;
    ReactionParams[] reaction_params_tmp = new ReactionParams[3];
    int ext_mot_cur_idx = 0;
    ExtMotorParams[] ext_motor_params_tmp = new ExtMotorParams[7];
    private JPanel groupExtMotors;
    private JPanel groupMotor4HW;
    private JPanel groupMotor4SW;
    private JPanel groupReaction;
    private JComboBox jCBExtMotCtrlType;
    private JComboBox jCBExtMotDriver;
    private JComboBox jCBExtMotId;
    private JCheckBox jCBExtMotInverted;
    private JComboBox jCBExtMotRCSrc;
    private JComboBox jCBReactionAxis;
    private JComboBox jCBReactionDriver;
    private JCheckBox jCBReactionInverted;
    private JCheckBox jCheckBoxMotor4Inverted;
    private JComboBox jComboBoxMotor4Axis;
    private JComboBox jComboBoxMotor4Output;
    private JLabel jLabel1;
    private JLabel jLabelExtMorScale;
    private JLabel jLabelExtMotCtrlType;
    private JLabel jLabelExtMotDriver;
    private JLabel jLabelExtMotId;
    private JLabel jLabelExtMotRCSource;
    private JLabel jLabelMotor4Axis;
    private JLabel jLabelMotor4LPFCutOff;
    private JLabel jLabelMotor4LimitsWeight;
    private JLabel jLabelMotor4LimitsWidth;
    private JLabel jLabelMotor4Output;
    private JLabel jLabelMotor4PIDD;
    private JLabel jLabelMotor4PIDI;
    private JLabel jLabelMotor4PIDP;
    private JLabel jLabelMotor4Servo;
    private JLabel jLabelMotor4ServoNeutral;
    private JLabel jLabelMotor4ServoP;
    private JLabel jLabelMotor4ServoRange;
    private JLabel jLabelMotor4SpeedScale;
    private JLabel jLabelReactionAxis;
    private JLabel jLabelReactionBrake;
    private JLabel jLabelReactionDriver;
    private JLabel jLabelReactionHPF;
    private JSpinner jSpinnerExtMotRCScale;
    private JSpinner jSpinnerMotor4LPFFreq;
    private JSpinner jSpinnerMotor4LimitsWeight;
    private JSpinner jSpinnerMotor4LimitsWidth;
    private JSpinner jSpinnerMotor4PidD;
    private JSpinner jSpinnerMotor4PidI;
    private JSpinner jSpinnerMotor4PidP;
    private JSpinner jSpinnerMotor4ServoNeutral;
    private JSpinner jSpinnerMotor4ServoP;
    private JSpinner jSpinnerMotor4ServoRange;
    private JSpinner jSpinnerMotor4SpeedScale;
    private JSpinner jSpinnerReactionBrake;
    private JSpinner jSpinnerReactionHPF;

    public TabbedPanelExtraMotors(SimpleBGC_GUIView mainView) {
        super(mainView);
        int i;
        this.initComponents();
        this.prepareLayout();
        for (i = 0; i < this.ext_motor_params_tmp.length; ++i) {
            this.ext_motor_params_tmp[i] = new ExtMotorParams(i + 1);
            this.jCBExtMotId.addItem("#" + (i + 1));
        }
        this.jCBReactionDriver.addItem(this.resourceMap.getString("option.disabled", new Object[0]));
        this.jCBExtMotDriver.addItem(this.resourceMap.getString("option.disabled", new Object[0]));
        for (i = 0; i < 7; ++i) {
            this.jCBReactionDriver.addItem("CAN_Drv#" + (i + 1));
            this.jCBExtMotDriver.addItem("CAN_Drv#" + (i + 1));
        }
        LogSpinnerModel.setModelAndEditor(this.jSpinnerReactionBrake, 1.0, 1000.0, 255, 1.0);
        LogSpinnerModel.setModelAndEditor(this.jSpinnerReactionHPF, 0.1, 100.0, 255, 0.1);
        LogSpinnerModel.setModelAndEditor(this.jSpinnerExtMotRCScale, 0.01f, 100.0, 254, 0.0);
        this.updateControlsMode = false;
    }

    private void initComponents() {
        this.groupMotor4HW = new JPanel();
        this.jLabelMotor4Output = new JLabel();
        this.jComboBoxMotor4Output = new JComboBox();
        this.jLabelMotor4ServoNeutral = new JLabel();
        this.jLabelMotor4ServoRange = new JLabel();
        this.jSpinnerMotor4ServoNeutral = new JSpinner();
        this.jSpinnerMotor4ServoRange = new JSpinner();
        this.jLabelMotor4SpeedScale = new JLabel();
        this.jSpinnerMotor4SpeedScale = new JSpinner();
        this.jLabelMotor4Axis = new JLabel();
        this.jComboBoxMotor4Axis = new JComboBox();
        this.jCheckBoxMotor4Inverted = new JCheckBox();
        this.jLabelMotor4Servo = new JLabel();
        this.jLabelMotor4ServoP = new JLabel();
        this.jSpinnerMotor4ServoP = new JSpinner();
        this.groupMotor4SW = new JPanel();
        this.jLabelMotor4LimitsWidth = new JLabel();
        this.jLabelMotor4PIDP = new JLabel();
        this.jSpinnerMotor4PidD = new JSpinner();
        this.jLabelMotor4PIDI = new JLabel();
        this.jSpinnerMotor4PidP = new JSpinner();
        this.jSpinnerMotor4PidI = new JSpinner();
        this.jLabelMotor4PIDD = new JLabel();
        this.jLabelMotor4LPFCutOff = new JLabel();
        this.jSpinnerMotor4LPFFreq = new JSpinner();
        this.jLabelMotor4LimitsWeight = new JLabel();
        this.jSpinnerMotor4LimitsWidth = new JSpinner();
        this.jSpinnerMotor4LimitsWeight = new JSpinner();
        this.groupReaction = new JPanel();
        this.jCBReactionAxis = new JComboBox();
        this.jLabelReactionAxis = new JLabel();
        this.jLabelReactionDriver = new JLabel();
        this.jCBReactionDriver = new JComboBox();
        this.jCBReactionInverted = new JCheckBox();
        this.jLabelReactionHPF = new JLabel();
        this.jSpinnerReactionHPF = new JSpinner();
        this.jLabelReactionBrake = new JLabel();
        this.jSpinnerReactionBrake = new JSpinner();
        this.groupExtMotors = new JPanel();
        this.jLabelExtMotId = new JLabel();
        this.jCBExtMotId = new JComboBox();
        this.jLabelExtMotDriver = new JLabel();
        this.jCBExtMotDriver = new JComboBox();
        this.jCBExtMotInverted = new JCheckBox();
        this.jLabelExtMotCtrlType = new JLabel();
        this.jCBExtMotCtrlType = new JComboBox();
        this.jLabelExtMotRCSource = new JLabel();
        this.jCBExtMotRCSrc = new JComboBox();
        this.jSpinnerExtMotRCScale = new JSpinner();
        this.jLabelExtMorScale = new JLabel();
        this.jLabel1 = new JLabel();
        this.setName("ExtraMotors");
        this.setLayout(null);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelExtraMotors.class);
        this.groupMotor4HW.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupMotor4HW.border.title", new Object[0])));
        this.groupMotor4HW.setName("groupMotor4HW");
        this.groupMotor4HW.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelMotor4Output.setText(resourceMap.getString("jLabelMotor4Output.text", new Object[0]));
        this.jLabelMotor4Output.setName("jLabelMotor4Output");
        this.groupMotor4HW.add((Component)this.jLabelMotor4Output, new AbsoluteConstraints(20, 60, -1, -1));
        this.jComboBoxMotor4Output.setToolTipText(resourceMap.getString("jComboBoxMotor4Output.toolTipText", new Object[0]));
        this.jComboBoxMotor4Output.setName("jComboBoxMotor4Output");
        this.groupMotor4HW.add((Component)this.jComboBoxMotor4Output, new AbsoluteConstraints(140, 60, 180, -1));
        this.jLabelMotor4ServoNeutral.setText(resourceMap.getString("jLabelMotor4ServoNeutral.text", new Object[0]));
        this.jLabelMotor4ServoNeutral.setName("jLabelMotor4ServoNeutral");
        this.groupMotor4HW.add((Component)this.jLabelMotor4ServoNeutral, new AbsoluteConstraints(40, 140, -1, -1));
        this.jLabelMotor4ServoRange.setText(resourceMap.getString("jLabelMotor4ServoRange.text", new Object[0]));
        this.jLabelMotor4ServoRange.setName("jLabelMotor4ServoRange");
        this.groupMotor4HW.add((Component)this.jLabelMotor4ServoRange, new AbsoluteConstraints(40, 170, -1, -1));
        this.jSpinnerMotor4ServoNeutral.setModel(new SpinnerNumberModel(1500, 0, 65535, 1));
        this.jSpinnerMotor4ServoNeutral.setToolTipText(resourceMap.getString("jSpinnerMotor4ServoNeutral.toolTipText", new Object[0]));
        this.jSpinnerMotor4ServoNeutral.setName("jSpinnerMotor4ServoNeutral");
        this.groupMotor4HW.add((Component)this.jSpinnerMotor4ServoNeutral, new AbsoluteConstraints(250, 140, 70, -1));
        this.jSpinnerMotor4ServoRange.setModel(new SpinnerNumberModel(0, 0, 2550, 10));
        this.jSpinnerMotor4ServoRange.setToolTipText(resourceMap.getString("jSpinnerMotor4ServoRange.toolTipText", new Object[0]));
        this.jSpinnerMotor4ServoRange.setName("jSpinnerMotor4ServoRange");
        this.groupMotor4HW.add((Component)this.jSpinnerMotor4ServoRange, new AbsoluteConstraints(250, 170, 70, -1));
        this.jLabelMotor4SpeedScale.setText(resourceMap.getString("jLabelMotor4SpeedScale.text", new Object[0]));
        this.jLabelMotor4SpeedScale.setName("jLabelMotor4SpeedScale");
        this.groupMotor4HW.add((Component)this.jLabelMotor4SpeedScale, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerMotor4SpeedScale.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(655.35f), Float.valueOf(0.1f)));
        this.jSpinnerMotor4SpeedScale.setToolTipText(resourceMap.getString("jSpinnerMotor4SpeedScale.toolTipText", new Object[0]));
        this.jSpinnerMotor4SpeedScale.setName("jSpinnerMotor4SpeedScale");
        this.groupMotor4HW.add((Component)this.jSpinnerMotor4SpeedScale, new AbsoluteConstraints(250, 90, 70, -1));
        this.jLabelMotor4Axis.setText(resourceMap.getString("jLabelMotor4Axis.text", new Object[0]));
        this.jLabelMotor4Axis.setName("jLabelMotor4Axis");
        this.groupMotor4HW.add((Component)this.jLabelMotor4Axis, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxMotor4Axis.setModel(new DefaultComboBoxModel<String>(new String[]{"Disabled", "X (PITCH)", "Y (ROLL)", "Z (YAW)"}));
        this.jComboBoxMotor4Axis.setToolTipText(resourceMap.getString("jComboBoxMotor4Axis.toolTipText", new Object[0]));
        this.jComboBoxMotor4Axis.setName("jComboBoxMotor4Axis");
        this.groupMotor4HW.add((Component)this.jComboBoxMotor4Axis, new AbsoluteConstraints(140, 30, 90, -1));
        this.jCheckBoxMotor4Inverted.setText(resourceMap.getString("jCheckBoxMotor4Inverted.text", new Object[0]));
        this.jCheckBoxMotor4Inverted.setToolTipText(resourceMap.getString("jCheckBoxMotor4Inverted.toolTipText", new Object[0]));
        this.jCheckBoxMotor4Inverted.setName("jCheckBoxMotor4Inverted");
        this.groupMotor4HW.add((Component)this.jCheckBoxMotor4Inverted, new AbsoluteConstraints(240, 30, -1, -1));
        this.jLabelMotor4Servo.setText(resourceMap.getString("jLabelMotor4Servo.text", new Object[0]));
        this.jLabelMotor4Servo.setName("jLabelMotor4Servo");
        this.groupMotor4HW.add((Component)this.jLabelMotor4Servo, new AbsoluteConstraints(20, 120, -1, -1));
        this.jLabelMotor4ServoP.setText(resourceMap.getString("jLabelMotor4ServoP.text", new Object[0]));
        this.jLabelMotor4ServoP.setToolTipText(resourceMap.getString("jSpinnerMotor4ServoP.toolTipText", new Object[0]));
        this.jLabelMotor4ServoP.setName("jLabelMotor4ServoP");
        this.groupMotor4HW.add((Component)this.jLabelMotor4ServoP, new AbsoluteConstraints(40, 200, -1, -1));
        this.jSpinnerMotor4ServoP.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerMotor4ServoP.setToolTipText(resourceMap.getString("jSpinnerMotor4ServoP.toolTipText", new Object[0]));
        this.jSpinnerMotor4ServoP.setName("jSpinnerMotor4ServoP");
        this.groupMotor4HW.add((Component)this.jSpinnerMotor4ServoP, new AbsoluteConstraints(250, 200, 70, -1));
        this.add(this.groupMotor4HW);
        this.groupMotor4HW.setBounds(0, 0, 350, 260);
        this.groupMotor4SW.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupMotor4SW.border.border.title", new Object[0]))));
        this.groupMotor4SW.setName("groupMotor4SW");
        this.groupMotor4SW.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelMotor4LimitsWidth.setText(resourceMap.getString("jLabelMotor4LimitsWidth.text", new Object[0]));
        this.jLabelMotor4LimitsWidth.setToolTipText(resourceMap.getString("jSpinnerMotor4LimitsWidth.toolTipText", new Object[0]));
        this.jLabelMotor4LimitsWidth.setName("jLabelMotor4LimitsWidth");
        this.groupMotor4SW.add((Component)this.jLabelMotor4LimitsWidth, new AbsoluteConstraints(20, 30, -1, -1));
        this.jLabelMotor4PIDP.setText(resourceMap.getString("jLabelMotor4PIDP.text", new Object[0]));
        this.jLabelMotor4PIDP.setName("jLabelMotor4PIDP");
        this.groupMotor4SW.add((Component)this.jLabelMotor4PIDP, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerMotor4PidD.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(655.35f), Float.valueOf(0.01f)));
        this.jSpinnerMotor4PidD.setToolTipText(resourceMap.getString("jSpinnerMotor4PidD.toolTipText", new Object[0]));
        this.jSpinnerMotor4PidD.setName("jSpinnerMotor4PidD");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4PidD, new AbsoluteConstraints(260, 90, 70, -1));
        this.jLabelMotor4PIDI.setText(resourceMap.getString("jLabelMotor4PIDI.text", new Object[0]));
        this.jLabelMotor4PIDI.setName("jLabelMotor4PIDI");
        this.groupMotor4SW.add((Component)this.jLabelMotor4PIDI, new AbsoluteConstraints(130, 90, -1, -1));
        this.jSpinnerMotor4PidP.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(655.35f), Float.valueOf(0.01f)));
        this.jSpinnerMotor4PidP.setToolTipText(resourceMap.getString("jSpinnerMotor4PidP.toolTipText", new Object[0]));
        this.jSpinnerMotor4PidP.setName("jSpinnerMotor4PidP");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4PidP, new AbsoluteConstraints(40, 90, 70, -1));
        this.jSpinnerMotor4PidI.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(655.35f), Float.valueOf(0.01f)));
        this.jSpinnerMotor4PidI.setToolTipText(resourceMap.getString("jSpinnerMotor4PidI.toolTipText", new Object[0]));
        this.jSpinnerMotor4PidI.setName("jSpinnerMotor4PidI");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4PidI, new AbsoluteConstraints(150, 90, 70, -1));
        this.jLabelMotor4PIDD.setText(resourceMap.getString("jLabelMotor4PIDD.text", new Object[0]));
        this.jLabelMotor4PIDD.setName("jLabelMotor4PIDD");
        this.groupMotor4SW.add((Component)this.jLabelMotor4PIDD, new AbsoluteConstraints(240, 90, -1, -1));
        this.jLabelMotor4LPFCutOff.setText(resourceMap.getString("jLabelMotor4LPFCutOff.text", new Object[0]));
        this.jLabelMotor4LPFCutOff.setName("jLabelMotor4LPFCutOff");
        this.groupMotor4SW.add((Component)this.jLabelMotor4LPFCutOff, new AbsoluteConstraints(20, 130, -1, -1));
        this.jSpinnerMotor4LPFFreq.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerMotor4LPFFreq.setToolTipText(resourceMap.getString("jSpinnerMotor4LPFFreq.toolTipText", new Object[0]));
        this.jSpinnerMotor4LPFFreq.setName("jSpinnerMotor4LPFFreq");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4LPFFreq, new AbsoluteConstraints(270, 130, 60, -1));
        this.jLabelMotor4LimitsWeight.setText(resourceMap.getString("jLabelMotor4LimitsWeight.text", new Object[0]));
        this.jLabelMotor4LimitsWeight.setToolTipText(resourceMap.getString("jSpinnerMotor4LimitsWeight.toolTipText", new Object[0]));
        this.jLabelMotor4LimitsWeight.setName("jLabelMotor4LimitsWeight");
        this.groupMotor4SW.add((Component)this.jLabelMotor4LimitsWeight, new AbsoluteConstraints(20, 60, -1, -1));
        this.jSpinnerMotor4LimitsWidth.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.jSpinnerMotor4LimitsWidth.setToolTipText(resourceMap.getString("jSpinnerMotor4LimitsWidth.toolTipText", new Object[0]));
        this.jSpinnerMotor4LimitsWidth.setName("jSpinnerMotor4LimitsWidth");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4LimitsWidth, new AbsoluteConstraints(270, 30, 60, -1));
        this.jSpinnerMotor4LimitsWeight.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerMotor4LimitsWeight.setToolTipText(resourceMap.getString("jSpinnerMotor4LimitsWeight.toolTipText", new Object[0]));
        this.jSpinnerMotor4LimitsWeight.setName("jSpinnerMotor4LimitsWeight");
        this.groupMotor4SW.add((Component)this.jSpinnerMotor4LimitsWeight, new AbsoluteConstraints(270, 60, 60, -1));
        this.add(this.groupMotor4SW);
        this.groupMotor4SW.setBounds(350, 0, 350, 170);
        this.groupReaction.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupReaction.border.title", new Object[0])));
        this.groupReaction.setName("groupReaction");
        this.groupReaction.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCBReactionAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"X (PITCH)", "Y (ROLL)", "Z (YAW)"}));
        this.jCBReactionAxis.setToolTipText(resourceMap.getString("jCBReactionAxis.toolTipText", new Object[0]));
        this.jCBReactionAxis.setName("jCBReactionAxis");
        this.jCBReactionAxis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelExtraMotors.this.jCBReactionAxisItemStateChanged(evt);
            }
        });
        this.groupReaction.add((Component)this.jCBReactionAxis, new AbsoluteConstraints(250, 30, 110, -1));
        this.jLabelReactionAxis.setText(resourceMap.getString("jLabelReactionAxis.text", new Object[0]));
        this.jLabelReactionAxis.setName("jLabelReactionAxis");
        this.groupReaction.add((Component)this.jLabelReactionAxis, new AbsoluteConstraints(20, 30, 220, -1));
        this.jLabelReactionDriver.setText(resourceMap.getString("jLabelReactionDriver.text", new Object[0]));
        this.jLabelReactionDriver.setName("jLabelReactionDriver");
        this.groupReaction.add((Component)this.jLabelReactionDriver, new AbsoluteConstraints(20, 60, 220, -1));
        this.jCBReactionDriver.setToolTipText(resourceMap.getString("jCBReactionDriver.toolTipText", new Object[0]));
        this.jCBReactionDriver.setName("jCBReactionDriver");
        this.groupReaction.add((Component)this.jCBReactionDriver, new AbsoluteConstraints(250, 60, 170, -1));
        this.jCBReactionInverted.setText(resourceMap.getString("jCBReactionInverted.text", new Object[0]));
        this.jCBReactionInverted.setToolTipText(resourceMap.getString("jCBReactionInverted.toolTipText", new Object[0]));
        this.jCBReactionInverted.setName("jCBReactionInverted");
        this.groupReaction.add((Component)this.jCBReactionInverted, new AbsoluteConstraints(430, 60, -1, -1));
        this.jLabelReactionHPF.setText(resourceMap.getString("jLabelReactionHPF.text", new Object[0]));
        this.jLabelReactionHPF.setName("jLabelReactionHPF");
        this.groupReaction.add((Component)this.jLabelReactionHPF, new AbsoluteConstraints(20, 90, 220, -1));
        this.jSpinnerReactionHPF.setModel(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.02));
        this.jSpinnerReactionHPF.setName("jSpinnerReactionHPF");
        this.groupReaction.add((Component)this.jSpinnerReactionHPF, new AbsoluteConstraints(250, 90, 70, -1));
        this.jLabelReactionBrake.setText(resourceMap.getString("jLabelReactionBrake.text", new Object[0]));
        this.jLabelReactionBrake.setName("jLabelReactionBrake");
        this.groupReaction.add((Component)this.jLabelReactionBrake, new AbsoluteConstraints(20, 120, -1, -1));
        this.jSpinnerReactionBrake.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerReactionBrake.setName("jSpinnerReactionBrake");
        this.groupReaction.add((Component)this.jSpinnerReactionBrake, new AbsoluteConstraints(250, 120, 70, -1));
        this.add(this.groupReaction);
        this.groupReaction.setBounds(0, 260, 705, 160);
        this.groupExtMotors.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupExtMotors.border.title", new Object[0])));
        this.groupExtMotors.setName("groupExtMotors");
        this.groupExtMotors.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelExtMotId.setFont(this.jLabelExtMotId.getFont().deriveFont(this.jLabelExtMotId.getFont().getStyle() | 1));
        this.jLabelExtMotId.setText(resourceMap.getString("jLabelExtMotId.text", new Object[0]));
        this.jLabelExtMotId.setName("jLabelExtMotId");
        this.groupExtMotors.add((Component)this.jLabelExtMotId, new AbsoluteConstraints(20, 30, 220, -1));
        this.jCBExtMotId.setToolTipText(resourceMap.getString("jCBExtMotId.toolTipText", new Object[0]));
        this.jCBExtMotId.setName("jCBExtMotId");
        this.jCBExtMotId.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelExtraMotors.this.jCBExtMotIdItemStateChanged(evt);
            }
        });
        this.groupExtMotors.add((Component)this.jCBExtMotId, new AbsoluteConstraints(250, 30, 110, -1));
        this.jLabelExtMotDriver.setText(resourceMap.getString("jLabelExtMotDriver.text", new Object[0]));
        this.jLabelExtMotDriver.setName("jLabelExtMotDriver");
        this.groupExtMotors.add((Component)this.jLabelExtMotDriver, new AbsoluteConstraints(20, 60, 220, -1));
        this.jCBExtMotDriver.setToolTipText(resourceMap.getString("jCBExtMotDriver.toolTipText", new Object[0]));
        this.jCBExtMotDriver.setName("jCBExtMotDriver");
        this.groupExtMotors.add((Component)this.jCBExtMotDriver, new AbsoluteConstraints(250, 60, 110, -1));
        this.jCBExtMotInverted.setText(resourceMap.getString("jCBExtMotInverted.text", new Object[0]));
        this.jCBExtMotInverted.setToolTipText(resourceMap.getString("jCBExtMotInverted.toolTipText", new Object[0]));
        this.jCBExtMotInverted.setName("jCBExtMotInverted");
        this.groupExtMotors.add((Component)this.jCBExtMotInverted, new AbsoluteConstraints(420, 90, -1, -1));
        this.jLabelExtMotCtrlType.setText(resourceMap.getString("jLabelExtMotCtrlType.text", new Object[0]));
        this.jLabelExtMotCtrlType.setName("jLabelExtMotCtrlType");
        this.groupExtMotors.add((Component)this.jLabelExtMotCtrlType, new AbsoluteConstraints(20, 90, 220, -1));
        this.jCBExtMotCtrlType.setModel(new DefaultComboBoxModel<String>(new String[]{"Position", "Speed", "Torque", "Position (planner)", "2nd motor for ROLL", "2nd motor for PITCH", "2nd motor for YAW"}));
        this.jCBExtMotCtrlType.setName("jCBExtMotCtrlType");
        this.groupExtMotors.add((Component)this.jCBExtMotCtrlType, new AbsoluteConstraints(250, 90, 160, -1));
        this.jLabelExtMotRCSource.setText(resourceMap.getString("jLabelExtMotRCSource.text", new Object[0]));
        this.jLabelExtMotRCSource.setName("jLabelExtMotRCSource");
        this.groupExtMotors.add((Component)this.jLabelExtMotRCSource, new AbsoluteConstraints(20, 120, -1, -1));
        this.jCBExtMotRCSrc.setName("jCBExtMotRCSrc");
        this.groupExtMotors.add((Component)this.jCBExtMotRCSrc, new AbsoluteConstraints(250, 120, 220, -1));
        this.jSpinnerExtMotRCScale.setName("jSpinnerExtMotRCScale");
        this.groupExtMotors.add((Component)this.jSpinnerExtMotRCScale, new AbsoluteConstraints(500, 120, 70, -1));
        this.jLabelExtMorScale.setText(resourceMap.getString("jLabelExtMorScale.text", new Object[0]));
        this.jLabelExtMorScale.setName("jLabelExtMorScale");
        this.groupExtMotors.add((Component)this.jLabelExtMorScale, new AbsoluteConstraints(580, 120, -1, -1));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.groupExtMotors.add((Component)this.jLabel1, new AbsoluteConstraints(480, 120, -1, -1));
        this.add(this.groupExtMotors);
        this.groupExtMotors.setBounds(0, 420, 700, 280);
    }

    private void jCBReactionAxisItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyReactionParams();
            this.reaction_cur_axis = this.jCBReactionAxis.getSelectedIndex();
            this.updateReactionParams();
        }
    }

    private void jCBExtMotIdItemStateChanged(ItemEvent evt) {
        if (!this.updateControlsMode) {
            this.applyExtMotorParams();
            this.ext_mot_cur_idx = this.jCBExtMotId.getSelectedIndex();
            this.updateExtMotorParams();
        }
    }

    private void updateReactionParams() {
        ReactionParams p = this.getSelectedReactionParams();
        if (p != null) {
            this.updateControlsMode = true;
            this.jCBReactionDriver.setSelectedIndex(Math.min(p.drvId, this.jCBReactionDriver.getItemCount() - 1));
            this.jCBReactionInverted.setSelected((p.flags & 1) != 0);
            ((LogSpinnerModel)this.jSpinnerReactionHPF.getModel()).setValueInt(p.hpf);
            ((LogSpinnerModel)this.jSpinnerReactionBrake.getModel()).setValueInt(p.brake);
            this.updateControlsMode = false;
        }
    }

    private void applyReactionParams() {
        ReactionParams p = this.getSelectedReactionParams();
        if (p != null) {
            p.drvId = this.jCBReactionDriver.getSelectedIndex();
            p.flags = BoardParams.updateBit(p.flags, 1, this.jCBReactionInverted.isSelected());
            p.hpf = ((LogSpinnerModel)this.jSpinnerReactionHPF.getModel()).getValueInt();
            p.brake = ((LogSpinnerModel)this.jSpinnerReactionBrake.getModel()).getValueInt();
        }
    }

    private ReactionParams getSelectedReactionParams() {
        if (this.reaction_cur_axis >= 0 && this.reaction_cur_axis < this.reaction_params_tmp.length) {
            return this.reaction_params_tmp[this.reaction_cur_axis];
        }
        return null;
    }

    private void updateExtMotorParams() {
        ExtMotorParams p = this.getSelectedExtMotorParams();
        if (p != null) {
            this.updateControlsMode = true;
            this.jCBExtMotDriver.setSelectedIndex(Math.min(p.drvId, this.jCBExtMotDriver.getItemCount() - 1));
            this.jCBExtMotInverted.setSelected((p.flags & 1) != 0);
            ((SpravComboBoxModel)this.jCBExtMotRCSrc.getModel()).setCurrentOrAdd(p.rc_src, "SRC");
            ((LogSpinnerModel)this.jSpinnerExtMotRCScale.getModel()).setValueInt(p.rc_scale + 127);
            this.jCBExtMotCtrlType.setSelectedIndex(Math.min(p.ctrl_type, this.jCBExtMotCtrlType.getItemCount() - 1));
            this.jCBExtMotInverted.setSelected((p.flags & 1) != 0);
            this.updateControlsMode = false;
        }
    }

    private void applyExtMotorParams() {
        ExtMotorParams p = this.getSelectedExtMotorParams();
        if (p != null) {
            p.drvId = this.jCBExtMotDriver.getSelectedIndex();
            p.rc_src = ((SpravComboBoxModel)this.jCBExtMotRCSrc.getModel()).getCurrentId();
            p.rc_scale = ((LogSpinnerModel)this.jSpinnerExtMotRCScale.getModel()).getValueInt() - 127;
            p.ctrl_type = this.jCBExtMotCtrlType.getSelectedIndex();
            p.flags = BoardParams.updateBit(p.flags, 1, this.jCBExtMotInverted.isSelected());
        }
    }

    private ExtMotorParams getSelectedExtMotorParams() {
        if (this.ext_mot_cur_idx >= 0 && this.ext_mot_cur_idx < this.ext_motor_params_tmp.length) {
            return this.ext_motor_params_tmp[this.ext_mot_cur_idx];
        }
        return null;
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        int i;
        BoardProfile p = params.profiles[params.curProfile];
        ((SpravComboBoxModel)this.jComboBoxMotor4Output.getModel()).setCurrentOrAdd(params.motor4.motor_out, "output");
        this.jComboBoxMotor4Axis.setSelectedIndex(Math.min(Math.abs(params.motor4.axis), 3));
        this.jCheckBoxMotor4Inverted.setSelected(params.motor4.axis < 0);
        this.jSpinnerMotor4ServoNeutral.setValue(params.motor4.servo_neutral);
        this.jSpinnerMotor4ServoRange.setValue(params.motor4.servo_range * 10);
        this.jSpinnerMotor4SpeedScale.setValue(Float.valueOf((float)params.motor4.speed_scale / 100.0f));
        this.jSpinnerMotor4PidP.setValue(Float.valueOf((float)params.motor4.pid_P / 100.0f));
        this.jSpinnerMotor4PidI.setValue(Float.valueOf((float)params.motor4.pid_I / 100.0f));
        this.jSpinnerMotor4PidD.setValue(Float.valueOf((float)params.motor4.pid_D / 100.0f));
        this.jSpinnerMotor4LPFFreq.setValue(params.motor4.pid_D_LPF);
        this.jSpinnerMotor4ServoP.setValue(params.motor4.servo_P);
        this.jSpinnerMotor4LimitsWidth.setValue(params.motor4.limits_width);
        this.jSpinnerMotor4LimitsWeight.setValue(params.motor4.limits_weight);
        for (i = 0; i < 3; ++i) {
            this.reaction_params_tmp[i] = ReactionParams.readFromParams(i, params.reaction_drv_id[i], params);
        }
        this.updateReactionParams();
        for (i = 0; i < this.ext_motor_params_tmp.length; ++i) {
            this.ext_motor_params_tmp[i] = ExtMotorParams.readFromParams(i + 1, params.ext_motor_drv_id[i], params);
        }
        this.updateExtMotorParams();
    }

    @Override
    public void updateBoardVerUI() {
        BoardInfo info = BoardInfo.getBoardInfo();
        this.jComboBoxMotor4Output.setModel(new SpravComboBoxModel(ParamsUIFactory.getMotor4OutputList(info), this.jComboBoxMotor4Output.getModel()));
        ArrayList<Sprav> rcSrcList = ParamsUIFactory.getRCMapList(info);
        this.jCBExtMotRCSrc.setModel(new SpravComboBoxModel(rcSrcList, this.jCBExtMotRCSrc.getModel()));
    }

    @Override
    public void applyBoardParams(BoardParams params) throws Exception {
        int i;
        BoardProfile p = params.profiles[params.curProfile];
        params.motor4.motor_out = ((SpravComboBoxModel)this.jComboBoxMotor4Output.getModel()).getCurrentId();
        int drv_idx = params.motor4.motor_out - 64;
        if (drv_idx >= 0 && drv_idx < 7) {
            params.CAN_Drv_soft_params[drv_idx].assignToFunction("Motor4");
        }
        params.motor4.axis = this.jComboBoxMotor4Axis.getSelectedIndex();
        if (this.jCheckBoxMotor4Inverted.isSelected()) {
            params.motor4.axis = -params.motor4.axis;
        }
        params.motor4.servo_neutral = ((Number)this.jSpinnerMotor4ServoNeutral.getValue()).intValue();
        params.motor4.servo_range = ((Number)this.jSpinnerMotor4ServoRange.getValue()).intValue() / 10;
        params.motor4.speed_scale = Math.round(((Number)this.jSpinnerMotor4SpeedScale.getValue()).floatValue() * 100.0f);
        params.motor4.pid_P = Math.round(((Number)this.jSpinnerMotor4PidP.getValue()).floatValue() * 100.0f);
        params.motor4.pid_I = Math.round(((Number)this.jSpinnerMotor4PidI.getValue()).floatValue() * 100.0f);
        params.motor4.pid_D = Math.round(((Number)this.jSpinnerMotor4PidD.getValue()).floatValue() * 100.0f);
        params.motor4.pid_D_LPF = ((Number)this.jSpinnerMotor4LPFFreq.getValue()).intValue();
        params.motor4.servo_P = ((Number)this.jSpinnerMotor4ServoP.getValue()).intValue();
        params.motor4.limits_width = ((Number)this.jSpinnerMotor4LimitsWidth.getValue()).intValue();
        params.motor4.limits_weight = ((Number)this.jSpinnerMotor4LimitsWeight.getValue()).intValue();
        this.applyReactionParams();
        for (i = 0; i < 3; ++i) {
            params.reaction_drv_id[i] = 0;
            if (!this.writeExtMotorParams(this.reaction_params_tmp[i], params)) continue;
            params.reaction_drv_id[i] = this.reaction_params_tmp[i].getDrvId();
        }
        this.applyExtMotorParams();
        for (i = 0; i < this.ext_motor_params_tmp.length; ++i) {
            ExtMotorParams mp = this.ext_motor_params_tmp[i];
            params.ext_motor_drv_id[i] = 0;
            if (!this.writeExtMotorParams(mp, params)) continue;
            params.ext_motor_drv_id[i] = mp.getDrvId();
        }
    }

    private boolean writeExtMotorParams(IExtMotorParams p, BoardParams params) throws Exception {
        if (p != null && p.getDrvId() > 0 && p.getDrvId() <= 7) {
            int drv_idx = p.getDrvId() - 1;
            String functionName = p.getFunctionName();
            params.CAN_Drv_soft_params[drv_idx].assignToFunction(functionName);
            boolean overwrite = false;
            while (!overwrite) {
                try {
                    p.write(params.CAN_Drv_soft_params[drv_idx], overwrite);
                    p.write(this.mainView.panelCAN.getCanDrvSoftParamsTmp(drv_idx), overwrite);
                    return true;
                }
                catch (IOException e) {
                    if (!this.mainView.showConfirmDialog(e.getMessage())) break;
                    overwrite = !overwrite;
                }
            }
        }
        return false;
    }
}

