/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultCaret;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.common.IFirmwareInfo;
import sbgc.common.IReferenceItem;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.object.ErrorInfo;
import sbgc.object.Sprav;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.FirmwareUpgraderImpl;
import sbgc.service.upgrade.IVersionCheckerListener;
import sbgc.service.upgrade.VersionCheckerFactory;
import sbgc.service.upgrade.VersionImpl;
import sbgc.ui.ComboBoxModelReferenceImpl;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.DateUtil;
import sbgc.utils.FileUtil;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.http.IResponse;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.DialogRegistrationData;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class TabbedPanelFirmwareUpdate
extends TabbedPanelBase
implements ITabbedPanel,
IVersionCheckerListener {
    private static final Log logger = new Log(Logger.getLogger((String)SimpleBGC_GUIView.class.getName()));
    private VersionImpl currentVersionFirmware = null;
    private VersionImpl latestVersionFirmware = null;
    private VersionImpl latestVersionGui = null;
    boolean inBackground;
    String firmwareListForDeviceId = null;
    static final Pattern httpLinkPattern = Pattern.compile("https?://\\S+?(?=([\\)\\]\\}][.,;?!]?)?(\\s|$))");
    private JButton buttonCheckVersion;
    private JButton buttonFirmwareHexFileBrowse;
    private JButton buttonFirmwareHexFileFlash;
    private JButton buttonFirmwareUpgradeStart;
    private JButton buttonModuleFirmwareBrowse;
    private JButton buttonModuleFirmwareFlash;
    private JButton buttonReadDeviceSN;
    private JCheckBox checkBoxCheckOnStartup;
    private JComboBox comboBoxBoardType;
    private JComboBox comboBoxModuleUpgradeType;
    private JComboBox comboBoxVersionTitle;
    private JTabbedPane groupFirmwareUpdate;
    private JButton jButtonCopyBoardSN;
    private JButton jButtonCopyDeviceSN;
    private JButton jButtonLicRefresh;
    private JButton jButtonLicWrite;
    private JButton jButtonModuleRefresh;
    private JButton jButtonSaveFile;
    private JCheckBox jCheckBoxCheckBeta;
    private JCheckBox jCheckBoxCompatibleOnly;
    private JCheckBox jCheckBoxExperimental;
    private JCheckBox jCheckBoxHighSpeed;
    private JComboBox jComboBoxLicType;
    private JLabel jLabel39;
    private JLabel jLabelBoardSN;
    private JLabel jLabelConModNote;
    private JLabel jLabelLicType;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaLic;
    private JTextArea jTextAreaLicInfo;
    private JTextField jTextFieldBoardId;
    private JLabel labelCurrentVersion2;
    private JLabel labelCurrentVersionValue;
    private JLabel labelDeviceSN;
    private JLabel labelFirmwareUpgradeHex;
    private JLabel labelFirmwareUpgradeHex1;
    private JLabel labelLatestVersion;
    private JLabel labelLatestVersion2;
    private JLabel labelModuleFirmwareFile;
    private JLabel labelUpgradeModule;
    private JLabel labelUpgradeToVersion;
    private JPanel panelExtLicenses;
    private JPanel panelFirmwareUpgradeAutomatic;
    private JPanel panelFirmwareUpgradeLog;
    private JPanel panelFirmwareUpgradeManual;
    private JPanel panelFirmwareUpgradeOptions;
    private JPanel panelUpgradeFromFile;
    private JPanel panelUpgradeModule;
    private JScrollPane scrollPaneVersionDetails;
    private JTextPane textAreaVersionDetails;
    private JTextField textFieldDeviceSN;
    private JTextField textFieldFirmwareHexFile;
    private JTextField textFieldModuleFirmwareFile;

    public TabbedPanelFirmwareUpdate(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.checkBoxCheckOnStartup.setSelected(Settings.is("latest.versions.autocheck"));
        this.jCheckBoxCheckBeta.setSelected(Settings.is("firmware_update.check_beta"));
        this.jCheckBoxExperimental.setSelected(Settings.is("firmware_update.experimental"));
        this.jCheckBoxCompatibleOnly.setSelected(true);
        this.textFieldFirmwareHexFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkFlashButtonEnabled();
            }

            public void checkFlashButtonEnabled() {
                TabbedPanelFirmwareUpdate.this.buttonFirmwareHexFileFlash.setEnabled(TabbedPanelFirmwareUpdate.this.textFieldFirmwareHexFile.getText() != null && TabbedPanelFirmwareUpdate.this.textFieldFirmwareHexFile.getText().trim().length() > 0);
            }
        });
        this.comboBoxVersionTitle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object item;
                if (event.getStateChange() == 1 && (item = event.getItem()) != null) {
                    final IFirmwareInfo info = (IFirmwareInfo)item;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultCaret caret = (DefaultCaret)TabbedPanelFirmwareUpdate.this.textAreaVersionDetails.getCaret();
                            caret.setUpdatePolicy(1);
                            TabbedPanelFirmwareUpdate.this.showFwDetailsHtml(info);
                            TabbedPanelFirmwareUpdate.this.buttonFirmwareUpgradeStart.setEnabled(true);
                            TabbedPanelFirmwareUpdate.this.jButtonSaveFile.setEnabled(true);
                        }
                    });
                }
            }
        });
        this.textAreaVersionDetails.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    try {
                        SimpleBGC_GUIView.browseURI(e.getURL().toString());
                    }
                    catch (Exception ex) {
                        logger.stackTrace(ex);
                    }
                }
            }
        });
        this.jCheckBoxHighSpeed.setSelected(Settings.is("firmware_update.flash_high_speed", false));
    }

    private void initComponents() {
        this.groupFirmwareUpdate = new JTabbedPane();
        this.panelFirmwareUpgradeAutomatic = new JPanel();
        this.panelFirmwareUpgradeOptions = new JPanel();
        this.labelDeviceSN = new JLabel();
        this.textFieldDeviceSN = new JTextField();
        this.buttonReadDeviceSN = new JButton();
        this.labelCurrentVersion2 = new JLabel();
        this.labelLatestVersion2 = new JLabel();
        this.labelCurrentVersionValue = new JLabel();
        this.labelLatestVersion = new JLabel();
        this.checkBoxCheckOnStartup = new JCheckBox();
        this.labelUpgradeToVersion = new JLabel();
        this.comboBoxVersionTitle = new JComboBox();
        this.buttonFirmwareUpgradeStart = new JButton();
        this.jCheckBoxCheckBeta = new JCheckBox();
        this.jButtonCopyDeviceSN = new JButton();
        this.jCheckBoxCompatibleOnly = new JCheckBox();
        this.jCheckBoxExperimental = new JCheckBox();
        this.buttonCheckVersion = new JButton();
        this.jButtonSaveFile = new JButton();
        this.jLabelBoardSN = new JLabel();
        this.jTextFieldBoardId = new JTextField();
        this.jButtonCopyBoardSN = new JButton();
        this.panelFirmwareUpgradeLog = new JPanel();
        this.scrollPaneVersionDetails = new JScrollPane();
        this.textAreaVersionDetails = new JTextPane();
        this.panelFirmwareUpgradeManual = new JPanel();
        this.panelUpgradeFromFile = new JPanel();
        this.labelFirmwareUpgradeHex = new JLabel();
        this.textFieldFirmwareHexFile = new JTextField();
        this.buttonFirmwareHexFileBrowse = new JButton();
        this.buttonFirmwareHexFileFlash = new JButton();
        this.comboBoxBoardType = new JComboBox();
        this.labelFirmwareUpgradeHex1 = new JLabel();
        this.jLabel39 = new JLabel();
        this.jCheckBoxHighSpeed = new JCheckBox();
        this.panelUpgradeModule = new JPanel();
        this.labelModuleFirmwareFile = new JLabel();
        this.textFieldModuleFirmwareFile = new JTextField();
        this.buttonModuleFirmwareBrowse = new JButton();
        this.buttonModuleFirmwareFlash = new JButton();
        this.labelUpgradeModule = new JLabel();
        this.comboBoxModuleUpgradeType = new JComboBox();
        this.jButtonModuleRefresh = new JButton();
        this.jLabelConModNote = new JLabel();
        this.panelExtLicenses = new JPanel();
        this.jLabelLicType = new JLabel();
        this.jComboBoxLicType = new JComboBox();
        this.jButtonLicWrite = new JButton();
        this.jButtonLicRefresh = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaLic = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaLicInfo = new JTextArea();
        this.setName("FirmwareUpdate");
        this.setLayout(null);
        this.groupFirmwareUpdate.setName("groupFirmwareUpdate");
        this.panelFirmwareUpgradeAutomatic.setName("panelFirmwareUpgradeAutomatic");
        this.panelFirmwareUpgradeAutomatic.setLayout(new BorderLayout());
        this.panelFirmwareUpgradeOptions.setName("panelFirmwareUpgradeOptions");
        this.panelFirmwareUpgradeOptions.setPreferredSize(new Dimension(698, 140));
        this.panelFirmwareUpgradeOptions.setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelFirmwareUpdate.class);
        this.labelDeviceSN.setText(resourceMap.getString("labelDeviceSN.text", new Object[0]));
        this.labelDeviceSN.setName("labelDeviceSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelDeviceSN, new AbsoluteConstraints(10, 15, 120, -1));
        this.textFieldDeviceSN.setEditable(false);
        this.textFieldDeviceSN.setToolTipText(resourceMap.getString("textFieldDeviceSN.toolTipText", new Object[0]));
        this.textFieldDeviceSN.setCursor(new Cursor(2));
        this.textFieldDeviceSN.setName("textFieldDeviceSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.textFieldDeviceSN, new AbsoluteConstraints(130, 10, 200, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelFirmwareUpdate.class, this);
        this.buttonReadDeviceSN.setAction(actionMap.get("updateDeviceSN"));
        this.buttonReadDeviceSN.setIcon(resourceMap.getIcon("buttonReadDeviceSN.icon"));
        this.buttonReadDeviceSN.setText(resourceMap.getString("buttonReadDeviceSN.text", new Object[0]));
        this.buttonReadDeviceSN.setToolTipText(resourceMap.getString("buttonReadDeviceSN.toolTipText", new Object[0]));
        this.buttonReadDeviceSN.setName("buttonReadDeviceSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.buttonReadDeviceSN, new AbsoluteConstraints(340, 8, 30, 30));
        this.labelCurrentVersion2.setText(resourceMap.getString("labelCurrentVersion2.text", new Object[0]));
        this.labelCurrentVersion2.setName("labelCurrentVersion2");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelCurrentVersion2, new AbsoluteConstraints(10, 40, 120, -1));
        this.labelLatestVersion2.setText(resourceMap.getString("labelLatestVersion2.text", new Object[0]));
        this.labelLatestVersion2.setName("labelLatestVersion2");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelLatestVersion2, new AbsoluteConstraints(220, 40, 120, -1));
        this.labelCurrentVersionValue.setFont(this.labelCurrentVersionValue.getFont().deriveFont(this.labelCurrentVersionValue.getFont().getStyle() | 1));
        this.labelCurrentVersionValue.setHorizontalAlignment(2);
        this.labelCurrentVersionValue.setText(resourceMap.getString("labelCurrentVersionValue.text", new Object[0]));
        this.labelCurrentVersionValue.setName("labelCurrentVersionValue");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelCurrentVersionValue, new AbsoluteConstraints(130, 40, 80, -1));
        this.labelLatestVersion.setFont(this.labelLatestVersion.getFont().deriveFont(this.labelLatestVersion.getFont().getStyle() | 1));
        this.labelLatestVersion.setHorizontalAlignment(2);
        this.labelLatestVersion.setText(resourceMap.getString("labelLatestVersion.text", new Object[0]));
        this.labelLatestVersion.setName("labelLatestVersion");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelLatestVersion, new AbsoluteConstraints(340, 40, 80, -1));
        this.checkBoxCheckOnStartup.setAction(actionMap.get("latestVersionAutocheckChanged"));
        this.checkBoxCheckOnStartup.setText(resourceMap.getString("checkBoxCheckOnStartup.text", new Object[0]));
        this.checkBoxCheckOnStartup.setToolTipText(resourceMap.getString("checkBoxCheckOnStartup.toolTipText", new Object[0]));
        this.checkBoxCheckOnStartup.setName("checkBoxCheckOnStartup");
        this.panelFirmwareUpgradeOptions.add((Component)this.checkBoxCheckOnStartup, new AbsoluteConstraints(520, 40, 190, -1));
        this.labelUpgradeToVersion.setText(resourceMap.getString("labelUpgradeToVersion.text", new Object[0]));
        this.labelUpgradeToVersion.setName("labelUpgradeToVersion");
        this.panelFirmwareUpgradeOptions.add((Component)this.labelUpgradeToVersion, new AbsoluteConstraints(10, 115, 120, -1));
        this.comboBoxVersionTitle.setName("comboBoxVersionTitle");
        this.panelFirmwareUpgradeOptions.add((Component)this.comboBoxVersionTitle, new AbsoluteConstraints(130, 110, 400, -1));
        this.buttonFirmwareUpgradeStart.setAction(actionMap.get("upgradeFirmwareVersion"));
        this.buttonFirmwareUpgradeStart.setFont(this.buttonFirmwareUpgradeStart.getFont().deriveFont(this.buttonFirmwareUpgradeStart.getFont().getStyle() | 1));
        this.buttonFirmwareUpgradeStart.setText(resourceMap.getString("buttonFirmwareUpgradeStart.text", new Object[0]));
        this.buttonFirmwareUpgradeStart.setName("buttonFirmwareUpgradeStart");
        this.panelFirmwareUpgradeOptions.add((Component)this.buttonFirmwareUpgradeStart, new AbsoluteConstraints(540, 110, 140, -1));
        this.jCheckBoxCheckBeta.setAction(actionMap.get("latestVersionAutocheckChanged"));
        this.jCheckBoxCheckBeta.setText(resourceMap.getString("jCheckBoxCheckBeta.text", new Object[0]));
        this.jCheckBoxCheckBeta.setToolTipText(resourceMap.getString("jCheckBoxCheckBeta.toolTipText", new Object[0]));
        this.jCheckBoxCheckBeta.setName("jCheckBoxCheckBeta");
        this.panelFirmwareUpgradeOptions.add((Component)this.jCheckBoxCheckBeta, new AbsoluteConstraints(280, 80, 230, -1));
        this.jButtonCopyDeviceSN.setAction(actionMap.get("buttonDeviceSNCopy"));
        this.jButtonCopyDeviceSN.setIcon(resourceMap.getIcon("jButtonCopyDeviceSN.icon"));
        this.jButtonCopyDeviceSN.setText(resourceMap.getString("jButtonCopyDeviceSN.text", new Object[0]));
        this.jButtonCopyDeviceSN.setToolTipText(resourceMap.getString("jButtonCopyDeviceSN.toolTipText", new Object[0]));
        this.jButtonCopyDeviceSN.setName("jButtonCopyDeviceSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.jButtonCopyDeviceSN, new AbsoluteConstraints(372, 8, 30, 30));
        this.jCheckBoxCompatibleOnly.setAction(actionMap.get("latestVersionAutocheckChanged"));
        this.jCheckBoxCompatibleOnly.setText(resourceMap.getString("jCheckBoxCompatibleOnly.text", new Object[0]));
        this.jCheckBoxCompatibleOnly.setToolTipText(resourceMap.getString("jCheckBoxCompatibleOnly.toolTipText", new Object[0]));
        this.jCheckBoxCompatibleOnly.setName("jCheckBoxCompatibleOnly");
        this.panelFirmwareUpgradeOptions.add((Component)this.jCheckBoxCompatibleOnly, new AbsoluteConstraints(10, 61, 270, -1));
        this.jCheckBoxExperimental.setText(resourceMap.getString("jCheckBoxExperimental.text", new Object[0]));
        this.jCheckBoxExperimental.setName("jCheckBoxExperimental");
        this.panelFirmwareUpgradeOptions.add((Component)this.jCheckBoxExperimental, new AbsoluteConstraints(280, 60, 230, -1));
        this.buttonCheckVersion.setAction(actionMap.get("checkLatestVersions"));
        this.buttonCheckVersion.setText(resourceMap.getString("buttonCheckVersion.text", new Object[0]));
        this.buttonCheckVersion.setName("buttonCheckVersion");
        this.panelFirmwareUpgradeOptions.add((Component)this.buttonCheckVersion, new AbsoluteConstraints(520, 70, 190, -1));
        this.jButtonSaveFile.setAction(actionMap.get("buttonSaveFile"));
        this.jButtonSaveFile.setText(resourceMap.getString("jButtonSaveFile.text", new Object[0]));
        this.jButtonSaveFile.setToolTipText(resourceMap.getString("jButtonSaveFile.toolTipText", new Object[0]));
        this.jButtonSaveFile.setName("jButtonSaveFile");
        this.panelFirmwareUpgradeOptions.add((Component)this.jButtonSaveFile, new AbsoluteConstraints(690, 110, 25, -1));
        this.jLabelBoardSN.setHorizontalAlignment(11);
        this.jLabelBoardSN.setText(resourceMap.getString("jLabelBoardSN.text", new Object[0]));
        this.jLabelBoardSN.setName("jLabelBoardSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.jLabelBoardSN, new AbsoluteConstraints(410, 15, 80, -1));
        this.jTextFieldBoardId.setEditable(false);
        this.jTextFieldBoardId.setText(resourceMap.getString("jTextFieldBoardId.text", new Object[0]));
        this.jTextFieldBoardId.setToolTipText(resourceMap.getString("jTextFieldBoardId.toolTipText", new Object[0]));
        this.jTextFieldBoardId.setCursor(new Cursor(2));
        this.jTextFieldBoardId.setName("jTextFieldBoardId");
        this.panelFirmwareUpgradeOptions.add((Component)this.jTextFieldBoardId, new AbsoluteConstraints(500, 10, 170, -1));
        this.jButtonCopyBoardSN.setAction(actionMap.get("buttonBoardSNCopy"));
        this.jButtonCopyBoardSN.setIcon(resourceMap.getIcon("jButtonCopyBoardSN.icon"));
        this.jButtonCopyBoardSN.setText(resourceMap.getString("jButtonCopyBoardSN.text", new Object[0]));
        this.jButtonCopyBoardSN.setToolTipText(resourceMap.getString("jButtonCopyDeviceSN.toolTipText", new Object[0]));
        this.jButtonCopyBoardSN.setName("jButtonCopyBoardSN");
        this.panelFirmwareUpgradeOptions.add((Component)this.jButtonCopyBoardSN, new AbsoluteConstraints(675, 8, 30, 30));
        this.panelFirmwareUpgradeAutomatic.add((Component)this.panelFirmwareUpgradeOptions, "North");
        this.panelFirmwareUpgradeLog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelFirmwareUpgradeLog.setName("panelFirmwareUpgradeLog");
        this.panelFirmwareUpgradeLog.setLayout(new BorderLayout());
        this.scrollPaneVersionDetails.setName("scrollPaneVersionDetails");
        this.textAreaVersionDetails.setContentType(resourceMap.getString("textAreaVersionDetails.contentType", new Object[0]));
        this.textAreaVersionDetails.setEditable(false);
        this.textAreaVersionDetails.setForeground(resourceMap.getColor("textAreaVersionDetails.foreground"));
        this.textAreaVersionDetails.setName("textAreaVersionDetails");
        this.scrollPaneVersionDetails.setViewportView(this.textAreaVersionDetails);
        this.panelFirmwareUpgradeLog.add((Component)this.scrollPaneVersionDetails, "Center");
        this.panelFirmwareUpgradeAutomatic.add((Component)this.panelFirmwareUpgradeLog, "Center");
        this.groupFirmwareUpdate.addTab(resourceMap.getString("panelFirmwareUpgradeAutomatic.TabConstraints.tabTitle", new Object[0]), this.panelFirmwareUpgradeAutomatic);
        this.panelFirmwareUpgradeManual.setName("panelFirmwareUpgradeManual");
        this.panelFirmwareUpgradeManual.setLayout(new BorderLayout());
        this.panelUpgradeFromFile.setName("panelUpgradeFromFile");
        this.panelUpgradeFromFile.setPreferredSize(new Dimension(698, 50));
        this.labelFirmwareUpgradeHex.setText(resourceMap.getString("labelFirmwareUpgradeHex.text", new Object[0]));
        this.labelFirmwareUpgradeHex.setName("labelFirmwareUpgradeHex");
        this.textFieldFirmwareHexFile.setName("textFieldFirmwareHexFile");
        this.buttonFirmwareHexFileBrowse.setAction(actionMap.get("selectFirmwareHexFile"));
        this.buttonFirmwareHexFileBrowse.setText(resourceMap.getString("buttonFirmwareHexFileBrowse.text", new Object[0]));
        this.buttonFirmwareHexFileBrowse.setName("buttonFirmwareHexFileBrowse");
        this.buttonFirmwareHexFileFlash.setAction(actionMap.get("upgradeFirmwareFromHexFile"));
        this.buttonFirmwareHexFileFlash.setText(resourceMap.getString("buttonFirmwareHexFileFlash.text", new Object[0]));
        this.buttonFirmwareHexFileFlash.setName("buttonFirmwareHexFileFlash");
        this.comboBoxBoardType.setModel(new DefaultComboBoxModel<String>(new String[]{"v.3.x (32bit) through Virtual COM Port", "v.3.x (32bit) through USB in DFU mode"}));
        this.comboBoxBoardType.setName("comboBoxBoardType");
        this.labelFirmwareUpgradeHex1.setText(resourceMap.getString("labelFirmwareUpgradeHex1.text", new Object[0]));
        this.labelFirmwareUpgradeHex1.setName("labelFirmwareUpgradeHex1");
        this.jLabel39.setText(resourceMap.getString("jLabel39.text", new Object[0]));
        this.jLabel39.setVerticalAlignment(1);
        this.jLabel39.setName("jLabel39");
        this.jCheckBoxHighSpeed.setText(resourceMap.getString("jCheckBoxHighSpeed.text", new Object[0]));
        this.jCheckBoxHighSpeed.setToolTipText(resourceMap.getString("jCheckBoxHighSpeed.toolTipText", new Object[0]));
        this.jCheckBoxHighSpeed.setName("jCheckBoxHighSpeed");
        this.jCheckBoxHighSpeed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelFirmwareUpdate.this.jCheckBoxHighSpeedItemStateChanged(evt);
            }
        });
        GroupLayout panelUpgradeFromFileLayout = new GroupLayout(this.panelUpgradeFromFile);
        this.panelUpgradeFromFile.setLayout(panelUpgradeFromFileLayout);
        panelUpgradeFromFileLayout.setHorizontalGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addContainerGap().addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel39, -1, 695, Short.MAX_VALUE).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFirmwareUpgradeHex).addComponent(this.labelFirmwareUpgradeHex1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addComponent(this.textFieldFirmwareHexFile, -2, 340, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFirmwareHexFileBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonFirmwareHexFileFlash)).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addComponent(this.comboBoxBoardType, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxHighSpeed))))).addContainerGap()));
        panelUpgradeFromFileLayout.setVerticalGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelUpgradeFromFileLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFirmwareUpgradeHex, -2, 20, -2).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonFirmwareHexFileFlash).addComponent(this.buttonFirmwareHexFileBrowse).addComponent(this.textFieldFirmwareHexFile, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelUpgradeFromFileLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFirmwareUpgradeHex1, -2, 20, -2).addComponent(this.comboBoxBoardType, -2, -1, -2).addComponent(this.jCheckBoxHighSpeed)).addGap(18, 18, 18).addComponent(this.jLabel39, -2, 56, -2).addContainerGap(147, Short.MAX_VALUE)));
        this.panelFirmwareUpgradeManual.add((Component)this.panelUpgradeFromFile, "Center");
        this.groupFirmwareUpdate.addTab(resourceMap.getString("panelFirmwareUpgradeManual.TabConstraints.tabTitle", new Object[0]), this.panelFirmwareUpgradeManual);
        this.panelUpgradeModule.setName("panelUpgradeModule");
        this.panelUpgradeModule.setLayout((LayoutManager)new AbsoluteLayout());
        this.labelModuleFirmwareFile.setText(resourceMap.getString("labelModuleFirmwareFile.text", new Object[0]));
        this.labelModuleFirmwareFile.setName("labelModuleFirmwareFile");
        this.panelUpgradeModule.add((Component)this.labelModuleFirmwareFile, new AbsoluteConstraints(20, 60, -1, -1));
        this.textFieldModuleFirmwareFile.setName("textFieldModuleFirmwareFile");
        this.panelUpgradeModule.add((Component)this.textFieldModuleFirmwareFile, new AbsoluteConstraints(140, 60, 370, -1));
        this.buttonModuleFirmwareBrowse.setAction(actionMap.get("moduleBrowseFile"));
        this.buttonModuleFirmwareBrowse.setText(resourceMap.getString("buttonModuleFirmwareBrowse.text", new Object[0]));
        this.buttonModuleFirmwareBrowse.setName("buttonModuleFirmwareBrowse");
        this.panelUpgradeModule.add((Component)this.buttonModuleFirmwareBrowse, new AbsoluteConstraints(520, 60, 90, -1));
        this.buttonModuleFirmwareFlash.setAction(actionMap.get("moduleFlashFile"));
        this.buttonModuleFirmwareFlash.setText(resourceMap.getString("buttonModuleFirmwareFlash.text", new Object[0]));
        this.buttonModuleFirmwareFlash.setName("buttonModuleFirmwareFlash");
        this.panelUpgradeModule.add((Component)this.buttonModuleFirmwareFlash, new AbsoluteConstraints(620, 60, 70, -1));
        this.labelUpgradeModule.setText(resourceMap.getString("labelUpgradeModule.text", new Object[0]));
        this.labelUpgradeModule.setName("labelUpgradeModule");
        this.panelUpgradeModule.add((Component)this.labelUpgradeModule, new AbsoluteConstraints(20, 20, -1, -1));
        this.comboBoxModuleUpgradeType.setName("comboBoxModuleUpgradeType");
        this.panelUpgradeModule.add((Component)this.comboBoxModuleUpgradeType, new AbsoluteConstraints(140, 20, 470, -1));
        this.jButtonModuleRefresh.setAction(actionMap.get("buttonModuleListRefresh"));
        this.jButtonModuleRefresh.setText(resourceMap.getString("jButtonModuleRefresh.text", new Object[0]));
        this.jButtonModuleRefresh.setName("jButtonModuleRefresh");
        this.panelUpgradeModule.add((Component)this.jButtonModuleRefresh, new AbsoluteConstraints(620, 20, -1, -1));
        this.jLabelConModNote.setText(resourceMap.getString("jLabelConModNote.text", new Object[0]));
        this.jLabelConModNote.setVerticalAlignment(1);
        this.jLabelConModNote.setName("jLabelConModNote");
        this.panelUpgradeModule.add((Component)this.jLabelConModNote, new AbsoluteConstraints(20, 110, 670, 60));
        this.groupFirmwareUpdate.addTab(resourceMap.getString("panelUpgradeModule.TabConstraints.tabTitle", new Object[0]), this.panelUpgradeModule);
        this.panelExtLicenses.setName("panelExtLicenses");
        this.panelExtLicenses.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelLicType.setText(resourceMap.getString("jLabelLicType.text", new Object[0]));
        this.jLabelLicType.setName("jLabelLicType");
        this.panelExtLicenses.add((Component)this.jLabelLicType, new AbsoluteConstraints(30, 20, 180, -1));
        this.jComboBoxLicType.setName("jComboBoxLicType");
        this.panelExtLicenses.add((Component)this.jComboBoxLicType, new AbsoluteConstraints(220, 20, 470, -1));
        this.jButtonLicWrite.setAction(actionMap.get("buttonLicWrite"));
        this.jButtonLicWrite.setText(resourceMap.getString("jButtonLicWrite.text", new Object[0]));
        this.jButtonLicWrite.setName("jButtonLicWrite");
        this.panelExtLicenses.add((Component)this.jButtonLicWrite, new AbsoluteConstraints(605, 150, 80, -1));
        this.jButtonLicRefresh.setAction(actionMap.get("buttonLicRefresh"));
        this.jButtonLicRefresh.setText(resourceMap.getString("jButtonLicRefresh.text", new Object[0]));
        this.jButtonLicRefresh.setName("jButtonLicRefresh");
        this.panelExtLicenses.add((Component)this.jButtonLicRefresh, new AbsoluteConstraints(30, 150, -1, -1));
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextAreaLic.setColumns(20);
        this.jTextAreaLic.setLineWrap(true);
        this.jTextAreaLic.setRows(5);
        this.jTextAreaLic.setText(resourceMap.getString("jTextAreaLic.text", new Object[0]));
        this.jTextAreaLic.setName("jTextAreaLic");
        this.jTextAreaLic.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TabbedPanelFirmwareUpdate.this.jTextAreaFocusGained(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaLic);
        this.panelExtLicenses.add((Component)this.jScrollPane1, new AbsoluteConstraints(30, 50, 660, 90));
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaLicInfo.setColumns(20);
        this.jTextAreaLicInfo.setEditable(false);
        this.jTextAreaLicInfo.setLineWrap(true);
        this.jTextAreaLicInfo.setRows(5);
        this.jTextAreaLicInfo.setName("jTextAreaLicInfo");
        this.jScrollPane2.setViewportView(this.jTextAreaLicInfo);
        this.panelExtLicenses.add((Component)this.jScrollPane2, new AbsoluteConstraints(30, 180, 660, 100));
        this.groupFirmwareUpdate.addTab(resourceMap.getString("panelExtLicenses.TabConstraints.tabTitle", new Object[0]), this.panelExtLicenses);
        this.add(this.groupFirmwareUpdate);
        this.groupFirmwareUpdate.setBounds(0, 0, 720, 310);
    }

    private void jTextAreaFocusGained(FocusEvent evt) {
        if (this.jTextAreaLic.getText().equals(this.resourceMap.getString("jTextAreaLic.text", new Object[0]))) {
            this.jTextAreaLic.setText("");
        }
    }

    private void jCheckBoxHighSpeedItemStateChanged(ItemEvent evt) {
        Settings.set("firmware_update.flash_high_speed", this.jCheckBoxHighSpeed.isSelected());
    }

    public void showFwDetailsHtml(IFirmwareInfo info) {
        String details = httpLinkPattern.matcher(info.getDescription()).replaceAll("<a href=\"$0\" target=\"_blank\">$0</a>");
        String html = "<html><style>BODY, A { font-family: Arial, sans-serif; color:#FFFFFF; }\n.gray { color:#999999 }\n.warn { color:#FFFF99; }\n</style><body><div class=\"gray\">VersionID: " + info.getVersionId() + (info.isExperimental() ? " <span class=\"warn\">EXPERIMENTAL</span>" : "") + "</div>" + details.replace("\n", "<br>") + "</body></html>";
        this.textAreaVersionDetails.setText(html);
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    @Override
    public void onConnected(boolean state) {
        if (!state) {
            this.jTextFieldBoardId.setText(null);
        }
    }

    @Override
    public void updateBoardVerUI() {
        BoardInfo info = BoardInfo.getBoardInfo();
        if (BoardInfo.hasConnectedModules()) {
            this.groupFirmwareUpdate.addTab(this.resourceMap.getString("panelUpgradeModule.TabConstraints.tabTitle", new Object[0]), this.panelUpgradeModule);
        } else {
            this.groupFirmwareUpdate.remove(this.panelUpgradeModule);
        }
        if (BoardInfo.hasExtLicenses()) {
            this.groupFirmwareUpdate.addTab(this.resourceMap.getString("panelExtLicenses.TabConstraints.tabTitle", new Object[0]), this.panelExtLicenses);
            this.jComboBoxLicType.setModel(new SpravComboBoxModel(ParamsUIFactory.getExtLicensesTypes(), this.jComboBoxLicType.getModel()));
            this.jComboBoxLicType.setSelectedIndex(0);
        } else {
            this.groupFirmwareUpdate.remove(this.panelExtLicenses);
            this.jTextAreaLicInfo.setText("");
        }
        if (info != null) {
            if (this.firmwareListForDeviceId == null || !info.getDeviceId().equals(this.firmwareListForDeviceId)) {
                this.onVersionsLoaded(null);
            }
            this.firmwareListForDeviceId = info.getDeviceId();
        }
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    public void checkLatestVersionsWithoutWaiting() {
        try {
            this.inBackground = true;
            VersionCheckerFactory.check(this, false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.check_version", e.toString()), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    @Override
    public void onEndCheck(final IResponse response) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TabbedPanelFirmwareUpdate.this.buttonCheckVersion.setEnabled(true);
                    if (response != null) {
                        TabbedPanelFirmwareUpdate.this.jTextFieldBoardId.setText(response.getBoardId());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onStartCheck() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TabbedPanelFirmwareUpdate.this.buttonCheckVersion.setEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onLatestFirmwareVersion(final VersionImpl version) {
        this.latestVersionFirmware = version;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPanelFirmwareUpdate.this.labelLatestVersion.setText(version.toString());
                if (TabbedPanelFirmwareUpdate.this.inBackground && !TabbedPanelFirmwareUpdate.this.mainView.isPanelVisible(TabbedPanelFirmwareUpdate.this) && TabbedPanelFirmwareUpdate.this.latestVersionFirmware != null && TabbedPanelFirmwareUpdate.this.currentVersionFirmware != null && TabbedPanelFirmwareUpdate.this.latestVersionFirmware.compareTo(TabbedPanelFirmwareUpdate.this.currentVersionFirmware) > 0) {
                    int ignoredVersionFirmware = 0;
                    if (Settings.get("ignored.firmware.version") != null) {
                        ignoredVersionFirmware = Integer.parseInt(Settings.get("ignored.firmware.version"));
                    }
                    if (TabbedPanelFirmwareUpdate.this.latestVersionFirmware.getFullVer() > ignoredVersionFirmware) {
                        Object[] options = new String[]{TabbedPanelFirmwareUpdate.this.resourceMap.getString("info.ignore_version", new Object[0]), TabbedPanelFirmwareUpdate.this.resourceMap.getString("info.go_to_upgrade", new Object[0]), TabbedPanelFirmwareUpdate.this.resourceMap.getString("info.cancel", new Object[0])};
                        int option = JOptionPane.showOptionDialog(TabbedPanelFirmwareUpdate.this.mainView.getFrame(), TabbedPanelFirmwareUpdate.this.resourceMap.getString("info.new_firmware_available", TabbedPanelFirmwareUpdate.this.latestVersionFirmware.toString()), TabbedPanelFirmwareUpdate.this.resourceMap.getString("messageDialog.info.title", new Object[0]), -1, 1, null, options, options[0]);
                        if (option == 0) {
                            Settings.set("ignored.firmware.version", "" + TabbedPanelFirmwareUpdate.this.latestVersionFirmware.getFullVer());
                            Settings.save();
                        } else if (option == 1) {
                            TabbedPanelFirmwareUpdate.this.mainView.setSelectedTab(TabbedPanelFirmwareUpdate.this);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onVersionsLoaded(ArrayList<IFirmwareInfo> firmwares) {
        this.buttonFirmwareUpgradeStart.setEnabled(false);
        this.jButtonSaveFile.setEnabled(false);
        this.textAreaVersionDetails.setText(null);
        ArrayList<IReferenceItem> references = new ArrayList<IReferenceItem>();
        if (firmwares != null) {
            for (IFirmwareInfo firmware : firmwares) {
                references.add(firmware);
            }
        }
        this.comboBoxVersionTitle.setModel(new ComboBoxModelReferenceImpl(references));
        if (references.size() > 0) {
            this.comboBoxVersionTitle.setSelectedItem(references.get(0));
        }
    }

    public void setFirmwareVersion(VersionImpl version) {
        this.currentVersionFirmware = version;
        if (version != null) {
            this.labelCurrentVersionValue.setText(version.toString());
            if (this.mainView.isConnected()) {
                if (this.latestVersionFirmware != null && this.latestVersionFirmware.compareTo(version) > 0 && !this.latestVersionFirmware.toString().equals(Settings.get("latest.version.firmware"))) {
                    JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("info.new_firmware_available", this.latestVersionFirmware.toString()), this.resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
                    Settings.set("latest.version.firmware", this.latestVersionFirmware.toString());
                    Settings.save();
                    this.mainView.setSelectedTab(this);
                }
                if (Settings.is("latest.versions.autocheck")) {
                    String lastCheckedDate = "";
                    if (Settings.get("last.version.check.date") != null) {
                        lastCheckedDate = Settings.get("last.version.check.date");
                    }
                    if (!DateUtil.format(new Date(), "yyyy.MM.dd").equals(lastCheckedDate)) {
                        this.checkLatestVersionsWithoutWaiting();
                    }
                }
            }
        } else {
            this.labelCurrentVersionValue.setText("-");
            this.labelLatestVersion.setText("-");
            this.buttonCheckVersion.setEnabled(false);
        }
    }

    public VersionImpl getCurrentFirmwareVersion() {
        return this.currentVersionFirmware;
    }

    public void setDeviceSN() {
        String deviceSN = null;
        if (BoardInfo.getBoardInfo() != null) {
            deviceSN = BoardInfo.getBoardInfo().getDeviceId();
            this.textFieldDeviceSN.setText(deviceSN);
            this.buttonCheckVersion.setEnabled(true);
        } else {
            this.textFieldDeviceSN.setText(null);
        }
    }

    private void saveCheckParams() {
        Settings.set("latest.versions.autocheck", Boolean.toString(this.checkBoxCheckOnStartup.isSelected()));
        Settings.set("firmware_update.check_beta", Boolean.toString(this.jCheckBoxCheckBeta.isSelected()));
        Settings.set("firmware_update.experimental", Boolean.toString(this.jCheckBoxExperimental.isSelected()));
        Settings.set("firmware_update.compatible_only", Boolean.toString(this.jCheckBoxCompatibleOnly.isSelected()));
        Settings.save();
    }

    @Action
    public void latestVersionAutocheckChanged() {
        this.saveCheckParams();
    }

    @Action
    public void checkLatestVersions() {
        this.saveCheckParams();
        try {
            this.inBackground = false;
            if (VersionCheckerFactory.check(this, true)) {
                this.buttonFirmwareUpgradeStart.setEnabled(false);
                this.jButtonSaveFile.setEnabled(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.check_version", e.toString()), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    @Action
    public void updateDeviceSN() {
        this.mainView.updateDeviceSN();
    }

    @Action
    public void upgradeFirmwareFromHexFile() {
        File firmwareHexFile = new File("test.hex");
        if (this.textFieldFirmwareHexFile.getText() == null || this.textFieldFirmwareHexFile.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.firmware_is_not_specified", new Object[0]), this.resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        firmwareHexFile = new File(this.textFieldFirmwareHexFile.getText().trim());
        if (!firmwareHexFile.exists()) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.firmware_file_does_not_exist", new Object[0]), this.resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo == null) {
            boardInfo = new BoardInfo();
            switch (this.comboBoxBoardType.getSelectedIndex()) {
                case 0: {
                    boardInfo.boardVer = 30;
                    break;
                }
                case 1: {
                    boardInfo.boardVer = 30;
                    boardInfo.connectionFlags = 1;
                }
            }
        }
        String comPort = this.mainView.getSelectedPort(boardInfo == null || boardInfo.connectionFlags != 1);
        this.upgrade(firmwareHexFile, null, boardInfo, comPort, null);
    }

    @Action
    public void selectFirmwareHexFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (Settings.get("last_used_firmware_directory") != null) {
            String lastUsedFirmwareDirectory = Settings.get("last_used_firmware_directory");
            fileChooser.setCurrentDirectory(new File(lastUsedFirmwareDirectory));
        } else {
            try {
                fileChooser.setCurrentDirectory(new File(Settings.getUserDir() + File.separatorChar + "firmware"));
            }
            catch (Exception e) {
                logger.error(this.resourceMap.getString("error.firmware.cant_set_default_directory", e.toString()));
            }
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter(this.resourceMap.getString("messageDialog.firmware_hex_bin_file.title", new Object[0]), "hex", "bin"));
        if (fileChooser.showOpenDialog(this.mainView.getFrame()) == 0) {
            Settings.set("last_used_firmware_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File firmware = fileChooser.getSelectedFile();
            this.textFieldFirmwareHexFile.setText(firmware.getAbsolutePath());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabbedPanelFirmwareUpdate.this.buttonFirmwareHexFileFlash.setEnabled(true);
                }
            });
        }
    }

    @Action
    public void upgradeFirmwareVersion() {
        this.upgradeFirmwareFromList(false);
    }

    private void upgradeFirmwareFromList(boolean saveToFile) {
        if (this.comboBoxVersionTitle.getSelectedIndex() != -1) {
            IFirmwareInfo frw = (IFirmwareInfo)this.comboBoxVersionTitle.getSelectedItem();
            BoardInfo boardInfo = BoardInfo.getBoardInfo();
            File saveFile = null;
            if (saveToFile) {
                saveFile = this.firmwareSaveFileDialog();
                if (saveFile == null) {
                    return;
                }
            } else {
                if (boardInfo != null && BoardInfo.getBoardInfo().getFrwVerShow() > frw.getVersion() && JOptionPane.showConfirmDialog(null, this.resourceMap.getString("confirm.versionDowngrade.text", new Object[0]), this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0, 2) == 1) {
                    return;
                }
                if (!DialogRegistrationData.isSuccessfull(this.mainView.getFrame())) {
                    return;
                }
            }
            this.upgrade(null, frw, boardInfo, this.mainView.getSelectedPort(true), saveFile);
        } else {
            JOptionPane.showMessageDialog(null, this.resourceMap.getString("error.select_firmware_version", new Object[0]), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
        }
    }

    @Action
    public void buttonDeviceSNCopy() {
        StringSelection stringSelection = new StringSelection(this.textFieldDeviceSN.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
        this.mainView.updateStatus("Device S/N is copied to clipboard");
    }

    @Action(enabledProperty="connected")
    public void moduleBrowseFile() {
        JFileChooser fileChooser = new JFileChooser();
        if (Settings.get("last_used_firmware_directory") != null) {
            String lastUsedFirmwareDirectory = Settings.get("last_used_firmware_directory");
            fileChooser.setCurrentDirectory(new File(lastUsedFirmwareDirectory));
        } else {
            try {
                fileChooser.setCurrentDirectory(new File(Settings.getUserDir() + File.separatorChar + "firmware"));
            }
            catch (Exception e) {
                logger.error(this.resourceMap.getString("error.firmware.cant_set_default_directory", e.toString()));
            }
        }
        fileChooser.setFileFilter(new FileNameExtensionFilter(this.resourceMap.getString("messageDialog.firmware_bin_file.title", new Object[0]), "bin"));
        if (fileChooser.showOpenDialog(this.mainView.getFrame()) == 0) {
            Settings.set("last_used_firmware_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File firmware = fileChooser.getSelectedFile();
            this.textFieldModuleFirmwareFile.setText(firmware.getAbsolutePath());
        }
    }

    @Action(enabledProperty="connected")
    public void moduleFlashFile() {
        if (this.textFieldModuleFirmwareFile.getText() == null || this.textFieldModuleFirmwareFile.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.firmware_is_not_specified", new Object[0]), this.resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        final File firmwareFile = new File(this.textFieldModuleFirmwareFile.getText().trim());
        if (!firmwareFile.exists()) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.firmware_file_does_not_exist", new Object[0]), this.resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        int deviceId = 0;
        try {
            deviceId = ((SpravComboBoxModel)this.comboBoxModuleUpgradeType.getModel()).getCurrentId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deviceId <= 0) {
            JOptionPane.showMessageDialog(this.mainView.getFrame(), this.resourceMap.getString("error.select_device_to_upgrade", new Object[0]), this.resourceMap.getString("messageDialog.firmware_error.title", new Object[0]), 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this.mainView.getFrame(), this.resourceMap.getString("confirm.flash_module", new Object[0]), this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0) == 0) {
            final int device_id = deviceId;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] data = FileUtil.readBytes(firmwareFile);
                        TabbedPanelFirmwareUpdate.this.mainView.onProgressStart(TabbedPanelFirmwareUpdate.this.resourceMap.getString("progress.flashing_firmware", new Object[0]), true);
                        SerialCommandProcessor.flashModuleFirmware(data, device_id, SimpleBGC_GUIApp.mainView);
                        ErrorInfo.updateStatus(TabbedPanelFirmwareUpdate.this.resourceMap.getString("status.flashing_firmware_done", new Object[0]));
                    }
                    catch (Exception e) {
                        TabbedPanelFirmwareUpdate.this.mainView.showErrorMessage(e.getMessage());
                        return;
                    }
                    finally {
                        TabbedPanelFirmwareUpdate.this.mainView.onProgressFinish(true);
                    }
                    TabbedPanelFirmwareUpdate.this.mainView.onProgressStart(TabbedPanelFirmwareUpdate.this.resourceMap.getString("progress.restarting_board", new Object[0]), true);
                    try {
                        SerialCommandProcessor.sendCommand(new SerialCommand(114));
                        SerialCommandProcessor.waitForReset(SimpleBGC_GUIApp.mainView);
                    }
                    catch (Exception e) {
                        TabbedPanelFirmwareUpdate.this.mainView.showErrorMessage(e.getMessage());
                        return;
                    }
                    finally {
                        TabbedPanelFirmwareUpdate.this.mainView.onProgressFinish(true);
                    }
                }
            }).start();
        }
    }

    @Action(enabledProperty="connected")
    public void buttonModuleListRefresh() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TabbedPanelFirmwareUpdate.this.mainView.onProgressStart(TabbedPanelFirmwareUpdate.this.resourceMap.getString("progress.refresh_connected_modules", new Object[0]), true);
                try {
                    ArrayList<Sprav> list = SerialCommandProcessor.requestModuleList(TabbedPanelFirmwareUpdate.this.mainView);
                    if (list != null) {
                        TabbedPanelFirmwareUpdate.this.comboBoxModuleUpgradeType.setModel(new SpravComboBoxModel(list));
                        if (list.size() > 0) {
                            TabbedPanelFirmwareUpdate.this.comboBoxModuleUpgradeType.setSelectedIndex(0);
                        }
                    }
                }
                catch (InterruptedException list) {
                }
                catch (Exception e) {
                    TabbedPanelFirmwareUpdate.this.mainView.showErrorMessage(e.toString());
                }
                finally {
                    TabbedPanelFirmwareUpdate.this.mainView.onProgressFinish(true);
                }
            }
        }).start();
    }

    public void upgrade(File firmwareHexFile, IFirmwareInfo firmwareInfo, BoardInfo boardInfo, String portName, File saveFile) {
        DialogFirmwareUpgrade dialog = new DialogFirmwareUpgrade(this.mainView);
        FirmwareUpgraderImpl firmwareUpgrader = new FirmwareUpgraderImpl(this.mainView, boardInfo, firmwareInfo, portName, firmwareHexFile, dialog, dialog, dialog, saveFile);
        dialog.start(new Thread(firmwareUpgrader));
    }

    @Action
    public void buttonSaveFile() {
        this.upgradeFirmwareFromList(true);
    }

    private File firmwareSaveFileDialog() {
        String path = new BGCJFileSaver(this, new String[]{"hex", "bin"}, this.resourceMap.getString("messageDialog.firmware_hex_bin_file.title", new Object[0]), "last_used_firmware_directory").getFilePath(null, true);
        return path != null ? new File(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void buttonLicWrite() {
        try {
            String msg;
            int type = ((SpravComboBoxModel)this.jComboBoxLicType.getModel()).getCurrentId();
            if (type == 0) {
                throw new Exception("Please select the license type!");
            }
            int fileId = 3072 + type;
            this.mainView.onProgressStart("Writing license to the board..", false);
            byte[] data = DatatypeConverter.parseHexBinary((String)this.jTextAreaLic.getText());
            if (data.length > 0) {
                if (data[0] != type) {
                    throw new Exception("Licens data doesn't match the selected type");
                }
                SerialCommandProcessor.writeFile(fileId, data, this.mainView);
                msg = "License is written to the board. System has to be restarted to apply it.";
            } else if (this.mainView.showConfirmDialog("Do you want to delete license \"" + BoardInfo.getExtLicName(type) + "\"?", true)) {
                SerialCommandProcessor.writeFile(fileId, data, this.mainView);
                msg = "License is deleted";
            } else {
                return;
            }
            this.jTextAreaLicInfo.setText(msg + "\n");
            this.extLicRefresh();
        }
        catch (Exception e) {
            this.mainView.showErrorMessage(e.getMessage());
        }
        finally {
            this.mainView.onProgressFinish(true);
        }
    }

    @Action
    public void buttonLicRefresh() {
        this.jTextAreaLicInfo.setText("Requesting license information from the board...\n");
        this.extLicRefresh();
    }

    void extLicRefresh() {
        block6: {
            try {
                SerialCommand cmd = new SerialCommand(124);
                SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 5000L);
                if (resp.id == 124) {
                    if (resp.getBytesAvailable() > 0) {
                        while (resp.getBytesAvailable() > 0) {
                            int type = resp.readByte();
                            int parse_status = resp.readByte();
                            resp.skipBytes(10);
                            this.jTextAreaLicInfo.append(BoardInfo.getExtLicName(type) + " status:\t" + BoardInfo.getExtLicParseStatus(parse_status) + "\n");
                        }
                    } else {
                        this.jTextAreaLicInfo.append("No licenses found.\n");
                    }
                    break block6;
                }
                throw new Exception("No response on command.");
            }
            catch (Exception e) {
                this.jTextAreaLicInfo.append("Failed to request licenses information: " + e.getMessage() + "\n");
            }
        }
    }

    @Action
    public void buttonBoardSNCopy() {
        StringSelection stringSelection = new StringSelection(this.jTextFieldBoardId.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
        this.mainView.updateStatus("Board S/N is copied to clipboard");
    }
}

